/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringApiBundle;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.contexts.model.XmlSpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.converters.fixes.bean.SpringBeanResolveQuickFixManager;
import com.intellij.spring.model.utils.SpringBeanUtils;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.TypeHolder;
import com.intellij.spring.model.xml.beans.TypeHolderUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.impl.GenericDomValueReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBeanResolveConverter
extends ResolvingConverter<SpringBeanPointer<?>>
implements CustomReferenceConverter {
    public boolean canResolveTo(@NotNull Class<? extends PsiElement> elementClass) {
        if (elementClass == null) {
            SpringBeanResolveConverter.$$$reportNull$$$0(0);
        }
        return ReflectionUtil.isAssignable(SpringBeanPointer.class, elementClass);
    }

    @Nullable
    protected CommonSpringModel getSpringModel(ConvertContext context) {
        return SpringManager.getInstance(context.getFile().getProject()).getSpringModelByFile((PsiFile)context.getFile());
    }

    @NotNull
    public List<PsiClassType> getRequiredClasses(ConvertContext context) {
        List<PsiClassType> list = SpringConverterUtil.getRequiredBeanTypeClasses(context);
        if (list == null) {
            SpringBeanResolveConverter.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    public SpringBeanPointer<?> fromString(@Nullable String s, @NotNull ConvertContext context) {
        if (context == null) {
            SpringBeanResolveConverter.$$$reportNull$$$0(2);
        }
        if (s == null) {
            return null;
        }
        SpringBeanPointer<?> pointer = SpringBeanResolveConverter.findBeanInLocalModelAndDependencies(s, context);
        if (pointer != null) {
            return pointer;
        }
        CommonSpringModel springModel = this.getSpringModel(context);
        if (springModel == null) {
            return null;
        }
        return SpringBeanUtils.getInstance().findBean(springModel, s);
    }

    @Nullable
    private static SpringBeanPointer<?> findBeanInLocalModelAndDependencies(@NotNull String s, ConvertContext context) {
        Module module;
        if (s == null) {
            SpringBeanResolveConverter.$$$reportNull$$$0(3);
        }
        if ((module = context.getModule()) != null) {
            XmlFile file = context.getFile();
            LocalXmlModel localXmlModel = SpringLocalModelFactory.getInstance().getOrCreateLocalXmlModel(file, module, Collections.emptySet());
            if (localXmlModel != null) {
                return SpringBeanUtils.getInstance().findBean(localXmlModel, s);
            }
        }
        return null;
    }

    public String toString(@Nullable SpringBeanPointer<?> springBeanPointer, @NotNull ConvertContext context) {
        if (context == null) {
            SpringBeanResolveConverter.$$$reportNull$$$0(4);
        }
        return springBeanPointer == null ? null : springBeanPointer.getName();
    }

    public LookupElement createLookupElement(SpringBeanPointer springBeanPointer) {
        return SpringConverterUtil.createCompletionVariant(springBeanPointer);
    }

    public PsiElement getPsiElement(@Nullable SpringBeanPointer<?> resolvedValue) {
        if (resolvedValue == null || !resolvedValue.isValid()) {
            return null;
        }
        return resolvedValue.getPsiElement();
    }

    public String getErrorMessage(String s, @NotNull ConvertContext context) {
        if (context == null) {
            SpringBeanResolveConverter.$$$reportNull$$$0(5);
        }
        return SpringApiBundle.message("model.bean.error.message", s);
    }

    public PsiReference @NotNull [] createReferences(GenericDomValue value, PsiElement element, ConvertContext context) {
        if (SpringBeanResolveConverter.isPlaceholder(context)) {
            PsiReference[] psiReferenceArray = (PsiReference[])ArrayUtil.append((Object[])PlaceholderUtils.getInstance().createPlaceholderPropertiesReferences(value), (Object)new GenericDomValueReference(value));
            if (psiReferenceArray == null) {
                SpringBeanResolveConverter.$$$reportNull$$$0(6);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            SpringBeanResolveConverter.$$$reportNull$$$0(7);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    public LocalQuickFix[] getQuickFixes(@NotNull ConvertContext context) {
        if (context == null) {
            SpringBeanResolveConverter.$$$reportNull$$$0(8);
        }
        GenericDomValue element = (GenericDomValue)context.getInvocationElement();
        return SpringBeanResolveQuickFixManager.getInstance().getQuickFixes(context, (Beans)element.getParentOfType(Beans.class, false), null, this.getRequiredClasses(context));
    }

    @NotNull
    public Collection<SpringBeanPointer<?>> getVariants(@NotNull ConvertContext context) {
        if (context == null) {
            SpringBeanResolveConverter.$$$reportNull$$$0(9);
        }
        if (SpringBeanResolveConverter.isPlaceholder(context)) {
            Set<SpringBeanPointer<?>> set = Collections.emptySet();
            if (set == null) {
                SpringBeanResolveConverter.$$$reportNull$$$0(10);
            }
            return set;
        }
        Collection<SpringBeanPointer<?>> collection = SpringBeanResolveConverter.getVariants(context, false, false, this.getRequiredClasses(context), this.getSpringModel(context));
        if (collection == null) {
            SpringBeanResolveConverter.$$$reportNull$$$0(11);
        }
        return collection;
    }

    protected static boolean isPlaceholder(ConvertContext context) {
        DomElement element = context.getInvocationElement();
        return element instanceof GenericDomValue && PlaceholderUtils.getInstance().isRawTextPlaceholder((GenericDomValue)element);
    }

    protected static Collection<SpringBeanPointer<?>> getVariants(ConvertContext context, boolean parentBeans, boolean allowAbstracts, List<PsiClassType> requiredClasses, CommonSpringModel model) {
        PsiClassType object;
        if (model == null) {
            return Collections.emptyList();
        }
        ArrayList variants = new ArrayList();
        CommonSpringBean currentBean = SpringConverterUtil.getCurrentBeanCustomAware(context);
        if (!requiredClasses.isEmpty() && requiredClasses.contains(object = PsiType.getJavaLangObject((PsiManager)context.getPsiManager(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)context.getProject())))) {
            requiredClasses = new ArrayList<PsiClassType>(requiredClasses);
            requiredClasses.remove(object);
        }
        Collection<SpringBeanPointer<?>> pointers = SpringBeanResolveConverter.getModelVariants(parentBeans, model, requiredClasses, currentBean);
        SpringConverterUtil.processBeans(model, variants, pointers, allowAbstracts, currentBean);
        return variants;
    }

    private static Collection<SpringBeanPointer<?>> getModelVariants(boolean parentBeans, CommonSpringModel model, @NotNull List<PsiClassType> requiredClasses, CommonSpringBean currentBean) {
        if (requiredClasses == null) {
            SpringBeanResolveConverter.$$$reportNull$$$0(12);
        }
        if (parentBeans) {
            if (model instanceof XmlSpringModel) {
                ArrayList allBeans = new ArrayList();
                for (SpringModel springModel : ((XmlSpringModel)model).getDependencies()) {
                    if (requiredClasses.isEmpty()) {
                        allBeans.addAll(springModel.getAllCommonBeans());
                        continue;
                    }
                    allBeans.addAll(SpringConverterUtil.getSmartVariants(currentBean, requiredClasses, model));
                }
                return allBeans;
            }
            return Collections.emptySet();
        }
        return requiredClasses.isEmpty() ? model.getAllCommonBeans() : SpringConverterUtil.getSmartVariants(currentBean, requiredClasses, model);
    }

    @NotNull
    protected static List<PsiClassType> getValueClasses(ConvertContext context) {
        TypeHolder valueHolder = (TypeHolder)context.getInvocationElement().getParentOfType(TypeHolder.class, false);
        if (valueHolder == null) {
            List<PsiClassType> list = Collections.emptyList();
            if (list == null) {
                SpringBeanResolveConverter.$$$reportNull$$$0(13);
            }
            return list;
        }
        List list = ContainerUtil.findAll(TypeHolderUtil.getRequiredTypes(valueHolder), PsiClassType.class);
        if (list == null) {
            SpringBeanResolveConverter.$$$reportNull$$$0(14);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6, 7, 10, 11, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/converters/SpringBeanResolveConverter";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/converters/SpringBeanResolveConverter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredClasses";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canResolveTo";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findBeanInLocalModelAndDependencies";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixes";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getVariants";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getModelVariants";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6, 7, 10, 11, 13, 14 -> new IllegalStateException(string);
        };
    }

    public static class Parent
    extends SpringBeanResolveConverter {
        @Override
        @NotNull
        public Collection<SpringBeanPointer<?>> getVariants(@NotNull ConvertContext context) {
            if (context == null) {
                Parent.$$$reportNull$$$0(0);
            }
            Collection<SpringBeanPointer<?>> collection = Parent.getVariants(context, false, true, this.getRequiredClasses(context), this.getSpringModel(context));
            if (collection == null) {
                Parent.$$$reportNull$$$0(1);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/model/converters/SpringBeanResolveConverter$Parent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/model/converters/SpringBeanResolveConverter$Parent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getVariants";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class PropertyBean
    extends SpringBeanResolveConverter {
        @Override
        @NotNull
        public List<PsiClassType> getRequiredClasses(ConvertContext context) {
            List<PsiClassType> list = PropertyBean.getValueClasses(context);
            if (list == null) {
                PropertyBean.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/SpringBeanResolveConverter$PropertyBean", "getRequiredClasses"));
        }
    }
}

