/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.psi.resolve.reference.impl.providers;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.web.WebContextManager;
import com.intellij.javaee.web.WebDirectoryElement;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetContextFolderFix
implements LocalQuickFix,
IntentionAction {
    private final PsiFileSystemItem myTarget;
    private final PsiFileSystemItem myContextFolder;

    public static SetContextFolderFix @Nullable [] create(@NotNull FileReference reference, @NotNull WebFacet facet) {
        if (reference == null) {
            SetContextFolderFix.$$$reportNull$$$0(0);
        }
        if (facet == null) {
            SetContextFolderFix.$$$reportNull$$$0(1);
        }
        if (reference.getFileReferenceSet().isAbsolutePathReference()) {
            return null;
        }
        PsiFile psiFile = reference.getElement().getContainingFile();
        if (psiFile == null) {
            return null;
        }
        final WebDirectoryElement root = WebUtil.getWebUtil().findWebDirectoryElement("/", facet);
        if (root == null) {
            return null;
        }
        FileReference first = reference.getFileReferenceSet().getAllReferences()[0];
        FileReference fixedReference = new FileReference(first){

            @NotNull
            protected Collection<PsiFileSystemItem> getContexts() {
                Set<WebDirectoryElement> set = Collections.singleton(root);
                if (set == null) {
                    1.$$$reportNull$$$0(0);
                }
                return set;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/psi/resolve/reference/impl/providers/SetContextFolderFix$1", "getContexts"));
            }
        };
        PsiDirectory parent = psiFile.getParent();
        if (fixedReference.multiResolve(false).length == 0) {
            return null;
        }
        if (parent != null) {
            return new SetContextFolderFix[]{new SetContextFolderFix((PsiFileSystemItem)root, (PsiFileSystemItem)psiFile), new SetContextFolderFix((PsiFileSystemItem)root, (PsiFileSystemItem)parent)};
        }
        return new SetContextFolderFix[]{new SetContextFolderFix((PsiFileSystemItem)root, (PsiFileSystemItem)psiFile)};
    }

    public SetContextFolderFix(@NotNull PsiFileSystemItem contextFolder, @NotNull PsiFileSystemItem target) {
        if (contextFolder == null) {
            SetContextFolderFix.$$$reportNull$$$0(2);
        }
        if (target == null) {
            SetContextFolderFix.$$$reportNull$$$0(3);
        }
        this.myContextFolder = contextFolder;
        this.myTarget = target;
    }

    @NotNull
    @IntentionName
    public String getName() {
        String string = !this.myTarget.isDirectory() ? J2EEBundle.message((String)"web.context.fix", (Object[])new Object[]{this.myTarget.getName()}) : J2EEBundle.message((String)"web.context.fix.for.directory", (Object[])new Object[]{this.myTarget.getName()});
        if (string == null) {
            SetContextFolderFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getName();
        if (string == null) {
            SetContextFolderFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = J2EEBundle.message((String)"web.context.family", (Object[])new Object[0]);
        if (string == null) {
            SetContextFolderFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            SetContextFolderFix.$$$reportNull$$$0(7);
        }
        return true;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        if (file == null) {
            SetContextFolderFix.$$$reportNull$$$0(8);
        }
        return null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            SetContextFolderFix.$$$reportNull$$$0(9);
        }
        WebContextManager.getInstance((Project)project).setContextFolder(this.myTarget, this.myContextFolder);
        DaemonCodeAnalyzer.getInstance((Project)project).restart((Object)this);
    }

    public boolean startInWriteAction() {
        return true;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            SetContextFolderFix.$$$reportNull$$$0(10);
        }
        if (descriptor == null) {
            SetContextFolderFix.$$$reportNull$$$0(11);
        }
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            SetContextFolderFix.$$$reportNull$$$0(12);
        }
        if (editor == null) {
            SetContextFolderFix.$$$reportNull$$$0(13);
        }
        if (psiFile == null) {
            SetContextFolderFix.$$$reportNull$$$0(14);
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        if (intentionPreviewInfo == null) {
            SetContextFolderFix.$$$reportNull$$$0(15);
        }
        return intentionPreviewInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFolder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/web/psi/resolve/reference/impl/providers/SetContextFolderFix";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/web/psi/resolve/reference/impl/providers/SetContextFolderFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 15: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 15 -> new IllegalStateException(string);
        };
    }
}

