/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.generate;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.DependencyConflictId;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.generate.GenerateManagedDependencyAction;
import org.jetbrains.idea.maven.dom.generate.MavenGenerateProvider;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencies;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencyManagement;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.indices.MavenArtifactSearchDialog;
import org.jetbrains.idea.maven.model.MavenCoordinate;
import org.jetbrains.idea.maven.model.MavenId;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014JH\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0016\u0010\u000b\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0006\u0012\u0004\u0018\u00010\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/idea/maven/dom/generate/GenerateDependencyProvider;", "Lorg/jetbrains/idea/maven/dom/generate/MavenGenerateProvider;", "Lorg/jetbrains/idea/maven/dom/model/MavenDomDependency;", "<init>", "()V", "doGenerate", "mavenModel", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "createDependencyInWriteAction", "managedDependencies", "", "Lorg/jetbrains/idea/maven/dom/DependencyConflictId;", "ids", "", "Lorg/jetbrains/idea/maven/model/MavenCoordinate;", "psiFile", "Lcom/intellij/psi/xml/XmlFile;", "Companion", "intellij.maven"})
public final class GenerateDependencyProvider
extends MavenGenerateProvider<MavenDomDependency> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public GenerateDependencyProvider() {
        super(MavenDomBundle.message("generate.dependency.title", new Object[0]), MavenDomDependency.class);
    }

    @Override
    @Nullable
    protected MavenDomDependency doGenerate(@NotNull MavenDomProjectModel mavenModel, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)mavenModel, (String)"mavenModel");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Project project = mavenModel.getManager().getProject();
        Map<DependencyConflictId, MavenDomDependency> map = GenerateManagedDependencyAction.collectManagingDependencies(mavenModel);
        Intrinsics.checkNotNullExpressionValue(map, (String)"collectManagingDependencies(...)");
        Map<DependencyConflictId, MavenDomDependency> managedDependencies = map;
        List<MavenId> list = MavenArtifactSearchDialog.searchForArtifact(project, managedDependencies.values());
        Intrinsics.checkNotNullExpressionValue(list, (String)"searchForArtifact(...)");
        List<MavenId> ids = list;
        if (ids.isEmpty()) {
            return null;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        XmlFile xmlFile = DomUtil.getFile((DomElement)mavenModel);
        Intrinsics.checkNotNullExpressionValue((Object)xmlFile, (String)"getFile(...)");
        XmlFile psiFile = xmlFile;
        return this.createDependencyInWriteAction(mavenModel, editor, managedDependencies, ids, psiFile);
    }

    private final MavenDomDependency createDependencyInWriteAction(MavenDomProjectModel mavenModel, Editor editor, Map<DependencyConflictId, MavenDomDependency> managedDependencies, List<? extends MavenCoordinate> ids, XmlFile psiFile) {
        PsiFile[] psiFileArray = new PsiFile[]{psiFile};
        return (MavenDomDependency)WriteCommandAction.writeCommandAction((Project)psiFile.getProject(), (PsiFile[])psiFileArray).withName(MavenDomBundle.message("generate.dependency", new Object[0])).compute(() -> GenerateDependencyProvider.createDependencyInWriteAction$lambda$0(mavenModel, editor, managedDependencies, ids));
    }

    private static final MavenDomDependency createDependencyInWriteAction$lambda$0(MavenDomProjectModel $mavenModel, Editor $editor, Map $managedDependencies, List $ids) {
        return Companion.createDependency($mavenModel, $editor, $managedDependencies, $ids);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J>\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0016\u0010\n\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/idea/maven/dom/generate/GenerateDependencyProvider$Companion;", "", "<init>", "()V", "createDependency", "Lorg/jetbrains/idea/maven/dom/model/MavenDomDependency;", "mavenModel", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "managedDependencies", "", "Lorg/jetbrains/idea/maven/dom/DependencyConflictId;", "ids", "", "Lorg/jetbrains/idea/maven/model/MavenCoordinate;", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final MavenDomDependency createDependency(@NotNull MavenDomProjectModel mavenModel, @NotNull Editor editor, @NotNull Map<DependencyConflictId, MavenDomDependency> managedDependencies, @NotNull List<? extends MavenCoordinate> ids) {
            Intrinsics.checkNotNullParameter((Object)mavenModel, (String)"mavenModel");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter(managedDependencies, (String)"managedDependencies");
            Intrinsics.checkNotNullParameter(ids, (String)"ids");
            boolean isInsideManagedDependencies = false;
            MavenDomDependencyManagement mavenDomDependencyManagement = mavenModel.getDependencyManagement();
            Intrinsics.checkNotNullExpressionValue((Object)mavenDomDependencyManagement, (String)"getDependencyManagement(...)");
            MavenDomDependencyManagement dependencyManagement = mavenDomDependencyManagement;
            XmlElement managedDependencyXml = dependencyManagement.getXmlElement();
            isInsideManagedDependencies = managedDependencyXml != null && managedDependencyXml.getTextRange().contains(editor.getCaretModel().getOffset());
            Iterator<? extends MavenCoordinate> iterator = ids.iterator();
            if (iterator.hasNext()) {
                MavenCoordinate each = iterator.next();
                MavenDomDependency res = null;
                if (isInsideManagedDependencies) {
                    MavenDomDependencies mavenDomDependencies = dependencyManagement.getDependencies();
                    Intrinsics.checkNotNullExpressionValue((Object)mavenDomDependencies, (String)"getDependencies(...)");
                    res = MavenDomUtil.createDomDependency(mavenDomDependencies, editor, each);
                } else {
                    DependencyConflictId conflictId = new DependencyConflictId(each.getGroupId(), each.getArtifactId(), null, null);
                    MavenDomDependency managedDependenciesDom = managedDependencies.get(conflictId);
                    if (managedDependenciesDom != null && Intrinsics.areEqual((Object)each.getVersion(), (Object)managedDependenciesDom.getVersion().getStringValue())) {
                        MavenDomDependencies mavenDomDependencies = mavenModel.getDependencies();
                        Intrinsics.checkNotNullExpressionValue((Object)mavenDomDependencies, (String)"getDependencies(...)");
                        res = MavenDomUtil.createDomDependency(mavenDomDependencies, editor);
                        res.getGroupId().setStringValue(conflictId.getGroupId());
                        res.getArtifactId().setStringValue(conflictId.getArtifactId());
                    } else {
                        MavenDomDependencies mavenDomDependencies = mavenModel.getDependencies();
                        Intrinsics.checkNotNullExpressionValue((Object)mavenDomDependencies, (String)"getDependencies(...)");
                        res = MavenDomUtil.createDomDependency(mavenDomDependencies, editor, each);
                    }
                }
                return res;
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

