/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config.datasource;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.persistence.database.ConfigurationFileInfo;
import com.intellij.persistence.database.DataSourcePropertyWithPrefixDataInfo;
import com.intellij.persistence.database.RecognizedDatabaseConfig;
import com.intellij.persistence.database.config.impl.DataSourceKeyType;
import com.intellij.persistence.database.config.impl.urlParser.CassandraUrl;
import com.intellij.persistence.database.config.impl.urlParser.DatabaseType;
import com.intellij.persistence.database.config.impl.urlParser.DatabasesKt;
import com.intellij.quarkus.config.datasource.QsCassandraDataSourcesKeyTypes;
import com.intellij.quarkus.config.datasource.QsConfigPropertyValueSearcher;
import com.intellij.quarkus.config.datasource.QsConfigProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J$\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000eH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/quarkus/config/datasource/QsCassandraDataSourceConfigProvider;", "Lcom/intellij/quarkus/config/datasource/QsConfigProvider;", "<init>", "()V", "getConfigs", "", "Lcom/intellij/persistence/database/RecognizedDatabaseConfig;", "fileInfo", "Lcom/intellij/persistence/database/ConfigurationFileInfo;", "propertyInfo", "Lcom/intellij/persistence/database/DataSourcePropertyWithPrefixDataInfo;", "retrieveUrls", "Lcom/intellij/persistence/database/config/impl/urlParser/CassandraUrl;", "collected", "", "Lcom/intellij/persistence/database/config/impl/DataSourceKeyType;", "", "intellij.quarkus"})
@SourceDebugExtension(value={"SMAP\nQsCassandraDataSourceConfigProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QsCassandraDataSourceConfigProvider.kt\ncom/intellij/quarkus/config/datasource/QsCassandraDataSourceConfigProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,56:1\n1563#2:57\n1634#2,3:58\n1563#2:61\n1634#2,3:62\n*S KotlinDebug\n*F\n+ 1 QsCassandraDataSourceConfigProvider.kt\ncom/intellij/quarkus/config/datasource/QsCassandraDataSourceConfigProvider\n*L\n29#1:57\n29#1:58,3\n44#1:61\n44#1:62,3\n*E\n"})
public final class QsCassandraDataSourceConfigProvider
extends QsConfigProvider {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<RecognizedDatabaseConfig> getConfigs(@NotNull ConfigurationFileInfo fileInfo, @NotNull DataSourcePropertyWithPrefixDataInfo propertyInfo) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)fileInfo, (String)"fileInfo");
        Intrinsics.checkNotNullParameter((Object)propertyInfo, (String)"propertyInfo");
        DatabaseDriver databaseDriver = DatabasesKt.findDatabaseDriver((DatabaseType)DatabaseType.CASSANDRA);
        if (databaseDriver == null) {
            return CollectionsKt.emptyList();
        }
        DatabaseDriver driver = databaseDriver;
        QsConfigPropertyValueSearcher valueSearcher = new QsConfigPropertyValueSearcher(fileInfo, propertyInfo.getDocumentId());
        Map collected = this.collectValues((List)QsCassandraDataSourcesKeyTypes.getEntries(), propertyInfo, valueSearcher);
        List<CassandraUrl> urls = this.retrieveUrls(collected);
        Iterable $this$map$iv = urls;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void url;
            CassandraUrl cassandraUrl = (CassandraUrl)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = url.toDbDialogUrl();
            String string2 = driver.getDriverClass();
            if (string2 == null) {
                string2 = "";
            }
            collection.add(new RecognizedDatabaseConfig(string, string2, (String)collected.get((Object)QsCassandraDataSourcesKeyTypes.QS_CASSANDRA_USER), (String)collected.get((Object)QsCassandraDataSourcesKeyTypes.QS_CASSANDRA_PASSWORD), url.dataSourceItemName()));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<CassandraUrl> retrieveUrls(Map<DataSourceKeyType, String> collected) {
        void $this$mapTo$iv$iv;
        String[] stringArray;
        Object object = collected.get((Object)QsCassandraDataSourcesKeyTypes.QS_CASSANDRA_CONTACT_POINTS);
        if (object == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{","}), (boolean)false, (int)0, (int)6, null)) == null) {
            object = CollectionsKt.listOf((Object)"127.0.0.1");
        }
        Object contactPoints = object;
        String keySpace = collected.get((Object)QsCassandraDataSourcesKeyTypes.QS_CASSANDRA_KEYSPACE);
        Iterable $this$map$iv = (Iterable)contactPoints;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void point;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray2 = new String[]{":"};
            List hostPort = StringsKt.split$default((CharSequence)((CharSequence)point), (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            String string2 = (String)CollectionsKt.getOrNull((List)hostPort, (int)0);
            if (string2 == null) {
                string2 = "127.0.0.1";
            }
            String host = string2;
            Object object2 = (String)CollectionsKt.getOrNull((List)hostPort, (int)1);
            int specifiedPort = object2 != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? (Integer)object2 : 9042;
            collection.add(new CassandraUrl(host, specifiedPort, keySpace));
        }
        return (List)destination$iv$iv;
    }
}

