import {__log, __null_aware_to_string, Variables, Environment, __nullableParameterCheck, InPlaceVariables} from 'js-graalvm-stdlib.js'
import {jwt} from "js-graalvm-jwt.js"

Object.defineProperty(globalThis, "request", {
  value: {
    variables: new Variables([]),
    body: new Body(__args.elementsProvider),
    url: new Url(__args.elementsProvider),
    headers: new Headers(__args.elementsProvider),
    environment: new Environment(__args.elementsProvider),
    method: '' + __args.elementsProvider.getMethod(),
    iteration: function() {
      return __args.elementsProvider.iteration()
    },
    templateValue: function(number) {
      return __args.elementsProvider.templateValue(number)
    }
  }
})

function HttpClient() {
  const self = this
  this.global = new Variables(__args.global)
  this.variables = {
    global: self.global,
    environment: new Environment(__args.elementsProvider),
    file: new InPlaceVariables(__args.elementsProvider),
    request: request.variables,
  }
  this.log = __log
}

function Body(elementsProvider) {
  this.__raw = elementsProvider.getRawBody()
  this.__substituted = elementsProvider.getSubstitutedBody()

  this.getRaw = function () {
    return __null_aware_to_string(this.__raw.getValue())
  }

  this.tryGetSubstituted = function () {
    return __null_aware_to_string(this.__substituted.getValue())
  }
}



function Header(header) {
  this.name = __null_aware_to_string(header.name)
  this.__raw = header.getRawValue()
  this.__substituted = header.getSubstitutedValue()

  this.getRawValue = function () {
    return __null_aware_to_string(this.__raw.getValue())
  }

  this.tryGetSubstitutedValue = function () {
    return __null_aware_to_string(this.__substituted.getValue())
  }
}

function Headers(provider) {
  this.__headers = provider.getHeaders()

  this.all = function () {
    const result = []
    for (const h of this.__headers) {
      result.push(new Header(h))
    }
    return result
  }

  this.findByName = function (name) {
    const result = this.__headers.getHeader(name)
    return result !== null ? new Header(result) : null
  }
}

function Url(elementsProvider) {
  this.__raw = elementsProvider.getRawUrl()
  this.__substituted = elementsProvider.getSubstitutedUrl()

  this.getRaw = function () {
    return __null_aware_to_string(this.__raw.getValue())
  }

  this.tryGetSubstituted = function () {
    return __null_aware_to_string(this.__substituted.getValue())
  }
}

function Digest(delegate) {
  this.toBase64 = function (urlSafe) {
    return __null_aware_to_string(delegate.toBase64(!!(urlSafe || false)))
  }

  this.toHex = function () {
    return __null_aware_to_string(delegate.toHex())
  }
}

function DigestBuilder(delegate) {
  this.updateWithText = function (message, encoding) {
    __nullableParameterCheck(message)
    delegate.updateWithText(message, encoding || null)
    return this
  }

  this.updateWithHex = function (hex) {
    __nullableParameterCheck(hex)
    delegate.updateWithHex(hex)
    return this
  }

  this.updateWithBase64 = function (base64Text, urlSafe) {
    __nullableParameterCheck(base64Text)
    delegate.updateWithBase64(base64Text, !!(urlSafe || false))
    return this
  }

  this.digest = function () {
    return new Digest(delegate.digest())
  }
}

function HmacSupport(delegate) {
  this.sha1 = function () {
    return new HmacInitializer(delegate.sha1())
  }

  this.sha3 = function (bits) {
    return new HmacInitializer(delegate.sha3(bits))
  }

  this.sha256 = function () {
    return new HmacInitializer(delegate.sha256())
  }

  this.sha512 = function () {
    return new HmacInitializer(delegate.sha512())
  }

  this.sha384 = function () {
    return new HmacInitializer(delegate.sha384())
  }

  this.md5 = function () {
    return new HmacInitializer(delegate.md5())
  }
}

function HmacInitializer(delegate) {
  this.withTextSecret = function (secret, encoding) {
    __nullableParameterCheck(secret)
    return new DigestBuilder(delegate.withTextSecret(secret, encoding || null))
  }

  this.withHexSecret = function (hex) {
    __nullableParameterCheck(hex)
    return new DigestBuilder(delegate.withHexSecret(hex))
  }

  this.withBase64Secret = function (base64Secret, urlSafe) {
    __nullableParameterCheck(base64Secret)
    return new DigestBuilder(delegate.withBase64Secret(base64Secret, !!(urlSafe || false)))
  }
}

function Crypto(delegate, rsaDelegate) {
  this.hmac = new HmacSupport(delegate.hmacSupport())
  this.subtle = new SubtleCrypto(rsaDelegate.subtleSupport())

  this.sha1 = function () {
    return new DigestBuilder(delegate.sha1())
  }

  this.sha3 = function (bits) {
    return new DigestBuilder(delegate.sha3(bits))
  }

  this.sha256 = function () {
    return new DigestBuilder(delegate.sha256())
  }

  this.sha512 = function () {
    return new DigestBuilder(delegate.sha512())
  }

  this.sha384 = function () {
    return new DigestBuilder(delegate.sha384())
  }

  this.md5 = function () {
    return new DigestBuilder(delegate.md5())
  }

  /**
   * Generate a random UUID.
   * this function was added to compatibility with Web/API/Crypto/randomUUID
   * @returns {string}
   */
  this.randomUUID = function () {
    return $uuid
  }
}

function SubtleCrypto(delegate) {
  this.importKey =  (format, keyData, algorithm, exractable, keyUsages) => {
    return delegate.importKey(format, keyData, algorithm, exractable, keyUsages)
  }

  this.generateKey = (algorithm, extractable, keyUsages) => {
    return delegate.generateKey(algorithm, extractable, keyUsages)
  }

  this.encrypt = (algorithm, key, data) => {
    let dataArray;
    if (typeof data === 'string' || data instanceof String) {
      dataArray = string2byteArray(data)
    } else if (data instanceof Array) {
      dataArray = new Uint8Array(data)
    } else if (data instanceof Uint8Array) {
      dataArray = data
    } else {
      throw new Error(`Unsupported data type: ${typeof data}`)
    }
    return delegate.encrypt(algorithm, key, dataArray)
  }

  this.decrypt = (algorithm, key, data) => {
    return delegate.decrypt(algorithm, key, data)
  }

  this.sign = (algorithm, key, data) => {
    let dataArray;
    if (typeof data === 'string' || data instanceof String) {
      dataArray = string2byteArray(data)
    } else if (data instanceof Array) {
      dataArray = new Uint8Array(data)
    } else if (data instanceof Uint8Array) {
      dataArray = data
    } else {
      throw new Error(`Unsupported data type: ${typeof data}`)
    }
    return delegate.sign(algorithm, key, dataArray)
  }

  this.verify = (algorithm, key, signature, data) => {
    let dataArray;
    if (typeof data === 'string' || data instanceof String) {
      dataArray = string2byteArray(data)
    } else if (data instanceof Array) {
      dataArray = new Uint8Array(data)
    } else if (data instanceof Uint8Array) {
      dataArray = data
    } else {
      throw new Error(`Unsupported data type: ${typeof data}`)
    }
    return delegate.verify(algorithm, key, signature, dataArray)
  }

  this.exportKey = (format, key) => {
    return delegate.exportKey(format, key)
  }
}

function CryptoKey(delegate) {
  this.algorithm = delegate.algorithm
  this.extractable = delegate.extractable
  this.type = delegate.type
  this.usages = delegate.usages
}


Object.defineProperty(globalThis, "client", {
  value: new HttpClient()
})

Object.defineProperty(globalThis, "crypto", {
  value: new Crypto(__args.cryptoSupport, __args.rsaCryptoSupport)
})

Object.defineProperty(globalThis, "jwt", {
  value: jwt
});

export default {}