/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// CustomResourceDefinitionVersionApplyConfiguration represents a declarative configuration of the CustomResourceDefinitionVersion type for use
// with apply.
//
// CustomResourceDefinitionVersion describes a version for CRD.
type CustomResourceDefinitionVersionApplyConfiguration struct {
	// name is the version name, e.g. “v1”, “v2beta1”, etc.
	// The custom resources are served under this version at `/apis/<group>/<version>/...` if `served` is true.
	Name *string `json:"name,omitempty"`
	// served is a flag enabling/disabling this version from being served via REST APIs
	Served *bool `json:"served,omitempty"`
	// storage indicates this version should be used when persisting custom resources to storage.
	// There must be exactly one version with storage=true.
	Storage *bool `json:"storage,omitempty"`
	// deprecated indicates this version of the custom resource API is deprecated.
	// When set to true, API requests to this version receive a warning header in the server response.
	// Defaults to false.
	Deprecated *bool `json:"deprecated,omitempty"`
	// deprecationWarning overrides the default warning returned to API clients.
	// May only be set when `deprecated` is true.
	// The default warning indicates this version is deprecated and recommends use
	// of the newest served version of equal or greater stability, if one exists.
	DeprecationWarning *string `json:"deprecationWarning,omitempty"`
	// schema describes the schema used for validation, pruning, and defaulting of this version of the custom resource.
	Schema *CustomResourceValidationApplyConfiguration `json:"schema,omitempty"`
	// subresources specify what subresources this version of the defined custom resource have.
	Subresources *CustomResourceSubresourcesApplyConfiguration `json:"subresources,omitempty"`
	// additionalPrinterColumns specifies additional columns returned in Table output.
	// See https://kubernetes.io/docs/reference/using-api/api-concepts/#receiving-resources-as-tables for details.
	// If no columns are specified, a single column displaying the age of the custom resource is used.
	AdditionalPrinterColumns []CustomResourceColumnDefinitionApplyConfiguration `json:"additionalPrinterColumns,omitempty"`
	// selectableFields specifies paths to fields that may be used as field selectors.
	// A maximum of 8 selectable fields are allowed.
	// See https://kubernetes.io/docs/concepts/overview/working-with-objects/field-selectors
	SelectableFields []SelectableFieldApplyConfiguration `json:"selectableFields,omitempty"`
}

// CustomResourceDefinitionVersionApplyConfiguration constructs a declarative configuration of the CustomResourceDefinitionVersion type for use with
// apply.
func CustomResourceDefinitionVersion() *CustomResourceDefinitionVersionApplyConfiguration {
	return &CustomResourceDefinitionVersionApplyConfiguration{}
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *CustomResourceDefinitionVersionApplyConfiguration) WithName(value string) *CustomResourceDefinitionVersionApplyConfiguration {
	b.Name = &value
	return b
}

// WithServed sets the Served field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Served field is set to the value of the last call.
func (b *CustomResourceDefinitionVersionApplyConfiguration) WithServed(value bool) *CustomResourceDefinitionVersionApplyConfiguration {
	b.Served = &value
	return b
}

// WithStorage sets the Storage field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Storage field is set to the value of the last call.
func (b *CustomResourceDefinitionVersionApplyConfiguration) WithStorage(value bool) *CustomResourceDefinitionVersionApplyConfiguration {
	b.Storage = &value
	return b
}

// WithDeprecated sets the Deprecated field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Deprecated field is set to the value of the last call.
func (b *CustomResourceDefinitionVersionApplyConfiguration) WithDeprecated(value bool) *CustomResourceDefinitionVersionApplyConfiguration {
	b.Deprecated = &value
	return b
}

// WithDeprecationWarning sets the DeprecationWarning field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DeprecationWarning field is set to the value of the last call.
func (b *CustomResourceDefinitionVersionApplyConfiguration) WithDeprecationWarning(value string) *CustomResourceDefinitionVersionApplyConfiguration {
	b.DeprecationWarning = &value
	return b
}

// WithSchema sets the Schema field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Schema field is set to the value of the last call.
func (b *CustomResourceDefinitionVersionApplyConfiguration) WithSchema(value *CustomResourceValidationApplyConfiguration) *CustomResourceDefinitionVersionApplyConfiguration {
	b.Schema = value
	return b
}

// WithSubresources sets the Subresources field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Subresources field is set to the value of the last call.
func (b *CustomResourceDefinitionVersionApplyConfiguration) WithSubresources(value *CustomResourceSubresourcesApplyConfiguration) *CustomResourceDefinitionVersionApplyConfiguration {
	b.Subresources = value
	return b
}

// WithAdditionalPrinterColumns adds the given value to the AdditionalPrinterColumns field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the AdditionalPrinterColumns field.
func (b *CustomResourceDefinitionVersionApplyConfiguration) WithAdditionalPrinterColumns(values ...*CustomResourceColumnDefinitionApplyConfiguration) *CustomResourceDefinitionVersionApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithAdditionalPrinterColumns")
		}
		b.AdditionalPrinterColumns = append(b.AdditionalPrinterColumns, *values[i])
	}
	return b
}

// WithSelectableFields adds the given value to the SelectableFields field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the SelectableFields field.
func (b *CustomResourceDefinitionVersionApplyConfiguration) WithSelectableFields(values ...*SelectableFieldApplyConfiguration) *CustomResourceDefinitionVersionApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithSelectableFields")
		}
		b.SelectableFields = append(b.SelectableFields, *values[i])
	}
	return b
}
