/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.common.carets;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.codeInsight.hint.TooltipRenderer;
import com.intellij.cwm.plugin.common.carets.RemoteCaret;
import com.intellij.cwm.plugin.common.carets.RemoteCaretTooltipRenderer;
import com.intellij.cwm.plugin.common.carets.UsernameComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.CaretModelImpl;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.EdtInvocationManager;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J2\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0013\u0010\u0016\u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/cwm/plugin/common/carets/RemoteCaretTooltipRenderer;", "Lcom/intellij/codeInsight/hint/TooltipRenderer;", "caret", "Lcom/intellij/cwm/plugin/common/carets/RemoteCaret;", "timeout", "", "<init>", "(Lcom/intellij/cwm/plugin/common/carets/RemoteCaret;I)V", "getCaret", "()Lcom/intellij/cwm/plugin/common/carets/RemoteCaret;", "show", "Lcom/intellij/ui/LightweightHint;", "editor", "Lcom/intellij/openapi/editor/Editor;", "p", "Ljava/awt/Point;", "alignToRight", "", "group", "Lcom/intellij/codeInsight/hint/TooltipGroup;", "hintHint", "Lcom/intellij/ui/HintHint;", "equals", "other", "", "hashCode", "intellij.cwm.plugin.common"})
public final class RemoteCaretTooltipRenderer
implements TooltipRenderer {
    @NotNull
    private final RemoteCaret caret;
    private final int timeout;

    public RemoteCaretTooltipRenderer(@NotNull RemoteCaret caret, int timeout) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        this.caret = caret;
        this.timeout = timeout;
        boolean bl2 = bl = this.timeout >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    public /* synthetic */ RemoteCaretTooltipRenderer(RemoteCaret remoteCaret, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(remoteCaret, n);
    }

    @NotNull
    public final RemoteCaret getCaret() {
        return this.caret;
    }

    @Nullable
    public LightweightHint show(@NotNull Editor editor, @NotNull Point p, boolean alignToRight, @NotNull TooltipGroup group, @NotNull HintHint hintHint) {
        HintHint hintHint2;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)hintHint, (String)"hintHint");
        if (!this.caret.isValid()) {
            return null;
        }
        UsernameComponent tooltipComponent = new UsernameComponent(this.caret);
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkNotNull((Object)caretModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.CaretModelImpl");
        LifetimeDefinition lifetimeDef = LifetimeDisposableExKt.defineNestedLifetime((Disposable)((Disposable)((CaretModelImpl)caretModel)));
        LightweightHint hint2 = new LightweightHint(tooltipComponent, lifetimeDef){
            final /* synthetic */ LifetimeDefinition $lifetimeDef;
            {
                this.$lifetimeDef = $lifetimeDef;
                super((JComponent)$tooltipComponent);
            }

            public void hide() {
                this.$lifetimeDef.terminate(true);
                super.hide();
            }
        };
        this.caret.addRemoveListener((Lifetime)lifetimeDef, (Function0<Unit>)((Function0)() -> RemoteCaretTooltipRenderer.show$lambda$1(editor, hint2)));
        HintHint $this$show_u24lambda_u242 = hintHint2 = hintHint;
        boolean bl = false;
        $this$show_u24lambda_u242.initStyleFrom((JComponent)tooltipComponent);
        int height = tooltipComponent.getPreferredSize().height;
        RelativePoint targetPoint = hintHint.getTargetPoint();
        boolean enoughHeight = targetPoint.getOriginalPoint().y - editor.getScrollingModel().getVisibleArea().y > height;
        Point point = SwingUtilities.convertPoint(targetPoint.getOriginalComponent(), targetPoint.getOriginalPoint(), HintManagerImpl.getExternalComponent((Editor)editor));
        Point resultPoint = new Point(point.x, enoughHeight ? point.y - height : point.y);
        int flags = 3;
        HintManagerImpl.getInstanceImpl().showEditorHint(hint2, editor, resultPoint, flags |= this.timeout > 0 ? 32 : 128, this.timeout, false, hintHint);
        return hint2;
    }

    public boolean equals(@Nullable Object other) {
        RemoteCaretTooltipRenderer remoteCaretTooltipRenderer = other instanceof RemoteCaretTooltipRenderer ? (RemoteCaretTooltipRenderer)other : null;
        return Intrinsics.areEqual((Object)this.caret, (Object)(remoteCaretTooltipRenderer != null ? remoteCaretTooltipRenderer.caret : null));
    }

    public int hashCode() {
        return this.caret.hashCode();
    }

    private static final void show$lambda$1$lambda$0(Editor $editor, show.hint.1 $hint) {
        if (!$editor.isDisposed()) {
            $hint.hide();
        }
    }

    private static final Unit show$lambda$1(Editor $editor, show.hint.1 $hint) {
        EdtInvocationManager.invokeLaterIfNeeded(() -> RemoteCaretTooltipRenderer.show$lambda$1$lambda$0($editor, $hint));
        return Unit.INSTANCE;
    }
}

