%ifdef CONFIG
{
  "HostFeatures": ["AVX"],
  "RegData": {
    "XMM0":  ["0x8000000000000000", "0xC000000040000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM1":  ["0xBF80000000000000", "0xC00000003F800000", "0x0000000000000000", "0x0000000000000000"],
    "XMM2":  ["0x800000003F800000", "0xBF80000040000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM3":  ["0x8000000000000000", "0xBF8000003F800000", "0x0000000000000000", "0x0000000000000000"],
    "XMM4":  ["0x8000000000000000", "0xC000000040000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM5":  ["0xBF80000000000000", "0xC00000003F800000", "0x0000000000000000", "0x0000000000000000"],
    "XMM6":  ["0x800000003F800000", "0xBF80000040000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM7":  ["0x8000000000000000", "0xBF8000003F800000", "0x0000000000000000", "0x0000000000000000"],
    "XMM8":  ["0x8000000000000000", "0xC000000040000000", "0x8000000000000000", "0xC000000040000000"],
    "XMM9":  ["0xBF80000000000000", "0xC00000003F800000", "0xBF80000000000000", "0xC00000003F800000"],
    "XMM10": ["0x800000003F800000", "0xBF80000040000000", "0x800000003F800000", "0xBF80000040000000"],
    "XMM11": ["0x8000000000000000", "0xBF8000003F800000", "0x8000000000000000", "0xBF8000003F800000"],
    "XMM12": ["0x8000000000000000", "0xC000000040000000", "0x8000000000000000", "0xC000000040000000"],
    "XMM13": ["0xBF80000000000000", "0xC00000003F800000", "0xBF80000000000000", "0xC00000003F800000"],
    "XMM14": ["0x800000003F800000", "0xBF80000040000000", "0x800000003F800000", "0xBF80000040000000"],
    "XMM15": ["0x8000000000000000", "0xBF8000003F800000", "0x8000000000000000", "0xBF8000003F800000"]
  }
}
%endif

lea rdx, [rel .data]

vroundps xmm0, [rdx], 00000000b ; Nearest
vroundps xmm1, [rdx], 00000001b ; -inf
vroundps xmm2, [rdx], 00000010b ; +inf
vroundps xmm3, [rdx], 00000011b ; truncate

vroundps ymm8,  [rdx], 00000000b ; Nearest
vroundps ymm9,  [rdx], 00000001b ; -inf
vroundps ymm10, [rdx], 00000010b ; +inf
vroundps ymm11, [rdx], 00000011b ; truncate

; MXCSR
; Set to nearest
mov eax, 0x1F80
mov [rel .mxcsr], eax
ldmxcsr [rel .mxcsr]

vroundps xmm4,  [rdx], 00000100b
vroundps ymm12, [rdx], 00000100b

; Set to -inf
mov eax, 0x3F80
mov [rel .mxcsr], eax
ldmxcsr [rel .mxcsr]

vroundps xmm5,  [rdx], 00000100b
vroundps ymm13, [rdx], 00000100b

; Set to +inf
mov eax, 0x5F80
mov [rel .mxcsr], eax
ldmxcsr [rel .mxcsr]

vroundps xmm6,  [rdx], 00000100b
vroundps ymm14, [rdx], 00000100b

; Set to truncate
mov eax, 0x7F80
mov [rel .mxcsr], eax
ldmxcsr [rel .mxcsr]

vroundps xmm7,  [rdx], 00000100b
vroundps ymm15, [rdx], 00000100b

hlt

align 4096
.data:
dd 0.5, -0.5, 1.5, -1.5
dd 0.5, -0.5, 1.5, -1.5

.mxcsr:
dq 0, 0
