/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.build.event.types;

import com.google.common.collect.ImmutableList;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.gradle.api.problems.internal.Problem;
import org.gradle.api.problems.internal.ProblemLookup;
import org.gradle.internal.exceptions.MultiCauseException;
import org.gradle.tooling.internal.protocol.InternalBasicProblemDetailsVersion3;
import org.gradle.tooling.internal.protocol.InternalFailure;

public class DefaultFailure
implements Serializable,
InternalFailure {
    private final String message;
    private final String description;
    private final List<? extends InternalFailure> causes;
    private final List<InternalBasicProblemDetailsVersion3> problems;

    DefaultFailure(String message, String description, List<? extends InternalFailure> causes) {
        this(message, description, causes, Collections.emptyList());
    }

    DefaultFailure(String message, String description, List<? extends InternalFailure> causes, List<InternalBasicProblemDetailsVersion3> problems) {
        this.message = message;
        this.description = description;
        this.causes = causes;
        this.problems = problems;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDescription() {
        return this.description;
    }

    public List<? extends InternalFailure> getCauses() {
        return this.causes;
    }

    public List<InternalBasicProblemDetailsVersion3> getProblems() {
        return this.problems;
    }

    public static InternalFailure fromThrowable(Throwable throwable) {
        return DefaultFailure.fromThrowable(throwable, t -> ImmutableList.of(), p -> null);
    }

    public static InternalFailure fromThrowable(Throwable t, ProblemLookup problemLookup, Function<Problem, InternalBasicProblemDetailsVersion3> mapper) {
        List<Object> causeFailures;
        StringWriter out = new StringWriter();
        PrintWriter wrt = new PrintWriter(out);
        t.printStackTrace(wrt);
        Throwable cause = t.getCause();
        if (cause == null) {
            causeFailures = Collections.emptyList();
        } else if (cause instanceof MultiCauseException) {
            MultiCauseException multiCause = (MultiCauseException)cause;
            causeFailures = multiCause.getCauses().stream().map(f -> DefaultFailure.fromThrowable(f, problemLookup, mapper)).collect(Collectors.toList());
        } else {
            causeFailures = Collections.singletonList(DefaultFailure.fromThrowable(cause, problemLookup, mapper));
        }
        Collection problemMapping = problemLookup.findAll(t);
        ArrayList problems = new ArrayList();
        if (problemMapping != null) {
            problems.addAll(problemMapping);
        }
        if (problems.isEmpty()) {
            return new DefaultFailure(t.getMessage(), out.toString(), causeFailures);
        }
        return new DefaultFailure(t.getMessage(), out.toString(), causeFailures, problems.stream().map(mapper).collect(Collectors.toList()));
    }
}

