/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.navigator;

import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.AbstractDataSourceHandler;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceMenuContributor;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardConfiguration;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardConfigurationList;
import org.jkiss.dbeaver.ui.dashboard.view.DataSourceDashboardView;

public class DashboardDynamicMenuContributor
extends DataSourceMenuContributor {
    protected void fillContributionItems(List<IContributionItem> menuItems) {
        IWorkbenchPart activePart;
        IWorkbenchWindow window = UIUtils.getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        ISelection selection = (activePart = window.getActivePage().getActivePart()).getSite().getSelectionProvider() != null ? activePart.getSite().getSelectionProvider().getSelection() : null;
        DBPDataSourceContainer ds = AbstractDataSourceHandler.getActiveDataSourceContainer(null, (IWorkbenchPart)activePart, (ISelection)selection);
        if (ds == null) {
            ds = AbstractDataSourceHandler.getActiveDataSourceContainer((IEditorPart)window.getActivePage().getActiveEditor(), (IWorkbenchPart)activePart, (ISelection)selection);
        }
        if (ds != null) {
            DashboardConfigurationList configurationList = new DashboardConfigurationList(ds);
            configurationList.checkDefaultDashboardExistence();
            if (configurationList.getDashboards().isEmpty()) {
                configurationList.createDashboard("default", "Default");
            }
            for (DashboardConfiguration dashboard : configurationList.getDashboards()) {
                menuItems.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new ShowDashBoardAction(dashboard), (boolean)true));
            }
        }
        menuItems.add((IContributionItem)new Separator());
        menuItems.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)window, (String)"org.jkiss.dbeaver.ui.dashboard.create", Map.of("datasource", String.valueOf(true))));
    }

    private static class ShowDashBoardAction
    extends Action {
        private final DashboardConfiguration dashboard;

        public ShowDashBoardAction(DashboardConfiguration dashboard) {
            super(dashboard.getTitle());
            this.dashboard = dashboard;
        }

        public void run() {
            DataSourceDashboardView.openView(UIUtils.getActiveWorkbenchWindow(), this.dashboard.getProject(), this.dashboard.getDataSourceContainer(), this.dashboard.getDashboardId());
        }
    }
}

