/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import org.intellij.lang.xpath.XPath2ElementTypes;
import org.intellij.lang.xpath.XPath2TokenTypes;
import org.intellij.lang.xpath.XPathElementType;
import org.intellij.lang.xpath.XPathTokenTypes;
import org.intellij.lang.xpath.psi.XPath2Type;
import org.intellij.lang.xpath.psi.XPathBinaryExpression;
import org.intellij.lang.xpath.psi.XPathElementVisitor;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathType;
import org.intellij.lang.xpath.psi.impl.XPathElementImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XPathBinaryExpressionImpl
extends XPathElementImpl
implements XPathBinaryExpression {
    private static final TokenSet BINARY_OPERATIONS = TokenSet.orSet((TokenSet[])new TokenSet[]{XPathTokenTypes.BINARY_OPERATIONS, XPath2TokenTypes.COMP_OPS, XPath2TokenTypes.MULT_OPS, TokenSet.create((IElementType[])new IElementType[]{XPath2TokenTypes.TO, XPath2TokenTypes.INSTANCE, XPath2TokenTypes.EXCEPT, XPath2TokenTypes.INTERSECT, XPath2TokenTypes.UNION})});

    public XPathBinaryExpressionImpl(ASTNode node) {
        super(node);
    }

    @Override
    @Nullable
    public XPathExpression getLOperand() {
        ASTNode[] nodes = this.getNode().getChildren(XPath2ElementTypes.EXPRESSIONS);
        return (XPathExpression)(nodes.length > 0 ? nodes[0].getPsi() : null);
    }

    @Override
    @Nullable
    public XPathExpression getROperand() {
        ASTNode[] nodes = this.getNode().getChildren(XPath2ElementTypes.EXPRESSIONS);
        return (XPathExpression)(nodes.length > 1 ? nodes[1].getPsi() : null);
    }

    @Override
    @NotNull
    public XPathElementType getOperator() {
        ASTNode[] nodes = this.getNode().getChildren(BINARY_OPERATIONS);
        XPathElementType elementType = (XPathElementType)(nodes.length > 0 ? nodes[0].getElementType() : null);
        assert (elementType != null) : this.unexpectedPsiAssertion();
        XPathElementType xPathElementType = elementType;
        if (xPathElementType == null) {
            XPathBinaryExpressionImpl.$$$reportNull$$$0(0);
        }
        return xPathElementType;
    }

    @Override
    @NotNull
    public String getOperationSign() {
        ASTNode[] nodes = this.getNode().getChildren(BINARY_OPERATIONS);
        String string = nodes[0].getText();
        if (string == null) {
            XPathBinaryExpressionImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public XPathType getType() {
        XPathType xPathType = (XPathType)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)this.calcType(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (xPathType == null) {
            XPathBinaryExpressionImpl.$$$reportNull$$$0(2);
        }
        return xPathType;
    }

    @NotNull
    private XPathType calcType() {
        XPathElementType operator = this.getOperator();
        if (operator == XPathTokenTypes.UNION || XPath2TokenTypes.INTERSECT_EXCEPT.contains((IElementType)operator)) {
            XPathType xPathType = XPathType.NODESET;
            if (xPathType == null) {
                XPathBinaryExpressionImpl.$$$reportNull$$$0(3);
            }
            return xPathType;
        }
        if (XPath2TokenTypes.BOOLEAN_OPERATIONS.contains((IElementType)operator)) {
            XPathType xPathType = XPathType.BOOLEAN;
            if (xPathType == null) {
                XPathBinaryExpressionImpl.$$$reportNull$$$0(4);
            }
            return xPathType;
        }
        if (operator == XPath2TokenTypes.IDIV) {
            XPath2Type xPath2Type = XPath2Type.INTEGER;
            if (xPath2Type == null) {
                XPathBinaryExpressionImpl.$$$reportNull$$$0(5);
            }
            return xPath2Type;
        }
        if (XPath2TokenTypes.NUMBER_OPERATIONS.contains((IElementType)operator)) {
            XPathExpression lop = this.getLOperand();
            XPathExpression rop = this.getROperand();
            if (XPathBinaryExpressionImpl.is(lop, XPathType.UNKNOWN) || XPathBinaryExpressionImpl.is(rop, XPathType.UNKNOWN)) {
                XPathType xPathType = XPathType.UNKNOWN;
                if (xPathType == null) {
                    XPathBinaryExpressionImpl.$$$reportNull$$$0(6);
                }
                return xPathType;
            }
            if (XPathTokenTypes.MUL_OPS.contains((IElementType)operator)) {
                if (operator == XPathTokenTypes.DIV) {
                    if (XPathBinaryExpressionImpl.is(lop, XPath2Type.INTEGER) && XPathBinaryExpressionImpl.is(rop, XPath2Type.INTEGER)) {
                        XPath2Type xPath2Type = XPath2Type.DECIMAL;
                        if (xPath2Type == null) {
                            XPathBinaryExpressionImpl.$$$reportNull$$$0(7);
                        }
                        return xPath2Type;
                    }
                    XPathType xPathType = XPathBinaryExpressionImpl.mostSpecificType(lop, rop, XPath2Type.NUMERIC);
                    if (xPathType == null) {
                        XPathBinaryExpressionImpl.$$$reportNull$$$0(8);
                    }
                    return xPathType;
                }
                if (XPathBinaryExpressionImpl.is(lop, XPath2Type.DURATION)) {
                    XPathType xPathType = lop.getType();
                    if (xPathType == null) {
                        XPathBinaryExpressionImpl.$$$reportNull$$$0(9);
                    }
                    return xPathType;
                }
                if (XPathBinaryExpressionImpl.is(rop, XPath2Type.DURATION)) {
                    XPathType xPathType = lop != null ? rop.getType() : XPath2Type.DURATION;
                    if (xPathType == null) {
                        XPathBinaryExpressionImpl.$$$reportNull$$$0(10);
                    }
                    return xPathType;
                }
                XPathType xPathType = XPathBinaryExpressionImpl.mostSpecificType(lop, rop, XPathType.NUMBER);
                if (xPathType == null) {
                    XPathBinaryExpressionImpl.$$$reportNull$$$0(11);
                }
                return xPathType;
            }
            if (operator == XPathTokenTypes.PLUS) {
                if (XPathBinaryExpressionImpl.is(lop, XPath2Type.DATE) || XPathBinaryExpressionImpl.is(lop, XPath2Type.DATETIME) || XPathBinaryExpressionImpl.is(lop, XPath2Type.TIME)) {
                    if (XPathBinaryExpressionImpl.is(rop, XPath2Type.DURATION)) {
                        XPathType xPathType = lop.getType();
                        if (xPathType == null) {
                            XPathBinaryExpressionImpl.$$$reportNull$$$0(12);
                        }
                        return xPathType;
                    }
                } else if ((XPathBinaryExpressionImpl.is(rop, XPath2Type.DATE) || XPathBinaryExpressionImpl.is(rop, XPath2Type.DATETIME) || XPathBinaryExpressionImpl.is(rop, XPath2Type.TIME)) && XPathBinaryExpressionImpl.is(lop, XPath2Type.DURATION)) {
                    XPathType xPathType = rop.getType();
                    if (xPathType == null) {
                        XPathBinaryExpressionImpl.$$$reportNull$$$0(13);
                    }
                    return xPathType;
                }
            } else if (operator == XPathTokenTypes.MINUS && (XPathBinaryExpressionImpl.is(lop, XPath2Type.DATE) || XPathBinaryExpressionImpl.is(lop, XPath2Type.DATETIME) || XPathBinaryExpressionImpl.is(lop, XPath2Type.TIME))) {
                if (XPathBinaryExpressionImpl.is(rop, lop.getType())) {
                    XPath2Type xPath2Type = XPath2Type.DAYTIMEDURATION;
                    if (xPath2Type == null) {
                        XPathBinaryExpressionImpl.$$$reportNull$$$0(14);
                    }
                    return xPath2Type;
                }
                if (XPathBinaryExpressionImpl.is(rop, XPath2Type.DURATION)) {
                    XPathType xPathType = lop.getType();
                    if (xPathType == null) {
                        XPathBinaryExpressionImpl.$$$reportNull$$$0(15);
                    }
                    return xPathType;
                }
            }
            if (XPathBinaryExpressionImpl.is(lop, XPath2Type.DURATION)) {
                XPathType xPathType = rop != null ? rop.getType() : XPathType.UNKNOWN;
                if (xPathType == null) {
                    XPathBinaryExpressionImpl.$$$reportNull$$$0(16);
                }
                return xPathType;
            }
            XPathType xPathType = XPathBinaryExpressionImpl.mostSpecificType(lop, rop, XPathType.NUMBER);
            if (xPathType == null) {
                XPathBinaryExpressionImpl.$$$reportNull$$$0(17);
            }
            return xPathType;
        }
        XPathType xPathType = XPathType.UNKNOWN;
        if (xPathType == null) {
            XPathBinaryExpressionImpl.$$$reportNull$$$0(18);
        }
        return xPathType;
    }

    private static XPathType mostSpecificType(XPathExpression lop, XPathExpression rop, XPathType type) {
        XPathType rType;
        XPathType lType = lop != null ? lop.getType() : XPathType.UNKNOWN;
        XPathType xPathType = rType = rop != null ? rop.getType() : XPathType.UNKNOWN;
        if (lType.isAbstract()) {
            if (rType.isAbstract()) {
                return type;
            }
            return rType;
        }
        if (!rType.isAbstract()) {
            if (lType.canBePromotedTo(rType)) {
                return rType;
            }
            if (rType.canBePromotedTo(lType)) {
                return lType;
            }
            if (XPathType.isAssignable(lType, rType)) {
                return rType;
            }
        }
        return lType;
    }

    private static boolean is(XPathExpression op, XPathType type) {
        return op != null && (type instanceof XPath2Type ? type.isAssignableFrom(op.getType()) : type == op.getType());
    }

    @Override
    public void accept(XPathElementVisitor visitor) {
        visitor.visitXPathBinaryExpression(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/intellij/lang/xpath/psi/impl/XPathBinaryExpressionImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationSign";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "calcType";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

