/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView.search;

import com.intellij.find.FindBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.util.Processor;
import java.util.List;
import org.intellij.plugins.xpathView.HistoryElement;
import org.intellij.plugins.xpathView.XPathBundle;
import org.intellij.plugins.xpathView.search.BaseProcessor;
import org.intellij.plugins.xpathView.search.SearchScope;
import org.intellij.plugins.xpathView.support.XPathSupport;
import org.intellij.plugins.xpathView.util.CachedVariableContext;
import org.jaxen.Context;
import org.jaxen.ContextSupport;
import org.jaxen.JaxenException;
import org.jaxen.VariableContext;
import org.jaxen.XPath;
import org.jaxen.pattern.Pattern;
import org.jaxen.pattern.PatternParser;
import org.jaxen.saxpath.SAXPathException;
import org.jetbrains.annotations.NotNull;

class XPathUsageSearcher
implements UsageSearcher {
    private final ProgressIndicator myIndicator;
    private final PsiManager myManager;
    private final HistoryElement myExpression;
    private final Project myProject;
    private final SearchScope myScope;
    private final boolean myMatchRecursively;
    private final XPathSupport mySupport;

    XPathUsageSearcher(Project project, HistoryElement expression, SearchScope scope, boolean matchRecursively) {
        this.myExpression = expression;
        this.myProject = project;
        this.myScope = scope;
        this.myMatchRecursively = matchRecursively && !expression.expression.trim().startsWith("//");
        this.mySupport = XPathSupport.getInstance();
        this.myIndicator = ProgressManager.getInstance().getProgressIndicator();
        this.myManager = PsiManager.getInstance((Project)this.myProject);
    }

    public void generate(@NotNull Processor<? super Usage> processor) {
        if (processor == null) {
            XPathUsageSearcher.$$$reportNull$$$0(0);
        }
        Runnable runnable = () -> {
            this.myIndicator.setIndeterminate(true);
            this.myIndicator.setText2(FindBundle.message((String)"find.searching.for.string.in.file.occurrences.progress", (Object[])new Object[]{0}));
            CountProcessor counter = new CountProcessor();
            this.myScope.iterateContent(this.myProject, counter);
            this.myIndicator.setIndeterminate(false);
            this.myIndicator.setFraction(0.0);
            this.myScope.iterateContent(this.myProject, new MyProcessor(processor, counter.getFileCount()));
        };
        ApplicationManager.getApplication().runReadAction(runnable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/intellij/plugins/xpathView/search/XPathUsageSearcher", "generate"));
    }

    static class CountProcessor
    extends BaseProcessor {
        private int myFileCount;

        CountProcessor() {
        }

        @Override
        protected void processXmlFile(VirtualFile t) {
            ++this.myFileCount;
        }

        public int getFileCount() {
            return this.myFileCount;
        }
    }

    private class MyProcessor
    extends BaseProcessor {
        private final Processor<? super Usage> myProcessor;
        private final int myTotalFileCount;
        private int myFileCount;
        private int myMatchCount;

        MyProcessor(Processor<? super Usage> processor, int fileCount) {
            this.myProcessor = processor;
            this.myTotalFileCount = fileCount;
        }

        @Override
        protected void processXmlFile(VirtualFile t) {
            XPathUsageSearcher.this.myIndicator.setText(FindBundle.message((String)"find.searching.for.string.in.file.progress", (Object[])new Object[]{XPathUsageSearcher.this.myExpression.expression, t.getPresentableUrl()}));
            PsiFile psiFile = XPathUsageSearcher.this.myManager.findFile(t);
            if (psiFile instanceof XmlFile) {
                PsiFile root;
                XmlFile t1 = (XmlFile)psiFile;
                FileViewProvider fileViewProvider = t1.getViewProvider();
                Object document = fileViewProvider instanceof TemplateLanguageFileViewProvider ? ((root = fileViewProvider.getPsi(((TemplateLanguageFileViewProvider)fileViewProvider).getTemplateDataLanguage())) instanceof XmlFile ? ((XmlFile)root).getDocument() : null) : t1.getDocument();
                if (document != null) {
                    this.process((XmlDocument)document);
                }
            }
            XPathUsageSearcher.this.myIndicator.setFraction((double)(++this.myFileCount) / (double)this.myTotalFileCount);
        }

        private void process(XmlDocument t) {
            try {
                Context context;
                Pattern pattern;
                XPath searchPath;
                XmlFile psiFile = (XmlFile)t.getContainingFile();
                if (XPathUsageSearcher.this.myMatchRecursively) {
                    searchPath = XPathUsageSearcher.this.mySupport.createXPath(psiFile, "//*");
                    searchPath.setVariableContext((VariableContext)new CachedVariableContext(XPathUsageSearcher.this.myExpression.variables, searchPath, (XmlElement)t));
                    pattern = PatternParser.parse((String)XPathUsageSearcher.this.myExpression.expression);
                    ContextSupport support = new ContextSupport(searchPath.getNamespaceContext(), searchPath.getFunctionContext(), searchPath.getVariableContext(), searchPath.getNavigator());
                    context = new Context(support);
                } else {
                    searchPath = XPathUsageSearcher.this.mySupport.createXPath(psiFile, XPathUsageSearcher.this.myExpression.expression, XPathUsageSearcher.this.myExpression.namespaces);
                    searchPath.setVariableContext((VariableContext)new CachedVariableContext(XPathUsageSearcher.this.myExpression.variables, searchPath, (XmlElement)t));
                    pattern = null;
                    context = null;
                }
                Object o = searchPath.evaluate((Object)t);
                if (o instanceof List) {
                    List list = (List)o;
                    for (PsiElement psiElement : list) {
                        XPathUsageSearcher.this.myIndicator.checkCanceled();
                        if (XPathUsageSearcher.this.myMatchRecursively) {
                            if (!pattern.matches((Object)psiElement, context)) continue;
                            this.matchFound();
                            this.myProcessor.process((Object)new UsageInfo2UsageAdapter(new UsageInfo(psiElement)));
                            continue;
                        }
                        this.matchFound();
                        this.myProcessor.process((Object)new UsageInfo2UsageAdapter(new UsageInfo(psiElement)));
                    }
                } else if (Boolean.TRUE.equals(o)) {
                    this.matchFound();
                    this.myProcessor.process((Object)new UsageInfo2UsageAdapter(new UsageInfo((PsiFile)psiFile)));
                } else if (o instanceof Number) {
                    if (((Number)o).intValue() != 0) {
                        this.matchFound();
                        this.myProcessor.process((Object)new UsageInfo2UsageAdapter(new UsageInfo((PsiFile)psiFile)));
                    }
                } else if (o instanceof String && !((String)o).isEmpty()) {
                    this.matchFound();
                    this.myProcessor.process((Object)new UsageInfo2UsageAdapter(new UsageInfo((PsiFile)psiFile)));
                }
            }
            catch (JaxenException e) {
                Messages.showErrorDialog((Project)XPathUsageSearcher.this.myProject, (String)XPathBundle.message("dialog.message.error.while.evaluating.xpath", e.getMessage()), (String)XPathBundle.message("dialog.title.xpath.error", new Object[0]));
            }
            catch (SAXPathException e) {
                Logger.getInstance((String)this.getClass().getName()).error((Throwable)e);
            }
        }

        private void matchFound() {
            Object[] args = new Object[]{++this.myMatchCount};
            XPathUsageSearcher.this.myIndicator.setText2(FindBundle.message((String)"find.searching.for.string.in.file.occurrences.progress", (Object[])args));
        }
    }
}

