/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.appServers.utils;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModelImpl;
import com.intellij.ide.util.projectWizard.ProjectTemplateParameterFactory;
import com.intellij.ide.util.projectWizard.WizardInputField;
import com.intellij.javaee.appServers.AppServersIntegrationBundle;
import com.intellij.javaee.appServers.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.appServers.deployment.DeploymentSettings;
import com.intellij.javaee.appServers.facet.JavaeeFrameworkSupportInfoCollector;
import com.intellij.javaee.appServers.integration.JavaeeFrameworkSupportCommunicator;
import com.intellij.javaee.appServers.run.configuration.CommonModel;
import com.intellij.javaee.appServers.serverInstances.ApplicationServersManager;
import com.intellij.javaee.appServers.supportProvider.AppServerSupportConfigurable;
import com.intellij.javaee.appServers.utils.ApplicationServerPanel;
import com.intellij.javaee.ui.packaging.JavaeeArtifactTypeBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.util.containers.ContainerUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public final class ApplicationServerParameterFactory
extends ProjectTemplateParameterFactory {
    private static final Logger LOG = Logger.getInstance(ApplicationServerParameterFactory.class);

    public String getParameterId() {
        return "IJ_APPLICATION_SERVER";
    }

    @Nullable
    public WizardInputField createField(String defaultValue) {
        return new WizardInputField(this, "IJ_APPLICATION_SERVER", defaultValue){
            private final ApplicationServerPanel myPanel = new ApplicationServerPanel().initialize();
            {
                this.myPanel.getLabel().setVisible(false);
            }

            public String getLabel() {
                return AppServersIntegrationBundle.message((String)"ApplicationServerParameterFactory.label.application.server", (Object[])new Object[0]);
            }

            public JComponent getComponent() {
                return this.myPanel.getPanel();
            }

            public String getValue() {
                ApplicationServer item = this.myPanel.getSelectedServer();
                return item != null ? item.getName() : "";
            }
        };
    }

    @Nullable
    public String detectParameterValue(Project project) {
        for (RunConfiguration configuration : RunManager.getInstance((Project)project).getAllConfigurationsList()) {
            ApplicationServer server;
            if (!(configuration instanceof CommonModel) || (server = ((CommonModel)configuration).getApplicationServer()) == null) continue;
            return server.getName();
        }
        return null;
    }

    public void applyResult(String value, ModifiableRootModel model) {
        ApplicationServer server = ApplicationServersManager.getInstance().findByName(value);
        if (server == null) {
            return;
        }
        Project project = model.getProject();
        RunnerAndConfigurationSettings settings = AppServerSupportConfigurable.addSupport(project, model, server);
        Object[] artifacts = ArtifactManager.getInstance((Project)project).getArtifacts();
        Artifact artifact = (Artifact)ContainerUtil.find((Object[])artifacts, artifact1 -> {
            ArtifactType type = artifact1.getArtifactType();
            return type instanceof JavaeeArtifactTypeBase && !((JavaeeArtifactTypeBase)type).isArchive();
        });
        if (artifact != null) {
            CommonModel configuration = (CommonModel)settings.getConfiguration();
            DeploymentSettings deploymentSettings = configuration.getDeploymentSettings();
            LOG.assertTrue(deploymentSettings != null, (Object)(String.valueOf(configuration) + " returned null deployment settings"));
            deploymentSettings.getOrCreateModel(artifact);
            FrameworkSupportModelImpl supportModel = new FrameworkSupportModelImpl(project, project.getBasePath(), LibrariesContainerFactory.createContainer((ModifiableRootModel)model));
            JavaeeFrameworkSupportInfoCollector collector = JavaeeFrameworkSupportInfoCollector.getOrCreateCollector((FrameworkSupportModel)supportModel);
            collector.setRunConfiguration(configuration);
            collector.setArtifact(artifact.getArtifactType(), artifact);
            JavaeeFrameworkSupportCommunicator.setupSupport(model.getModule(), model, (FrameworkSupportModel)supportModel);
        }
    }
}

