/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.server;

import com.intellij.javaee.oss.server.JavaeeDeploymentModelContext;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.Factory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JavaeeDeploymentContextEditor<T>
extends SettingsEditor<T> {
    private JTextField myContextRootTextField;
    private JCheckBox myCustomContextRootCheckBox;
    private JPanel myMainPanel;

    public JavaeeDeploymentContextEditor(@NotNull Factory<? extends T> deploymentModelFactory, @NotNull @Nls String labelCaption) {
        if (deploymentModelFactory == null) {
            JavaeeDeploymentContextEditor.$$$reportNull$$$0(0);
        }
        if (labelCaption == null) {
            JavaeeDeploymentContextEditor.$$$reportNull$$$0(1);
        }
        super(deploymentModelFactory);
        this.$$$setupUI$$$();
        this.myCustomContextRootCheckBox.setText(labelCaption);
        this.myCustomContextRootCheckBox.addActionListener(e -> this.updateContextEnabled());
        this.myCustomContextRootCheckBox.setSelected(false);
        this.updateContextEnabled();
    }

    private void updateContextEnabled() {
        this.myContextRootTextField.setEnabled(this.myCustomContextRootCheckBox.isSelected());
    }

    public void resetEditorFrom(@NotNull T settings) {
        if (settings == null) {
            JavaeeDeploymentContextEditor.$$$reportNull$$$0(2);
        }
        boolean editable = this.isEditable(settings);
        this.myMainPanel.setEnabled(editable);
        this.myMainPanel.setVisible(editable);
        if (!editable) {
            return;
        }
        JavaeeDeploymentModelContext deploymentModel = (JavaeeDeploymentModelContext)settings;
        this.myCustomContextRootCheckBox.setSelected(!deploymentModel.isDefaultContextRoot());
        this.myContextRootTextField.setText(deploymentModel.getContextRoot());
        this.updateContextEnabled();
    }

    public void applyEditorTo(@NotNull T settings) throws ConfigurationException {
        if (settings == null) {
            JavaeeDeploymentContextEditor.$$$reportNull$$$0(3);
        }
        if (!this.isEditable(settings)) {
            return;
        }
        JavaeeDeploymentModelContext deploymentModel = (JavaeeDeploymentModelContext)settings;
        deploymentModel.setDefaultContextRoot(!this.myCustomContextRootCheckBox.isSelected());
        deploymentModel.setContextRoot(this.myContextRootTextField.getText());
    }

    protected boolean isEditable(@NotNull T settings) {
        if (settings == null) {
            JavaeeDeploymentContextEditor.$$$reportNull$$$0(4);
        }
        return settings instanceof JavaeeDeploymentModelContext;
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            JavaeeDeploymentContextEditor.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentModelFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelCaption";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/oss/server/JavaeeDeploymentContextEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/oss/server/JavaeeDeploymentContextEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isEditable";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myCustomContextRootCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("<use context>");
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myContextRootTextField = jTextField = new JTextField();
        jTextField.setEditable(true);
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

