/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.console;

import com.intellij.execution.CommandLineUtil;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteConnectionType;
import com.intellij.remote.RemoteConnector;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkException;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.ShellChannelBuilder;
import com.intellij.ssh.SshException;
import com.intellij.ssh.channels.ShellChannel;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.process.SshShellProcess;
import com.jediterm.terminal.TtyConnector;
import com.jetbrains.plugins.remotesdk.console.JschProcessTtyConnector;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerGroupingWrap;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.ShellStartupOptions;
import org.jetbrains.plugins.terminal.TerminalTabState;
import org.jetbrains.plugins.terminal.fus.TerminalUsageTriggerCollector;

public class SshTerminalDirectRunner
extends AbstractTerminalRunner<SshShellProcess> {
    private final RemoteCredentials myCredentials;
    private final Charset myDefaultCharset;
    @Nls
    @Nullable
    private String myPresentableName;

    public SshTerminalDirectRunner(Project project, RemoteCredentials credentials, Charset charset) {
        super(project);
        this.myCredentials = credentials;
        this.myDefaultCharset = charset;
    }

    void useConnectorPresentableName(@NotNull RemoteConnector connector) {
        if (connector == null) {
            SshTerminalDirectRunner.$$$reportNull$$$0(0);
        }
        if (connector.getType() != RemoteConnectionType.NONE) {
            this.myPresentableName = connector.getName();
        }
    }

    @NotNull
    public SshShellProcess createProcess(@NotNull ShellStartupOptions options) throws ExecutionException {
        if (options == null) {
            SshTerminalDirectRunner.$$$reportNull$$$0(1);
        }
        try {
            ShellChannel channel = this.getShellChannel();
            String directory = options.getWorkingDirectory();
            if (directory != null) {
                SshTerminalDirectRunner.issueCdCommand(channel, directory);
            }
            TerminalUsageTriggerCollector.triggerSshShellStarted((Project)this.myProject);
            return new SshShellProcess(channel);
        }
        catch (Exception e) {
            throw new ExecutionException(e.getMessage(), e);
        }
    }

    @NotNull
    protected ShellChannel getShellChannel() throws RemoteSdkException {
        return this.createShellChannel();
    }

    @NotNull
    protected final ShellChannel createShellChannel() throws RemoteSdkException {
        ShellChannel shellChannel;
        try {
            shellChannel = ((ShellChannelBuilder)RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)this.myCredentials, (Project)this.myProject).shellBuilder().withAllocatePty(true)).openChannel();
        }
        catch (SshException e) {
            throw new RemoteSdkException(e.getMessage(), (Throwable)e);
        }
        if (shellChannel == null) {
            SshTerminalDirectRunner.$$$reportNull$$$0(2);
        }
        return shellChannel;
    }

    protected static void issueCdCommand(@NotNull ShellChannel channel, @NotNull String directory) throws IOException {
        if (channel == null) {
            SshTerminalDirectRunner.$$$reportNull$$$0(3);
        }
        if (directory == null) {
            SshTerminalDirectRunner.$$$reportNull$$$0(4);
        }
        String cdCommand = "cd " + CommandLineUtil.posixQuote((String)directory) + "\n";
        channel.getOutputStream().write(cdCommand.getBytes(StandardCharsets.UTF_8));
        channel.getOutputStream().flush();
    }

    @Nullable
    public String getCurrentWorkingDir(@Nullable TerminalTabState state) {
        if (state != null) {
            return state.myWorkingDirectory;
        }
        if (!AdvancedSettings.getBoolean((String)"start.ssh.session.in.deployment.directory")) {
            return null;
        }
        PublishConfig publishConfig = PublishConfig.getInstance((Project)this.myProject);
        for (WebServerGroupingWrap group : GroupedServersConfigManager.getInstance((Project)this.myProject).getGroupedServers()) {
            for (WebServerConfig server : group.getServers()) {
                SshConfig config = server.findSshConfig(this.myProject);
                if (config == null || !Objects.equals(config.copyToCredentials(), this.myCredentials)) continue;
                return SshTerminalDirectRunner.getCurrentWorkingDir(publishConfig, server);
            }
        }
        return null;
    }

    @VisibleForTesting
    public static String getCurrentWorkingDir(@NotNull PublishConfig publishConfig, @NotNull WebServerConfig server) {
        if (publishConfig == null) {
            SshTerminalDirectRunner.$$$reportNull$$$0(5);
        }
        if (server == null) {
            SshTerminalDirectRunner.$$$reportNull$$$0(6);
        }
        String rootPath = StringUtil.trimEnd((String)server.getFileTransferConfig().getRootFolder(), (String)"/");
        List mappings = publishConfig.getPathMappings(server.getId());
        if (mappings.size() == 1) {
            return rootPath + ((DeploymentPathMapping)mappings.get(0)).getDeployPath();
        }
        if (rootPath.isEmpty()) {
            return "/";
        }
        return rootPath;
    }

    @NotNull
    public TtyConnector createTtyConnector(@NotNull SshShellProcess process) {
        if (process == null) {
            SshTerminalDirectRunner.$$$reportNull$$$0(7);
        }
        return new JschProcessTtyConnector(process, this.myDefaultCharset);
    }

    @NotNull
    public String getDefaultTabTitle() {
        if (this.myPresentableName != null) {
            String string = this.myPresentableName;
            if (string == null) {
                SshTerminalDirectRunner.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = this.myCredentials.getHost() + ":" + this.myCredentials.getLiteralPort();
        if (string == null) {
            SshTerminalDirectRunner.$$$reportNull$$$0(9);
        }
        return string;
    }

    public boolean isTerminalSessionPersistent() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connector";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/remotesdk/console/SshTerminalDirectRunner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publishConfig";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/console/SshTerminalDirectRunner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createShellChannel";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTabTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "useConnectorPresentableName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createProcess";
                break;
            }
            case 2: 
            case 8: 
            case 9: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "issueCdCommand";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentWorkingDir";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTtyConnector";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 8, 9 -> new IllegalStateException(string);
        };
    }
}

