/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.actions.test.route;

import com.intellij.ide.starters.shared.FormUiUtilKt;
import com.intellij.ide.starters.shared.TextValidationFunction;
import com.intellij.ide.starters.shared.ValidationFunctions;
import com.intellij.ktor.KtorStarterBundle;
import com.intellij.ktor.actions.test.TestActionsUtils;
import com.intellij.ktor.actions.test.route.KtorRouteTestDialog;
import com.intellij.ktor.initializr.settings.KtorProjectSettingsStepUtilsKt;
import com.intellij.ktor.utils.ComponentWithFieldValidation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.observable.properties.GraphProperty;
import com.intellij.openapi.observable.properties.PropertyGraph;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u001f\u001a\u00020\u0007H\u0014J\b\u0010 \u001a\u00020\u0007H\u0014J\b\u0010!\u001a\u00020\"H\u0014J\b\u0010#\u001a\u00020$H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u000e\u00a8\u0006%"}, d2={"Lcom/intellij/ktor/actions/test/route/KtorRouteTestDialogImpl;", "Lcom/intellij/openapi/ui/DialogWrapper;", "Lcom/intellij/ktor/utils/ComponentWithFieldValidation;", "Lcom/intellij/ktor/actions/test/route/KtorRouteTestDialog;", "project", "Lcom/intellij/openapi/project/Project;", "route", "", "methodName", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRoute", "()Ljava/lang/String;", "getMethodName", "validatedTextComponents", "", "Ljavax/swing/JTextField;", "getValidatedTextComponents", "()Ljava/util/List;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "getParentDisposable", "()Lcom/intellij/openapi/Disposable;", "propertyGraph", "Lcom/intellij/openapi/observable/properties/PropertyGraph;", "routeTestNameProperty", "Lcom/intellij/openapi/observable/properties/GraphProperty;", "testName", "getTestName", "getDimensionServiceKey", "getHelpId", "createCenterPanel", "Ljavax/swing/JComponent;", "validate", "", "intellij.ktor"})
public final class KtorRouteTestDialogImpl
extends DialogWrapper
implements ComponentWithFieldValidation,
KtorRouteTestDialog {
    @NotNull
    private final Project project;
    @NotNull
    private final String route;
    @NotNull
    private final String methodName;
    @NotNull
    private final List<JTextField> validatedTextComponents;
    @NotNull
    private final Disposable parentDisposable;
    @NotNull
    private final PropertyGraph propertyGraph;
    @NotNull
    private final GraphProperty<String> routeTestNameProperty;

    public KtorRouteTestDialogImpl(@NotNull Project project, @NotNull String route, @NotNull String methodName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        super(project);
        this.project = project;
        this.route = route;
        this.methodName = methodName;
        this.validatedTextComponents = new ArrayList();
        Disposable disposable = this.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        this.parentDisposable = disposable;
        this.propertyGraph = new PropertyGraph(null, false, 3, null);
        this.routeTestNameProperty = this.propertyGraph.lazyProperty(() -> KtorRouteTestDialogImpl.routeTestNameProperty$lambda$0(this));
        this.setTitle(KtorStarterBundle.INSTANCE.message("ktor.create.route.test.title", new Object[0]));
        this.setOKButtonText(KtorStarterBundle.INSTANCE.message("ktor.create.test.button.text", new Object[0]));
        this.init();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final String getRoute() {
        return this.route;
    }

    @NotNull
    public final String getMethodName() {
        return this.methodName;
    }

    @Override
    @NotNull
    public List<JTextField> getValidatedTextComponents() {
        return this.validatedTextComponents;
    }

    @Override
    @NotNull
    public Disposable getParentDisposable() {
        return this.parentDisposable;
    }

    @Override
    @NotNull
    public String getTestName() {
        return (String)this.routeTestNameProperty.get();
    }

    @NotNull
    protected String getDimensionServiceKey() {
        String string = this.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @NotNull
    protected String getHelpId() {
        return "reference.ktor.dialogs.routeTest";
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return (JComponent)BuilderKt.panel(arg_0 -> KtorRouteTestDialogImpl.createCenterPanel$lambda$0(this, arg_0));
    }

    public void validate() {
        this.validateFields();
    }

    private static final String routeTestNameProperty$lambda$0(KtorRouteTestDialogImpl this$0) {
        return TestActionsUtils.Companion.calculateTestName(this$0.route, this$0.methodName);
    }

    private static final Unit createCenterPanel$lambda$0(KtorRouteTestDialogImpl this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        KtorProjectSettingsStepUtilsKt.createTextField$default($this$panel, KtorStarterBundle.INSTANCE.message("ktor.route.test.name", new Object[0]), this$0.routeTestNameProperty, true, false, null, arg_0 -> KtorRouteTestDialogImpl.createCenterPanel$lambda$0$0(this$0, arg_0), 24, null);
        return Unit.INSTANCE;
    }

    private static final Cell createCenterPanel$lambda$0$0(KtorRouteTestDialogImpl this$0, Cell $this$createTextField) {
        Intrinsics.checkNotNullParameter((Object)$this$createTextField, (String)"$this$createTextField");
        Object[] objectArray = new TextValidationFunction[]{ValidationFunctions.CHECK_NOT_EMPTY, TestActionsUtils.Companion.getCHECK_NO_SLASHES()};
        List list = CollectionsKt.listOf((Object[])objectArray);
        List<JTextField> list2 = this$0.getValidatedTextComponents();
        Disposable disposable = this$0.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        return FormUiUtilKt.withValidation((Cell)$this$createTextField, (List)list, null, list2, (Disposable)disposable);
    }
}

