/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.sql.common.impl.formatter.settings;

import com.intellij.lang.Language;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.formatter.settings.SqlLanguageCodeStyleProvider;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider
implements SqlLanguageCodeStyleProvider {
    @NotNull
    protected final Language myDialect;
    @NotNull
    protected final Class<? extends SqlCodeStyleSettings> mySettingsClass;

    protected SqlLanguageCodeStyleSettingsProvider(@NotNull Language dialect, @NotNull Class<? extends SqlCodeStyleSettings> settingsClass) {
        if (dialect == null) {
            SqlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(0);
        }
        if (settingsClass == null) {
            SqlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(1);
        }
        this.myDialect = dialect;
        this.mySettingsClass = settingsClass;
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.myDialect;
        if (language == null) {
            SqlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(2);
        }
        return language;
    }

    @NlsSafe
    @Nullable
    public String getLanguageName() {
        return this.getLanguage().getDisplayName();
    }

    @Nullable
    public final String getConfigurableDisplayName() {
        return this.getLanguageName();
    }

    @NotNull
    public Class<? extends SqlCodeStyleSettings> getSettingsClass() {
        Class<? extends SqlCodeStyleSettings> clazz = this.mySettingsClass;
        if (clazz == null) {
            SqlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(3);
        }
        return clazz;
    }

    public List<Language> getApplicableLanguages() {
        return SqlCodeStyles.getSettingsDialects().filter(d -> d != this.myDialect).filter(Language.class).toList();
    }

    public boolean supportsExternalFormats() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/sql/common/impl/formatter/settings/SqlLanguageCodeStyleSettingsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/sql/common/impl/formatter/settings/SqlLanguageCodeStyleSettingsProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

