/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.jpa.orm;

import com.intellij.jpa.jpb.model.model.CachedEntityAttributeModel;
import com.intellij.jpa.jpb.model.model.Datatype;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.model.EntityAttributeModel;
import com.intellij.jpa.jpb.model.model.EntityAttributePsi;
import com.intellij.jpa.jpb.model.model.audit.AuditEntity;
import com.intellij.jpa.jpb.model.model.audit.AuditEntityAttribute;
import com.intellij.jpa.jpb.model.util.AttributeUtil;
import com.intellij.jpa.jpb.model.util.EntityUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JpaLiquibaseAttributesHelper {
    JpaLiquibaseAttributesHelper() {
    }

    @Nullable
    public static EntityAttribute tryToExtractGenericAttribute(Project project, @Nullable Entity entity, @NotNull EntityAttribute attribute) {
        if (attribute == null) {
            JpaLiquibaseAttributesHelper.$$$reportNull$$$0(0);
        }
        if (!attribute.isGenericType()) {
            return null;
        }
        if (entity instanceof AuditEntity) {
            AuditEntity auditEntity = (AuditEntity)entity;
            entity = auditEntity.getAuditedEntity();
        }
        if (entity == null && attribute instanceof EntityAttributeModel) {
            entity = ((EntityAttributeModel)attribute).getOwnerEntity();
        }
        if (entity == null) {
            return null;
        }
        PsiMember attrMember = null;
        if (attribute instanceof EntityAttributePsi && ((EntityAttributePsi)attribute).isValid()) {
            attrMember = ((EntityAttributePsi)attribute).getMember();
        } else if (attribute instanceof AuditEntityAttribute) {
            AuditEntityAttribute auditEntityAttribute = (AuditEntityAttribute)attribute;
            attrMember = auditEntityAttribute.getAuditedAttribute().getMember();
        } else if (attribute instanceof EntityAttributeModel) {
            attrMember = ((EntityAttributeModel)attribute).findMember(project);
        }
        if (attrMember == null) {
            return null;
        }
        PsiClass entityClass = EntityUtil.getPsiClass((Entity)entity, (Project)project);
        if (entityClass == null) {
            return null;
        }
        Datatype resolvedGenericAttrType = AttributeUtil.getResolvedGenericAttrType((PsiClass)entityClass, (PsiMember)attrMember);
        if (resolvedGenericAttrType == null) {
            return null;
        }
        CachedEntityAttributeModel newAttr = new CachedEntityAttributeModel();
        newAttr.copyFrom(attribute);
        newAttr.setColumnPhysical(attribute.getColumn());
        newAttr.setType(resolvedGenericAttrType);
        if (resolvedGenericAttrType instanceof Entity) {
            if (((Entity)resolvedGenericAttrType).isEmbeddable()) {
                newAttr.setMappingType(EntityAttribute.MappingType.EMBEDDED);
            } else {
                newAttr.setMappingType(EntityAttribute.MappingType.ASSOCIATION);
            }
        }
        return newAttr;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/liquibase/jpa/orm/JpaLiquibaseAttributesHelper", "tryToExtractGenericAttribute"));
    }
}

