/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.tomcat.server;

import com.intellij.javaee.appServers.appServerIntegrations.ApplicationServerInfo;
import com.intellij.javaee.appServers.appServerIntegrations.ApplicationServerPersistentData;
import com.intellij.javaee.appServers.appServerIntegrations.ApplicationServerPersistentDataEditor;
import com.intellij.javaee.appServers.appServerIntegrations.CantFindApplicationServerJarsException;
import com.intellij.javaee.oss.server.JavaeeIntegration;
import com.intellij.javaee.oss.server.JavaeePersistentData;
import com.intellij.javaee.oss.server.JavaeeServerHelper;
import com.intellij.javaee.oss.server.WslSupportUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Arrays;
import org.jetbrains.idea.tomcat.server.TomcatIntegration;
import org.jetbrains.idea.tomcat.server.TomcatPersistentData;
import org.jetbrains.idea.tomcat.server.TomcatPersistentDataEditor;
import org.jetbrains.idea.tomcat.server.TomcatWslInspector;

public class TomcatServerHelper
extends JavaeeServerHelper {
    private final TomcatIntegration myIntegration;
    private final boolean myTomEEOnly;

    public TomcatServerHelper(TomcatIntegration integration, boolean tomEEOnly) {
        super((JavaeeIntegration)integration);
        this.myIntegration = integration;
        this.myTomEEOnly = tomEEOnly;
    }

    public ApplicationServerPersistentData createPersistentDataEmptyInstance() {
        return new TomcatPersistentData();
    }

    public ApplicationServerPersistentDataEditor createConfigurable() {
        return new TomcatPersistentDataEditor(this.myIntegration, this.myTomEEOnly);
    }

    public ApplicationServerInfo getApplicationServerInfo(ApplicationServerPersistentData data) throws CantFindApplicationServerJarsException {
        if (data instanceof JavaeePersistentData) {
            JavaeePersistentData jeePersistentData = (JavaeePersistentData)data;
            if (WslSupportUtil.isWslPath((String)jeePersistentData.HOME)) {
                String tomcatHome = jeePersistentData.HOME;
                File[] libraries = TomcatWslInspector.searchForLibraries(tomcatHome);
                JavaeeIntegration integration = this.getIntegration();
                String serverVersion = integration.getServerVersionSilently(jeePersistentData);
                String name = StringUtil.join(Arrays.asList(integration.getName(), serverVersion), (String)" ");
                return new ApplicationServerInfo(libraries, name);
            }
        }
        return super.getApplicationServerInfo(data);
    }
}

