/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run;

import com.intellij.execution.CantRunException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.UndoRefactoringElementAdapter;
import com.jetbrains.nodejs.run.NodeJsRunConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NodeJsRunConfigurationRefactoringHandler {
    @Nullable
    public static RefactoringElementListener createRefactoringElementListener(@NotNull NodeJsRunConfiguration configuration, @Nullable PsiElement element) {
        VirtualFile elementVirtualFile;
        if (configuration == null) {
            NodeJsRunConfigurationRefactoringHandler.$$$reportNull$$$0(0);
        }
        if (element != null && (elementVirtualFile = PsiUtilBase.asVirtualFile((PsiElement)element)) != null) {
            String workingDirectoryRelativePath = NodeJsRunConfigurationRefactoringHandler.getWorkingDirectoryRelativePath(configuration, elementVirtualFile);
            String inputFileRelativePath = NodeJsRunConfigurationRefactoringHandler.getInputFileRelativePath(configuration, elementVirtualFile);
            if (workingDirectoryRelativePath != null || inputFileRelativePath != null) {
                return new NodeRcRefactoringElementListener(configuration, workingDirectoryRelativePath, inputFileRelativePath);
            }
        }
        return null;
    }

    @Nullable
    private static String getWorkingDirectoryRelativePath(@NotNull NodeJsRunConfiguration configuration, @NotNull VirtualFile refactoredDir) {
        VirtualFile workingDirectory;
        String workingDirectoryPath;
        if (configuration == null) {
            NodeJsRunConfigurationRefactoringHandler.$$$reportNull$$$0(1);
        }
        if (refactoredDir == null) {
            NodeJsRunConfigurationRefactoringHandler.$$$reportNull$$$0(2);
        }
        if (StringUtil.isNotEmpty((String)(workingDirectoryPath = configuration.getWorkingDirectory())) && (workingDirectory = LocalFileSystem.getInstance().findFileByPath(workingDirectoryPath)) != null) {
            return VfsUtilCore.getRelativePath((VirtualFile)workingDirectory, (VirtualFile)refactoredDir);
        }
        return null;
    }

    @Nullable
    private static String getInputFileRelativePath(@NotNull NodeJsRunConfiguration configuration, @NotNull VirtualFile refactoredFile) {
        if (configuration == null) {
            NodeJsRunConfigurationRefactoringHandler.$$$reportNull$$$0(3);
        }
        if (refactoredFile == null) {
            NodeJsRunConfigurationRefactoringHandler.$$$reportNull$$$0(4);
        }
        VirtualFile inputFile = null;
        try {
            inputFile = configuration.findMainScriptVirtualFile();
        }
        catch (CantRunException cantRunException) {
            // empty catch block
        }
        if (inputFile != null) {
            return VfsUtilCore.getRelativePath((VirtualFile)inputFile, (VirtualFile)refactoredFile);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refactoredDir";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refactoredFile";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/run/NodeJsRunConfigurationRefactoringHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createRefactoringElementListener";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getWorkingDirectoryRelativePath";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getInputFileRelativePath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class NodeRcRefactoringElementListener
    extends UndoRefactoringElementAdapter {
        private final NodeJsRunConfiguration myConfiguration;
        private final String myWorkingDirectoryRelativePath;
        private final String myInputFileRelativePath;

        NodeRcRefactoringElementListener(@NotNull NodeJsRunConfiguration configuration, @Nullable String workingDirectoryRelativePath, @Nullable String inputFileRelativePath) {
            if (configuration == null) {
                NodeRcRefactoringElementListener.$$$reportNull$$$0(0);
            }
            this.myConfiguration = configuration;
            this.myWorkingDirectoryRelativePath = workingDirectoryRelativePath;
            this.myInputFileRelativePath = inputFileRelativePath;
        }

        protected void refactored(@NotNull PsiElement element, @Nullable String oldQualifiedName) {
            VirtualFile newFile;
            if (element == null) {
                NodeRcRefactoringElementListener.$$$reportNull$$$0(1);
            }
            if ((newFile = PsiUtilBase.asVirtualFile((PsiElement)element)) != null) {
                VirtualFile inputFile;
                VirtualFile workingDirectory;
                if (this.myWorkingDirectoryRelativePath != null && (workingDirectory = newFile.findFileByRelativePath(this.myWorkingDirectoryRelativePath)) != null) {
                    this.myConfiguration.setWorkingDirectory(workingDirectory.getPath());
                }
                if (this.myInputFileRelativePath != null && (inputFile = newFile.findFileByRelativePath(this.myInputFileRelativePath)) != null) {
                    this.myConfiguration.setMainScriptFilePath(inputFile.getPath());
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/nodejs/run/NodeJsRunConfigurationRefactoringHandler$NodeRcRefactoringElementListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "refactored";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

