/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.contexts.model.ComponentScanPackagesModel;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScan;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class SpringComponentScanModel<T extends SpringBeansPackagesScan>
extends ComponentScanPackagesModel {
    private final Set<String> myActiveProfiles;
    private volatile CachedValue<Collection<SpringBeanPointer<?>>> myScannedBeans;
    private final T myComponentScan;

    public SpringComponentScanModel(@NotNull Module module, @NotNull T componentScan, Set<String> activeProfiles, boolean includeTests) {
        if (module == null) {
            SpringComponentScanModel.$$$reportNull$$$0(0);
        }
        if (componentScan == null) {
            SpringComponentScanModel.$$$reportNull$$$0(1);
        }
        super((NotNullLazyValue<? extends Set<PsiPackage>>)NotNullLazyValue.lazy(() -> componentScan.getPsiPackages()), module, includeTests);
        this.myComponentScan = componentScan;
        this.myActiveProfiles = activeProfiles;
    }

    @Override
    public Collection<SpringBeanPointer<?>> getLocalBeans() {
        PsiElement psiElement = this.myComponentScan.getIdentifyingPsiElement();
        if (psiElement == null) {
            return Collections.emptySet();
        }
        if (this.myScannedBeans == null) {
            this.myScannedBeans = CachedValuesManager.getManager((Project)this.getModule().getProject()).createCachedValue(() -> {
                Collection<SpringBeanPointer<?>> pointers = this.calculateLocalBeans(this.includeTests);
                return CachedValueProvider.Result.create(pointers, (Object[])this.getDependencies(pointers.stream().map(pointer -> pointer.getContainingFile()).collect(Collectors.toSet())));
            }, false);
        }
        return (Collection)this.myScannedBeans.getValue();
    }

    @Override
    protected Collection<SpringBeanPointer<?>> calculateScannedBeans(boolean includeTests) {
        Set<CommonSpringBean> elements = this.myComponentScan.getScannedElements(this.getModule(), includeTests);
        List<CommonSpringBean> inActiveProfiles = SpringProfileUtils.filterBeansInActiveProfiles(elements, this.myActiveProfiles);
        return BeanService.getInstance().mapSpringBeans(inActiveProfiles);
    }

    @Override
    @NotNull
    public Set<String> getActiveProfiles() {
        Set<String> set = this.myActiveProfiles;
        if (set == null) {
            SpringComponentScanModel.$$$reportNull$$$0(2);
        }
        return set;
    }

    public String toString() {
        return "SpringComponentScanModel{" + String.valueOf(this.myComponentScan) + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentScan";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/contexts/model/SpringComponentScanModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/contexts/model/SpringComponentScanModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveProfiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

