/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.cli;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.openapi.util.SystemInfo;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/docker/cli/DockerComposeCommandProcessHandler;", "Lcom/intellij/execution/process/KillableColoredProcessHandler;", "process", "Ljava/lang/Process;", "generalCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "<init>", "(Ljava/lang/Process;Lcom/intellij/execution/configurations/GeneralCommandLine;)V", "isFirstKillProcessInvocation", "Ljava/util/concurrent/atomic/AtomicBoolean;", "destroyProcessGracefully", "", "killProcess", "", "intellij.clouds.docker"})
public final class DockerComposeCommandProcessHandler
extends KillableColoredProcessHandler {
    @NotNull
    private final AtomicBoolean isFirstKillProcessInvocation;

    public DockerComposeCommandProcessHandler(@NotNull Process process, @NotNull GeneralCommandLine generalCommandLine) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Intrinsics.checkNotNullParameter((Object)generalCommandLine, (String)"generalCommandLine");
        super(process, generalCommandLine);
        this.isFirstKillProcessInvocation = new AtomicBoolean(true);
    }

    protected boolean destroyProcessGracefully() {
        if (SystemInfo.isWindows) {
            return super.destroyProcessGracefully();
        }
        if (SystemInfo.isUnix) {
            UnixProcessManager.sendSignal((int)UnixProcessManager.getProcessId((Process)this.getProcess()), (int)2);
            return true;
        }
        return false;
    }

    public void killProcess() {
        if (this.isFirstKillProcessInvocation.compareAndSet(true, false)) {
            this.destroyProcessGracefully();
        } else {
            super.killProcess();
        }
    }
}

