/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.model.constraint;

import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.HibernateConstraintAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.JpaConstraintAnnotation;
import com.intellij.jpa.jpb.model.model.constraint.DecimalMinMaxConstraint;
import com.intellij.jpa.jpb.model.model.constraint.DigitsConstraint;
import com.intellij.jpa.jpb.model.model.constraint.MinMaxConstraint;
import com.intellij.jpa.jpb.model.model.constraint.PatternConstraint;
import com.intellij.jpa.jpb.model.model.constraint.SizeConstraint;
import com.intellij.jpa.jpb.model.model.constraint.hibernate.CreditCardNumberConstraint;
import com.intellij.jpa.jpb.model.model.constraint.hibernate.CurrencyConstraint;
import com.intellij.jpa.jpb.model.model.constraint.hibernate.DurationMinMaxConstraint;
import com.intellij.jpa.jpb.model.model.constraint.hibernate.LuhnCheckConstraint;
import com.intellij.jpa.jpb.model.model.constraint.hibernate.RangeConstraint;
import com.intellij.jpa.jpb.model.model.constraint.hibernate.UrlConstraint;
import com.intellij.openapi.util.text.StringUtil;
import com.jgoodies.binding.beans.Model;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class Constraint
extends Model {
    protected static final String NOT_SET = "not set";
    public static final String NAME = "name";
    public static final String ENABLED = "enabled";
    protected String name;
    protected boolean enabled;
    protected String message;

    public Constraint(String name) {
        this.name = name;
    }

    public Constraint(String name, boolean enabled) {
        this.name = name;
        this.enabled = enabled;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void copyFrom(Constraint other) {
        this.enabled = other.enabled;
        this.message = other.message;
    }

    public static Constraint create(String name) {
        if (name.equals(JpaConstraintAnnotation.Min.name()) || name.equals(JpaConstraintAnnotation.Max.name())) {
            return new MinMaxConstraint(name);
        }
        if (name.equals(JpaConstraintAnnotation.Size.name()) || name.equals(HibernateConstraintAnnotation.Length.name()) || name.equals(HibernateConstraintAnnotation.CodePointLength.name())) {
            return new SizeConstraint(name);
        }
        if (name.equals(JpaConstraintAnnotation.DecimalMin.name()) || name.equals(JpaConstraintAnnotation.DecimalMax.name())) {
            return new DecimalMinMaxConstraint(name);
        }
        if (name.equals(JpaConstraintAnnotation.Pattern.name()) || name.equals(JpaConstraintAnnotation.Email.name())) {
            return new PatternConstraint(name);
        }
        if (name.equals(JpaConstraintAnnotation.Digits.name())) {
            return new DigitsConstraint(name);
        }
        if (name.equals(HibernateConstraintAnnotation.CreditCardNumber.name())) {
            return new CreditCardNumberConstraint(name, false);
        }
        if (name.equals(HibernateConstraintAnnotation.Currency.name())) {
            return new CurrencyConstraint(name, false);
        }
        if (name.equals(HibernateConstraintAnnotation.DurationMin.name()) || name.equals(HibernateConstraintAnnotation.DurationMax.name())) {
            return new DurationMinMaxConstraint(name, false);
        }
        if (name.equals(HibernateConstraintAnnotation.LuhnCheck.name())) {
            return new LuhnCheckConstraint(name, false);
        }
        if (name.equals(HibernateConstraintAnnotation.Range.name())) {
            return new RangeConstraint(name, false);
        }
        if (name.equals(HibernateConstraintAnnotation.URL.name())) {
            return new UrlConstraint(name, false);
        }
        return new Constraint(name);
    }

    public static Constraint createCopy(Constraint other) {
        Constraint copy = Constraint.create(other.getName());
        copy.copyFrom(other);
        return copy;
    }

    public List<String> getPropertyIds() {
        return Arrays.asList(NAME, ENABLED, "message");
    }

    public String toString() {
        if (!this.enabled) {
            return NOT_SET;
        }
        StringBuilder sb = new StringBuilder();
        this.appendParams(sb);
        if (sb.length() > 1) {
            sb.replace(0, 2, "(");
            sb.append(")");
        }
        sb.insert(0, this.name);
        sb.insert(0, "@");
        return sb.toString();
    }

    protected void appendParams(StringBuilder sb) {
        if (!StringUtil.isEmpty((String)this.message)) {
            sb.append(", message = \"");
            sb.append(StringUtils.abbreviate((String)this.message, (int)20));
            sb.append("\"");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        Constraint that = (Constraint)((Object)o);
        return this.enabled == that.enabled && Objects.equals(this.name, that.name) && Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.enabled, this.message);
    }
}

