/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.util;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.jpa.jpb.model.core.model.dbprop.DbProperties;
import com.intellij.jpa.jpb.model.core.model.dbprop.HsqlFileDbProperties;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.dbdrivers.DbDriversManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Properties;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.StringUtils;

public final class DbUtils {
    private static final Logger log = Logger.getInstance(DbUtils.class);
    public static final String DATABASE_PLUGIN_ID = "com.intellij.database";
    public static final File NATIVE_LIBS_ROOT = new File(PathManager.getSystemPath(), "jdbc-native-deps");

    public static Connection openConnection(Project project, DbProperties dbprops) throws SQLException, ClassNotFoundException {
        String currentSchema;
        DbType dbType;
        int loginTimeout;
        DbDriversManager.getInstance(project).loadDriver(dbprops.getDriver());
        log.debug(String.format("Opening connection to DB: url=%s, user=%s", dbprops.getUrl(), dbprops.getUser()));
        Properties props = new Properties();
        props.setProperty("user", dbprops.getUser());
        props.setProperty("password", dbprops.getPassword());
        if (dbprops instanceof HsqlFileDbProperties) {
            props.setProperty("shutdown", "true");
        }
        if ((loginTimeout = (dbType = dbprops.getType()).getLoginTimeout()) > 0) {
            props.setProperty("loginTimeout", String.valueOf(loginTimeout));
        }
        if (StringUtils.isNotBlank((CharSequence)(currentSchema = dbprops.getCurrentSchema()))) {
            props.setProperty("currentSchema", currentSchema);
        }
        String processedUrl = DbProperties.prepareDbProperties(project, dbprops).getUrl();
        return DriverManager.getConnection(Objects.requireNonNull(processedUrl), props);
    }

    public static boolean isDatabasePluginEnabled() {
        IdeaPluginDescriptor dbPlugin = StreamEx.of((Object[])PluginManagerCore.getPlugins()).findFirst(it -> DATABASE_PLUGIN_ID.equals(it.getPluginId().getIdString())).orElse(null);
        return dbPlugin != null && dbPlugin.isEnabled();
    }
}

