/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.dev.actions;

import com.intellij.code.provenance.core.ProvenanceRegistry;
import com.intellij.code.provenance.dev.ProvenanceDevRegistry;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/code/provenance/dev/actions/OpenProvenanceDatabaseFolderAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.code.provenance.dev"})
public final class OpenProvenanceDatabaseFolderAction
extends AnAction
implements DumbAware {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        String string = project2.getBasePath();
        if (string == null) {
            return;
        }
        String projectBasePath = string;
        Path projectRoot = Path.of(projectBasePath, new String[0]);
        Intrinsics.checkNotNull((Object)projectRoot);
        String cacheDirectoryName = ProjectUtil.getProjectCacheFileName((Path)projectRoot);
        Path dbPath = ProjectUtil.getProjectsDataDir().resolve(cacheDirectoryName).resolve("provenance");
        if (!Files.exists(dbPath, new LinkOption[0])) {
            Files.createDirectories(dbPath, new FileAttribute[0]);
        }
        RevealFileAction.openDirectory((Path)dbPath);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        e.getPresentation().setEnabledAndVisible(project != null && ProvenanceRegistry.INSTANCE.isProvenanceEnabled() && ProvenanceDevRegistry.INSTANCE.getEnabledDevActions());
    }
}

