/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.util;

import org.openjdk.jmc.flightrecorder.parser.ByteBufferWrapper;

public class DataInputToolkit {
    public static final byte BYTE_SIZE = 1;
    public static final byte BOOLEAN_SIZE = 1;
    public static final byte SHORT_SIZE = 2;
    public static final byte CHAR_SIZE = 2;
    public static final byte INTEGER_SIZE = 4;
    public static final byte LONG_SIZE = 8;
    public static final byte FLOAT_SIZE = 4;
    public static final byte DOUBLE_SIZE = 8;

    public static int readUnsignedByte(byte[] bytes, int offset) {
        return bytes[offset] & 0xFF;
    }

    public static byte readByte(byte[] bytes, int offset) {
        return bytes[offset];
    }

    public static int readUnsignedShort(byte[] bytes, int offset) {
        int ch1 = bytes[offset] & 0xFF;
        int ch2 = bytes[offset + 1] & 0xFF;
        return (ch1 << 8) + (ch2 << 0);
    }

    public static short readShort(byte[] bytes, int offset) {
        return (short)DataInputToolkit.readUnsignedShort(bytes, offset);
    }

    public static char readChar(byte[] bytes, int offset) {
        return (char)DataInputToolkit.readUnsignedShort(bytes, offset);
    }

    public static long readUnsignedInt(byte[] bytes, int index) {
        return (long)DataInputToolkit.readInt(bytes, index) & 0xFFFFFFFFL;
    }

    public static int readInt(byte[] bytes, int index) {
        int ch1 = bytes[index] & 0xFF;
        int ch2 = bytes[index + 1] & 0xFF;
        int ch3 = bytes[index + 2] & 0xFF;
        int ch4 = bytes[index + 3] & 0xFF;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public static long readLong(byte[] bytes, int index) {
        return ((long)bytes[index + 0] << 56) + ((long)(bytes[index + 1] & 0xFF) << 48) + ((long)(bytes[index + 2] & 0xFF) << 40) + ((long)(bytes[index + 3] & 0xFF) << 32) + ((long)(bytes[index + 4] & 0xFF) << 24) + (long)((bytes[index + 5] & 0xFF) << 16) + (long)((bytes[index + 6] & 0xFF) << 8) + (long)((bytes[index + 7] & 0xFF) << 0);
    }

    public static float readFloat(byte[] bytes, int offset) {
        return Float.intBitsToFloat(DataInputToolkit.readInt(bytes, offset));
    }

    public static double readDouble(byte[] bytes, int offset) {
        return Double.longBitsToDouble(DataInputToolkit.readLong(bytes, offset));
    }

    public static boolean readBoolean(byte[] bytes, int offset) {
        return bytes[offset] != 0;
    }

    public static int readUnsignedByte(ByteBufferWrapper bytes, int offset) {
        return Byte.toUnsignedInt(bytes.get(offset));
    }

    public static byte readByte(ByteBufferWrapper bytes, int offset) {
        return bytes.get(offset);
    }

    public static int readUnsignedShort(ByteBufferWrapper bytes, int offset) {
        return Short.toUnsignedInt(bytes.getShort(offset));
    }

    public static short readShort(ByteBufferWrapper bytes, int offset) {
        return bytes.getShort(offset);
    }

    public static char readChar(ByteBufferWrapper bytes, int offset) {
        return (char)DataInputToolkit.readUnsignedShort(bytes, offset);
    }

    public static long readUnsignedInt(ByteBufferWrapper bytes, int index) {
        return Integer.toUnsignedLong(bytes.getInt(index));
    }

    public static int readInt(ByteBufferWrapper bytes, int index) {
        return bytes.getInt(index);
    }

    public static long readLong(ByteBufferWrapper bytes, int index) {
        return bytes.getLong(index);
    }

    public static float readFloat(ByteBufferWrapper bytes, int offset) {
        return bytes.getFloat(offset);
    }

    public static double readDouble(ByteBufferWrapper bytes, int offset) {
        return bytes.getDouble(offset);
    }

    public static boolean readBoolean(ByteBufferWrapper bytes, int offset) {
        return bytes.get(offset) != 0;
    }
}

