/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.memleak;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openjdk.jmc.common.IMCOldObject;
import org.openjdk.jmc.common.IMCOldObjectGcRoot;
import org.openjdk.jmc.common.IMCType;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.memleak.ReferenceTreeObject;

public class ReferenceTreeModel {
    private final Map<IQuantity, ReferenceTreeObject> map = new HashMap<IQuantity, ReferenceTreeObject>();
    private final List<ReferenceTreeObject> rootObjects = new ArrayList<ReferenceTreeObject>();
    private final List<ReferenceTreeObject> leakObjects = new ArrayList<ReferenceTreeObject>();
    private final Map<IItem, ReferenceTreeObject> rootObjectsByLeakItems = new HashMap<IItem, ReferenceTreeObject>();

    private ReferenceTreeModel() {
    }

    public static ReferenceTreeModel buildReferenceTree(IItemCollection items) {
        ReferenceTreeModel model2 = new ReferenceTreeModel();
        for (IItemIterable itemIterable : items) {
            IType<IItem> type = itemIterable.getType();
            for (IItem item : itemIterable) {
                model2.add(item, JdkAttributes.OBJECT.getAccessor(type), JdkAttributes.ALLOCATION_TIME.getAccessor(type), JdkAttributes.GC_ROOT.getAccessor(type), type);
            }
        }
        return model2;
    }

    public List<ReferenceTreeObject> getRootObjects() {
        return this.rootObjects;
    }

    public List<ReferenceTreeObject> getLeakCandidates(double relevanceThreshold) {
        ArrayList<ReferenceTreeObject> candidates = new ArrayList<ReferenceTreeObject>();
        for (ReferenceTreeObject root : this.rootObjects) {
            int distanceFromRoot = 1;
            ReferenceTreeObject leakCandidate = null;
            for (ReferenceTreeObject child : root.getChildren()) {
                leakCandidate = this.setLeakRelevance(child, root, distanceFromRoot, leakCandidate);
                leakCandidate = this.getLeakCandidates(child, root, distanceFromRoot + 1, leakCandidate);
            }
            if (leakCandidate == null) continue;
            root.setLeakRelevance(leakCandidate.getLeakRelevance());
            if (!(leakCandidate.getLeakRelevance() > relevanceThreshold)) continue;
            candidates.add(leakCandidate);
        }
        return candidates;
    }

    private ReferenceTreeObject getLeakCandidates(ReferenceTreeObject object, ReferenceTreeObject root, int distanceFromRoot, ReferenceTreeObject leakCandidate) {
        ReferenceTreeObject candidate = leakCandidate;
        for (ReferenceTreeObject child : object.getChildren()) {
            int distance = distanceFromRoot + child.getReferrerSkip();
            candidate = this.setLeakRelevance(child, root, distance, candidate);
            candidate = this.getLeakCandidates(child, root, distance + 1, candidate);
        }
        return candidate;
    }

    private ReferenceTreeObject setLeakRelevance(ReferenceTreeObject object, ReferenceTreeObject root, int distanceFromRoot, ReferenceTreeObject leakCandidate) {
        int keptAlive = object.getObjectsKeptAliveCount();
        double localRatio = (double)keptAlive / (double)root.getObjectsKeptAliveCount();
        double globalRatio = (double)keptAlive / (double)this.leakObjects.size();
        double relevance = localRatio * (double)distanceFromRoot * globalRatio;
        object.setLeakRelevance(relevance);
        object.setDistanceFromRoot(distanceFromRoot);
        if (leakCandidate == null || leakCandidate.getLeakRelevance() < relevance) {
            return object;
        }
        return leakCandidate;
    }

    public Map<IMCType, List<ReferenceTreeObject>> getObjectsByType() {
        HashMap<IMCType, List<ReferenceTreeObject>> map2 = new HashMap<IMCType, List<ReferenceTreeObject>>();
        for (ReferenceTreeObject referenceTreeObject : this.leakObjects) {
            IMCType asType = referenceTreeObject.getType();
            ArrayList<ReferenceTreeObject> list = (ArrayList<ReferenceTreeObject>)map2.get(asType);
            if (list == null) {
                list = new ArrayList<ReferenceTreeObject>();
                map2.put(asType, list);
            }
            list.add(referenceTreeObject);
        }
        return map2;
    }

    public Collection<ReferenceTreeObject> getRootObjects(IRange<IQuantity> timerange) {
        ArrayList<ReferenceTreeObject> objects = new ArrayList<ReferenceTreeObject>();
        for (ReferenceTreeObject referenceTreeObject : this.rootObjects) {
            IQuantity itemTime = referenceTreeObject.getTimestamp();
            if (timerange.getStart().compareTo(itemTime) > 0 || timerange.getEnd().compareTo(itemTime) < 0) continue;
            objects.add(referenceTreeObject);
        }
        return objects;
    }

    public Collection<ReferenceTreeObject> getLeakObjects(IRange<IQuantity> timerange) {
        ArrayList<ReferenceTreeObject> objects = new ArrayList<ReferenceTreeObject>();
        for (ReferenceTreeObject referenceTreeObject : this.leakObjects) {
            IQuantity itemTime = referenceTreeObject.getTimestamp();
            if (timerange.getStart().compareTo(itemTime) > 0 || timerange.getEnd().compareTo(itemTime) < 0) continue;
            ReferenceTreeObject parent = referenceTreeObject.getParent();
            if (parent == null) {
                objects.add(referenceTreeObject);
                continue;
            }
            while (parent.getParent() != null) {
                parent = parent.getParent();
            }
            if (objects.contains(parent)) continue;
            objects.add(parent);
        }
        return objects;
    }

    public int getLeakCountInRange(IRange<IQuantity> timerange, ReferenceTreeObject referenceTreeObject) {
        int referencecount = 0;
        for (ReferenceTreeObject rtObject : this.leakObjects) {
            if (!rtObject.getRootObject().equals(referenceTreeObject.getRootObject()) || timerange.getStart().compareTo(rtObject.getTimestamp()) > 0 || timerange.getEnd().compareTo(rtObject.getTimestamp()) < 0) continue;
            ++referencecount;
        }
        return referencecount;
    }

    public List<ReferenceTreeObject> getLeakObjects() {
        return this.leakObjects;
    }

    public ReferenceTreeObject getObject(IQuantity address) {
        return this.map.get(address);
    }

    private void add(IItem item, IMemberAccessor<IMCOldObject, IItem> objectAccessor, IMemberAccessor<IQuantity, IItem> allocationTimeAccessor, IMemberAccessor<IMCOldObjectGcRoot, IItem> gcRootAccessor, IType<IItem> type) {
        IQuantity address;
        HashSet<IQuantity> addresses = new HashSet<IQuantity>();
        IQuantity timestamp = allocationTimeAccessor.getMember(item);
        IMCOldObject object = objectAccessor.getMember(item);
        addresses.add(object.getAddress());
        ReferenceTreeObject last = this.map.get(object.getAddress());
        if (last == null) {
            last = new ReferenceTreeObject(timestamp, object);
            last.addItem(item);
            this.leakObjects.add(last);
            this.map.put(object.getAddress(), last);
        }
        ReferenceTreeObject node = null;
        boolean root = true;
        object = object.getReferrer();
        while (object != null) {
            address = object.getAddress();
            if (address.longValue() == 0L) {
                Logger.getLogger(ReferenceTreeModel.class.getName()).log(Level.WARNING, "Found object without address, breaking parsing of referrer chain.");
                break;
            }
            if (addresses.contains(address)) {
                Logger.getLogger(ReferenceTreeModel.class.getName()).log(Level.WARNING, "Same addresses multiple times in same chain " + address);
                break;
            }
            addresses.add(address);
            node = this.map.get(address);
            if (node != null) {
                if (last != null) {
                    node.addChild(last);
                    ReferenceTreeObject parent = node.getParent();
                    if (parent == null) {
                        node.updateOldObjectSamples(this.map.get(objectAccessor.getMember(item).getAddress()));
                    } else {
                        while (parent.getParent() != null) {
                            parent = parent.getParent();
                        }
                        parent.updateOldObjectSamples(this.map.get(objectAccessor.getMember(item).getAddress()));
                    }
                }
                root = false;
                break;
            }
            node = new ReferenceTreeObject(timestamp, object);
            node.addRoot(gcRootAccessor.getMember(item));
            this.map.put(address, node);
            object = object.getReferrer();
            if (last != null) {
                node.addChild(last);
            }
            last = node;
        }
        if (last != null && root) {
            this.rootObjects.add(last);
            last.updateOldObjectSamples(this.map.get(objectAccessor.getMember(item).getAddress()));
            this.rootObjectsByLeakItems.put(item, last);
        }
        if ((object = objectAccessor.getMember(item)) != null) {
            address = object.getAddress();
            for (node = this.map.get(address); node != null; node = node.getParent()) {
                node.incrementObjectsKeptAliveCount();
                node.addItem(item);
            }
        }
    }
}

