/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModNamespace;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.util.DbUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DataStub {
    private static final int NAME_QUOTED = 1;
    private static final int NAME_SCRIPTED = 2;
    private static final int IS_CURRENT = 4;
    private final String name;
    private final int flags;

    private DataStub(String name, int flags) {
        this.name = name;
        this.flags = flags;
    }

    @NotNull
    public static String getName(@Nullable Object o) {
        if (o instanceof BasicElement) {
            String string = ((BasicElement)o).getName();
            if (string == null) {
                DataStub.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (o instanceof String) {
            String string = (String)o;
            if (string == null) {
                DataStub.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (o instanceof DataStub) {
            String string = ((DataStub)o).name;
            if (string == null) {
                DataStub.$$$reportNull$$$0(2);
            }
            return string;
        }
        return "";
    }

    public static boolean isNameQuoted(@Nullable Object o) {
        if (o instanceof BasicElement) {
            return o instanceof BasicNamedElement && ((BasicNamedElement)o).isNameQuoted();
        }
        return DataStub.isFlagSet(o, 1);
    }

    public static boolean isNameScripted(@Nullable Object o) {
        if (o instanceof BasicElement) {
            return o instanceof BasicNamedElement && ((BasicNamedElement)o).isNameScripted();
        }
        return DataStub.isFlagSet(o, 2);
    }

    public static boolean isCurrent(@Nullable Object o) {
        if (o instanceof BasicElement) {
            return o instanceof BasicMateNamespace && ((BasicMateNamespace)o).isCurrent();
        }
        return DataStub.isFlagSet(o, 4);
    }

    private static boolean isFlagSet(@Nullable Object o, int flag) {
        return o instanceof DataStub && (((DataStub)o).flags & flag) != 0;
    }

    @Nullable
    public static Object get(@Nullable Object o) {
        return o instanceof String || o instanceof DataStub ? o : null;
    }

    @NotNull
    public static Object create(@NotNull BasicElement e) {
        if (e == null) {
            DataStub.$$$reportNull$$$0(3);
        }
        Object object = DataStub.create(DataStub.getName(e), DataStub.getFlags(e));
        if (object == null) {
            DataStub.$$$reportNull$$$0(4);
        }
        return object;
    }

    @NotNull
    public static Object create(@NotNull Map<String, String> props) {
        if (props == null) {
            DataStub.$$$reportNull$$$0(5);
        }
        String name = DbUtil.intern((String)props.get(BasicModNamedElement.NAME.name));
        boolean quoted = "1".equals(props.get(BasicModNamedElement.NAME_QUOTED.name));
        boolean scripted = "1".equals(props.get(BasicModNamedElement.NAME_SCRIPTED.name));
        boolean current = "1".equals(props.get(BasicModNamespace.CURRENT.name));
        Object object = DataStub.create(name, DataStub.getFlags(quoted, scripted, current));
        if (object == null) {
            DataStub.$$$reportNull$$$0(6);
        }
        return object;
    }

    private static int getFlags(@NotNull BasicElement e) {
        if (e == null) {
            DataStub.$$$reportNull$$$0(7);
        }
        return DataStub.getFlags(DataStub.isNameQuoted(e), DataStub.isNameScripted(e), DataStub.isCurrent(e));
    }

    private static int getFlags(boolean quoted, boolean scripted, boolean current) {
        return (quoted ? 1 : 0) | (scripted ? 2 : 0) | (current ? 4 : 0);
    }

    private static Object create(String name, int flags) {
        return flags == 0 ? name : new DataStub(name, flags);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 5, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/DataStub";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "props";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/DataStub";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFlags";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 5, 7 -> new IllegalArgumentException(string);
        };
    }
}

