/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;

public class LinearComponentExtracter
implements GeometryComponentFilter {
    private Collection lines;
    private boolean isForcedToLineString = false;

    public static Collection getLines(Collection geoms, Collection lines2) {
        for (Geometry g : geoms) {
            LinearComponentExtracter.getLines(g, lines2);
        }
        return lines2;
    }

    public static Collection getLines(Collection geoms, Collection lines2, boolean forceToLineString) {
        for (Geometry g : geoms) {
            LinearComponentExtracter.getLines(g, lines2, forceToLineString);
        }
        return lines2;
    }

    public static Collection getLines(Geometry geom, Collection lines2) {
        if (geom instanceof LineString) {
            lines2.add(geom);
        } else {
            geom.apply(new LinearComponentExtracter(lines2));
        }
        return lines2;
    }

    public static Collection getLines(Geometry geom, Collection lines2, boolean forceToLineString) {
        geom.apply(new LinearComponentExtracter(lines2, forceToLineString));
        return lines2;
    }

    public static List getLines(Geometry geom) {
        return LinearComponentExtracter.getLines(geom, false);
    }

    public static List getLines(Geometry geom, boolean forceToLineString) {
        ArrayList lines2 = new ArrayList();
        geom.apply(new LinearComponentExtracter(lines2, forceToLineString));
        return lines2;
    }

    public static Geometry getGeometry(Geometry geom) {
        return geom.getFactory().buildGeometry(LinearComponentExtracter.getLines(geom));
    }

    public static Geometry getGeometry(Geometry geom, boolean forceToLineString) {
        return geom.getFactory().buildGeometry(LinearComponentExtracter.getLines(geom, forceToLineString));
    }

    public LinearComponentExtracter(Collection lines2) {
        this.lines = lines2;
    }

    public LinearComponentExtracter(Collection lines2, boolean isForcedToLineString) {
        this.lines = lines2;
        this.isForcedToLineString = isForcedToLineString;
    }

    public void setForceToLineString(boolean isForcedToLineString) {
        this.isForcedToLineString = isForcedToLineString;
    }

    @Override
    public void filter(Geometry geom) {
        if (this.isForcedToLineString && geom instanceof LinearRing) {
            LineString line = geom.getFactory().createLineString(((LinearRing)geom).getCoordinateSequence());
            this.lines.add(line);
            return;
        }
        if (geom instanceof LineString) {
            this.lines.add(geom);
        }
    }
}

