/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding;

import java.util.ArrayList;
import java.util.Collection;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.noding.Noder;
import org.locationtech.jts.noding.SegmentString;

public class ScaledNoder
implements Noder {
    private Noder noder;
    private double scaleFactor;
    private double offsetX;
    private double offsetY;
    private boolean isScaled = false;

    public ScaledNoder(Noder noder, double scaleFactor) {
        this(noder, scaleFactor, 0.0, 0.0);
    }

    public ScaledNoder(Noder noder, double scaleFactor, double offsetX, double offsetY) {
        this.noder = noder;
        this.scaleFactor = scaleFactor;
        this.isScaled = !this.isIntegerPrecision();
    }

    public boolean isIntegerPrecision() {
        return this.scaleFactor == 1.0;
    }

    @Override
    public Collection getNodedSubstrings() {
        Collection splitSS = this.noder.getNodedSubstrings();
        if (this.isScaled) {
            this.rescale(splitSS);
        }
        return splitSS;
    }

    @Override
    public void computeNodes(Collection inputSegStrings) {
        Collection intSegStrings = inputSegStrings;
        if (this.isScaled) {
            intSegStrings = this.scale(inputSegStrings);
        }
        this.noder.computeNodes(intSegStrings);
    }

    private Collection scale(Collection segStrings) {
        ArrayList<NodedSegmentString> nodedSegmentStrings = new ArrayList<NodedSegmentString>(segStrings.size());
        for (SegmentString ss : segStrings) {
            nodedSegmentStrings.add(new NodedSegmentString(this.scale(ss.getCoordinates()), ss.getData()));
        }
        return nodedSegmentStrings;
    }

    private Coordinate[] scale(Coordinate[] pts) {
        Coordinate[] roundPts = new Coordinate[pts.length];
        for (int i2 = 0; i2 < pts.length; ++i2) {
            roundPts[i2] = new Coordinate(Math.round((pts[i2].x - this.offsetX) * this.scaleFactor), Math.round((pts[i2].y - this.offsetY) * this.scaleFactor), pts[i2].getZ());
        }
        Coordinate[] roundPtsNoDup = CoordinateArrays.removeRepeatedPoints(roundPts);
        return roundPtsNoDup;
    }

    private void rescale(Collection segStrings) {
        for (SegmentString ss : segStrings) {
            this.rescale(ss.getCoordinates());
        }
    }

    private void rescale(Coordinate[] pts) {
        for (int i2 = 0; i2 < pts.length; ++i2) {
            pts[i2].x = pts[i2].x / this.scaleFactor + this.offsetX;
            pts[i2].y = pts[i2].y / this.scaleFactor + this.offsetY;
        }
    }
}

