/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.couchbase.types;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.types.DasTypeSystemImpl;
import com.intellij.database.dialects.couchbase.types.CouchbaseArrayType;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.containers.JBIterable;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J&\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/dialects/couchbase/types/CouchbaseTypeSystem;", "Lcom/intellij/database/dialects/base/types/DasTypeSystemImpl;", "<init>", "()V", "getDefaultTypeName", "", "cat", "Lcom/intellij/database/types/DasTypeCategory;", "doCreateArrayType", "Lcom/intellij/database/dialects/couchbase/types/CouchbaseArrayType;", "componentType", "Lcom/intellij/database/types/DasType;", "getDasType", "ref", "Lcom/intellij/sql/psi/SqlReference;", "resolved", "Lcom/intellij/psi/PsiElement;", "symbol", "Lcom/intellij/database/symbols/DasSymbol;", "intellij.database.dialects.couchbase"})
public final class CouchbaseTypeSystem
extends DasTypeSystemImpl {
    public CouchbaseTypeSystem() {
        Dbms dbms = Dbms.COUCHBASE_QUERY;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"COUCHBASE_QUERY");
        super(dbms);
    }

    @Nullable
    public String getDefaultTypeName(@NotNull DasTypeCategory cat) {
        Intrinsics.checkNotNullParameter((Object)cat, (String)"cat");
        return switch (WhenMappings.$EnumSwitchMapping$0[cat.ordinal()]) {
            case 1 -> "boolean";
            case 2, 3 -> "number";
            case 4 -> "string";
            case 5 -> "binary";
            case 6 -> "date";
            default -> null;
        };
    }

    @NotNull
    protected CouchbaseArrayType doCreateArrayType(@NotNull DasType componentType) {
        Intrinsics.checkNotNullParameter((Object)componentType, (String)"componentType");
        return new CouchbaseArrayType(componentType);
    }

    @NotNull
    public DasType getDasType(@Nullable SqlReference ref, @Nullable PsiElement resolved, @Nullable DasSymbol symbol) {
        if (symbol == null) {
            return super.getDasType(ref, resolved, null);
        }
        ObjectKind objectKind = symbol.getKind();
        if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.COLUMN)) {
            DasObject obj = symbol.getDasObject();
            DasObject dasObject = obj;
            if (dasObject == null || (dasObject = dasObject.getDasParent()) == null) {
                return super.getDasType(ref, resolved, symbol);
            }
            DasObject table = dasObject;
            JBIterable jBIterable = table.getDasChildren(ObjectKind.COLUMN).filter(DasColumn.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
            JBIterable allColumns = jBIterable;
            String prefix = symbol.getName() + ".";
            JBIterable jBIterable2 = allColumns.filter(arg_0 -> CouchbaseTypeSystem.getDasType$lambda$1(arg_0 -> CouchbaseTypeSystem.getDasType$lambda$0(prefix, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
            JBIterable children = jBIterable2;
            if (!children.isEmpty()) {
                SqlTableType sqlTableType = SqlImplUtil.createTableTypeWithColumns((SqlLanguageDialectEx)this.getSqlDialect(), (JBIterable)children, (PsiElement)resolved, (DasSymbol)symbol);
                Intrinsics.checkNotNullExpressionValue((Object)sqlTableType, (String)"createTableTypeWithColumns(...)");
                return (DasType)sqlTableType;
            }
            if (obj instanceof DasColumn && !(obj instanceof SqlTypedDefinition)) {
                DasType dasType = ((DasColumn)obj).getDasType();
                Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
                return dasType;
            }
        } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TABLE)) {
            DasTable table = (DasTable)symbol;
            JBIterable jBIterable = table.getDasChildren(ObjectKind.COLUMN).filter(DasColumn.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
            JBIterable columns = jBIterable;
            SqlTableType sqlTableType = SqlImplUtil.createTableTypeWithColumns((SqlLanguageDialectEx)this.getSqlDialect(), (JBIterable)columns, (PsiElement)resolved, (DasSymbol)symbol);
            Intrinsics.checkNotNullExpressionValue((Object)sqlTableType, (String)"createTableTypeWithColumns(...)");
            return (DasType)sqlTableType;
        }
        return super.getDasType(ref, resolved, symbol);
    }

    private static final boolean getDasType$lambda$0(String $prefix, DasColumn col) {
        Intrinsics.checkNotNullParameter((Object)col, (String)"col");
        String string = col.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return StringsKt.startsWith$default((String)string, (String)$prefix, (boolean)false, (int)2, null);
    }

    private static final boolean getDasType$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DasTypeCategory.values().length];
            try {
                nArray[DasTypeCategory.BOOLEAN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.INTEGER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.REAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.STRING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.BYTES.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.DATE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

