/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.messaging.providers;

import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.jam.reflect.JamMethodMeta;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.microservices.jvm.cache.CacheKeyPair;
import com.intellij.microservices.jvm.cache.JamCachedSearchUtils;
import com.intellij.microservices.jvm.cache.ScopedCacheValueHolder;
import com.intellij.microservices.jvm.cache.ScopedCacheValueHolders;
import com.intellij.microservices.jvm.mq.MQAccessTypes;
import com.intellij.microservices.jvm.mq.MQDestination;
import com.intellij.microservices.jvm.mq.MQDestinationAnchor;
import com.intellij.microservices.jvm.mq.MQType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.semantic.SemKey;
import com.intellij.spring.messaging.jam.mq.SpringJmsListener;
import com.intellij.spring.messaging.jam.mq.SpringJmsListeners;
import com.intellij.spring.messaging.jam.mq.SpringKafkaListener;
import com.intellij.spring.messaging.jam.mq.SpringKafkaListeners;
import com.intellij.spring.messaging.jam.mq.SpringRabbitListener;
import com.intellij.spring.messaging.jam.mq.SpringRabbitListeners;
import com.intellij.util.text.PlaceholderTextRanges;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019J\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019J\u0012\u0010 \u001a\u00020\u001b2\b\u0010!\u001a\u0004\u0018\u00010\u0005H\u0007J\u0010\u0010\"\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u0005H\u0007J \u0010\"\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005H\u0003J,\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00050(2\u0006\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/spring/messaging/providers/SpringMQUtils;", "", "<init>", "()V", "SPRING_RABBIT_MAVEN", "", "SPRING_JMS_MAVEN", "SPRING_KAFKA_MAVEN", "JMS_LISTENER_CACHE_KEY", "Lcom/intellij/microservices/jvm/cache/CacheKeyPair;", "", "Lcom/intellij/spring/messaging/jam/mq/SpringJmsListener;", "JMS_LISTENERS_CACHE_KEY", "Lcom/intellij/spring/messaging/jam/mq/SpringJmsListeners;", "KAFKA_LISTENER_CACHE_KEY", "Lcom/intellij/spring/messaging/jam/mq/SpringKafkaListener;", "KAFKA_LISTENERS_CACHE_KEY", "Lcom/intellij/spring/messaging/jam/mq/SpringKafkaListeners;", "RABBIT_LISTENER_CACHE_KEY", "Lcom/intellij/spring/messaging/jam/mq/SpringRabbitListener;", "RABBIT_LISTENERS_CACHE_KEY", "Lcom/intellij/spring/messaging/jam/mq/SpringRabbitListeners;", "getRabbitListeners", "Lkotlin/sequences/Sequence;", "project", "Lcom/intellij/openapi/project/Project;", "hasSpringAmqpLibrary", "", "getJmsListeners", "hasSpringJmsLibrary", "getKafkaListeners", "hasSpringKafkaLibrary", "isKnownDestination", "mqDestination", "hasPlaceholders", "prefix", "suffix", "collectDestination", "", "element", "Lcom/intellij/jam/JamStringAttributeElement;", "mqType", "Lcom/intellij/microservices/jvm/mq/MQType;", "collector", "", "Lcom/intellij/microservices/jvm/mq/MQDestinationAnchor;", "intellij.spring.messaging"})
public final class SpringMQUtils {
    @NotNull
    public static final SpringMQUtils INSTANCE = new SpringMQUtils();
    @NotNull
    private static final String SPRING_RABBIT_MAVEN = "org.springframework.amqp:spring-rabbit";
    @NotNull
    private static final String SPRING_JMS_MAVEN = "org.springframework:spring-jms";
    @NotNull
    private static final String SPRING_KAFKA_MAVEN = "org.springframework.kafka:spring-kafka";
    @NotNull
    private static final CacheKeyPair<List<SpringJmsListener>> JMS_LISTENER_CACHE_KEY = new CacheKeyPair("SPRING_JMS_LISTENER");
    @NotNull
    private static final CacheKeyPair<List<SpringJmsListeners>> JMS_LISTENERS_CACHE_KEY = new CacheKeyPair("SPRING_JMS_LISTENERS");
    @NotNull
    private static final CacheKeyPair<List<SpringKafkaListener>> KAFKA_LISTENER_CACHE_KEY = new CacheKeyPair("SPRING_KAFKA_LISTENER");
    @NotNull
    private static final CacheKeyPair<List<SpringKafkaListeners>> KAFKA_LISTENERS_CACHE_KEY = new CacheKeyPair("SPRING_KAFKA_LISTENERS");
    @NotNull
    private static final CacheKeyPair<List<SpringRabbitListener>> RABBIT_LISTENER_CACHE_KEY = new CacheKeyPair("SPRING_RABBIT_LISTENER");
    @NotNull
    private static final CacheKeyPair<List<SpringRabbitListeners>> RABBIT_LISTENERS_CACHE_KEY = new CacheKeyPair("SPRING_RABBIT_LISTENERS");

    private SpringMQUtils() {
    }

    @NotNull
    public final Sequence<SpringRabbitListener> getRabbitListeners(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ScopedCacheValueHolder scopedCacheValueHolder = ScopedCacheValueHolders.asCacheValueHolder((Project)project);
        SemKey<SpringRabbitListener> semKey = SpringRabbitListener.REPEATABLE_ANNO_JAM_KEY;
        Intrinsics.checkNotNullExpressionValue(semKey, (String)"REPEATABLE_ANNO_JAM_KEY");
        Sequence listenerSeq = JamCachedSearchUtils.sequenceJamMethodsWithLibsCache((ScopedCacheValueHolder)scopedCacheValueHolder, RABBIT_LISTENER_CACHE_KEY, semKey, (String)"org.springframework.amqp.rabbit.annotation.RabbitListener");
        ScopedCacheValueHolder scopedCacheValueHolder2 = ScopedCacheValueHolders.asCacheValueHolder((Project)project);
        JamMethodMeta<SpringRabbitListeners> jamMethodMeta = SpringRabbitListeners.META;
        Intrinsics.checkNotNullExpressionValue(jamMethodMeta, (String)"META");
        Sequence listenerContainersSeq = SequencesKt.flatMap((Sequence)SequencesKt.filter((Sequence)JamCachedSearchUtils.sequenceJamMethodsWithLibsCache((ScopedCacheValueHolder)scopedCacheValueHolder2, RABBIT_LISTENERS_CACHE_KEY, (JamMemberMeta)((JamMemberMeta)jamMethodMeta), (String)"org.springframework.amqp.rabbit.annotation.RabbitListeners"), SpringMQUtils::getRabbitListeners$lambda$0), SpringMQUtils::getRabbitListeners$lambda$1);
        return SequencesKt.plus((Sequence)listenerSeq, (Sequence)listenerContainersSeq);
    }

    public final boolean hasSpringAmqpLibrary(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JavaLibraryUtil.hasLibraryJar((Project)project, (String)SPRING_RABBIT_MAVEN);
    }

    @NotNull
    public final Sequence<SpringJmsListener> getJmsListeners(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ScopedCacheValueHolder scopedCacheValueHolder = ScopedCacheValueHolders.asCacheValueHolder((Project)project);
        SemKey<SpringJmsListener> semKey = SpringJmsListener.REPEATABLE_ANNO_JAM_KEY;
        Intrinsics.checkNotNullExpressionValue(semKey, (String)"REPEATABLE_ANNO_JAM_KEY");
        Sequence listenerSeq = JamCachedSearchUtils.sequenceJamMethodsWithLibsCache((ScopedCacheValueHolder)scopedCacheValueHolder, JMS_LISTENER_CACHE_KEY, semKey, (String)"org.springframework.jms.annotation.JmsListener");
        ScopedCacheValueHolder scopedCacheValueHolder2 = ScopedCacheValueHolders.asCacheValueHolder((Project)project);
        JamMethodMeta<SpringJmsListeners> jamMethodMeta = SpringJmsListeners.META;
        Intrinsics.checkNotNullExpressionValue(jamMethodMeta, (String)"META");
        Sequence listenerContainersSeq = SequencesKt.flatMap((Sequence)SequencesKt.filter((Sequence)JamCachedSearchUtils.sequenceJamMethodsWithLibsCache((ScopedCacheValueHolder)scopedCacheValueHolder2, JMS_LISTENERS_CACHE_KEY, (JamMemberMeta)((JamMemberMeta)jamMethodMeta), (String)"org.springframework.jms.annotation.JmsListeners"), SpringMQUtils::getJmsListeners$lambda$0), SpringMQUtils::getJmsListeners$lambda$1);
        return SequencesKt.plus((Sequence)listenerSeq, (Sequence)listenerContainersSeq);
    }

    public final boolean hasSpringJmsLibrary(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JavaLibraryUtil.hasLibraryJar((Project)project, (String)SPRING_JMS_MAVEN);
    }

    @NotNull
    public final Sequence<SpringKafkaListener> getKafkaListeners(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ScopedCacheValueHolder scopedCacheValueHolder = ScopedCacheValueHolders.asCacheValueHolder((Project)project);
        SemKey<SpringKafkaListener> semKey = SpringKafkaListener.REPEATABLE_ANNO_JAM_KEY;
        Intrinsics.checkNotNullExpressionValue(semKey, (String)"REPEATABLE_ANNO_JAM_KEY");
        Sequence listenerSeq = JamCachedSearchUtils.sequenceJamMethodsWithLibsCache((ScopedCacheValueHolder)scopedCacheValueHolder, KAFKA_LISTENER_CACHE_KEY, semKey, (String)"org.springframework.kafka.annotation.KafkaListener");
        ScopedCacheValueHolder scopedCacheValueHolder2 = ScopedCacheValueHolders.asCacheValueHolder((Project)project);
        JamMethodMeta<SpringKafkaListeners> jamMethodMeta = SpringKafkaListeners.META;
        Intrinsics.checkNotNullExpressionValue(jamMethodMeta, (String)"META");
        Sequence listenerContainersSeq = SequencesKt.flatMap((Sequence)SequencesKt.filter((Sequence)JamCachedSearchUtils.sequenceJamMethodsWithLibsCache((ScopedCacheValueHolder)scopedCacheValueHolder2, KAFKA_LISTENERS_CACHE_KEY, (JamMemberMeta)((JamMemberMeta)jamMethodMeta), (String)"org.springframework.kafka.annotation.KafkaListeners"), SpringMQUtils::getKafkaListeners$lambda$0), SpringMQUtils::getKafkaListeners$lambda$1);
        return SequencesKt.plus((Sequence)listenerSeq, (Sequence)listenerContainersSeq);
    }

    public final boolean hasSpringKafkaLibrary(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JavaLibraryUtil.hasLibraryJar((Project)project, (String)SPRING_KAFKA_MAVEN);
    }

    @JvmStatic
    @Contract(value="null -> false", pure=true)
    public static final boolean isKnownDestination(@Nullable String mqDestination) {
        CharSequence charSequence = mqDestination;
        return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && !SpringMQUtils.hasPlaceholders(mqDestination);
    }

    @JvmStatic
    public static final boolean hasPlaceholders(@NotNull String mqDestination) {
        Intrinsics.checkNotNullParameter((Object)mqDestination, (String)"mqDestination");
        return SpringMQUtils.hasPlaceholders(mqDestination, "${", "}") || SpringMQUtils.hasPlaceholders(mqDestination, "#{", "}");
    }

    @JvmStatic
    private static final boolean hasPlaceholders(String mqDestination, String prefix, String suffix) {
        Set set = PlaceholderTextRanges.getPlaceholderRanges((String)mqDestination, (String)prefix, (String)suffix);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getPlaceholderRanges(...)");
        return !((Collection)set).isEmpty();
    }

    @JvmStatic
    public static final void collectDestination(@NotNull JamStringAttributeElement<String> element, @NotNull MQType mqType, @NotNull List<MQDestinationAnchor> collector) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)mqType, (String)"mqType");
        Intrinsics.checkNotNullParameter(collector, (String)"collector");
        PsiAnnotationMemberValue psiAnnotationMemberValue = element.getPsiElement();
        if (psiAnnotationMemberValue == null) {
            return;
        }
        PsiAnnotationMemberValue psi = psiAnnotationMemberValue;
        String string = element.getStringValue();
        if (string == null) {
            return;
        }
        String name = string;
        collector.add(new MQDestinationAnchor(new MQDestination(mqType, name), (PsiElement)psi, MQAccessTypes.RECEIVE_TYPE));
    }

    private static final boolean getRabbitListeners$lambda$0(SpringRabbitListeners it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isValid();
    }

    private static final Sequence getRabbitListeners$lambda$1(SpringRabbitListeners it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List<SpringRabbitListener> list = it.getListeners();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getListeners(...)");
        return CollectionsKt.asSequence((Iterable)list);
    }

    private static final boolean getJmsListeners$lambda$0(SpringJmsListeners it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isValid();
    }

    private static final Sequence getJmsListeners$lambda$1(SpringJmsListeners it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List<SpringJmsListener> list = it.getListeners();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getListeners(...)");
        return CollectionsKt.asSequence((Iterable)list);
    }

    private static final boolean getKafkaListeners$lambda$0(SpringKafkaListeners it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isValid();
    }

    private static final Sequence getKafkaListeners$lambda$1(SpringKafkaListeners it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List<SpringKafkaListener> list = it.getListeners();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getListeners(...)");
        return CollectionsKt.asSequence((Iterable)list);
    }
}

