/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.raster.view;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.AffineTransform;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.Rectangle;
import org.jetbrains.letsPlot.commons.intern.observable.property.ReadableProperty;
import org.jetbrains.letsPlot.commons.intern.observable.property.ValueProperty;
import org.jetbrains.letsPlot.commons.registration.Registration;
import org.jetbrains.letsPlot.core.canvas.AnimationProvider;
import org.jetbrains.letsPlot.core.canvas.Canvas;
import org.jetbrains.letsPlot.core.canvas.CanvasControl;
import org.jetbrains.letsPlot.core.canvas.CanvasProvider;
import org.jetbrains.letsPlot.core.canvas.Context2d;
import org.jetbrains.letsPlot.core.canvas.Context2dKt;
import org.jetbrains.letsPlot.core.canvas.Path2d;
import org.jetbrains.letsPlot.core.canvasFigure.CanvasFigure;
import org.jetbrains.letsPlot.datamodel.mapping.framework.MappingContext;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNodeContainer;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNodeContainerListener;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgSvgElement;
import org.jetbrains.letsPlot.datamodel.svg.event.SvgAttributeEvent;
import org.jetbrains.letsPlot.raster.mapping.svg.SvgCanvasPeer;
import org.jetbrains.letsPlot.raster.mapping.svg.SvgSvgElementMapper;
import org.jetbrains.letsPlot.raster.mapping.svg.TextMeasurer;
import org.jetbrains.letsPlot.raster.shape.Container;
import org.jetbrains.letsPlot.raster.shape.Element;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00190!H\u0016J\b\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010&\u001a\u00020\fH\u0002J\u001e\u0010'\u001a\u00020#2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010+\u001a\u00020,H\u0002J\u0018\u0010-\u001a\u00020#2\u0006\u0010.\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\b\u0010/\u001a\u00020#H\u0002J\b\u00100\u001a\u00020#H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0012X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u0004R\u0010\u0010\u001f\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/jetbrains/letsPlot/raster/view/SvgCanvasFigure;", "Lorg/jetbrains/letsPlot/core/canvasFigure/CanvasFigure;", "svg", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgSvgElement;", "(Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgSvgElement;)V", "canvasControl", "Lorg/jetbrains/letsPlot/core/canvas/CanvasControl;", "canvasPeer", "Lorg/jetbrains/letsPlot/raster/mapping/svg/SvgCanvasPeer;", "contentCanvas", "Lorg/jetbrains/letsPlot/core/canvas/Canvas;", "needMapSvgSvgElement", "", "needRedraw", "needResizeContentCanvas", "nodeContainer", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgNodeContainer;", "rootMapper", "Lorg/jetbrains/letsPlot/raster/mapping/svg/SvgSvgElementMapper;", "getRootMapper$plot_raster", "()Lorg/jetbrains/letsPlot/raster/mapping/svg/SvgSvgElementMapper;", "setRootMapper$plot_raster", "(Lorg/jetbrains/letsPlot/raster/mapping/svg/SvgSvgElementMapper;)V", "svgBounds", "Lorg/jetbrains/letsPlot/commons/intern/observable/property/ValueProperty;", "Lorg/jetbrains/letsPlot/commons/geometry/Rectangle;", "value", "svgSvgElement", "getSvgSvgElement", "()Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgSvgElement;", "setSvgSvgElement", "textMeasureCanvas", "bounds", "Lorg/jetbrains/letsPlot/commons/intern/observable/property/ReadableProperty;", "mapSvgSvgElement", "", "mapToCanvas", "Lorg/jetbrains/letsPlot/commons/registration/Registration;", "onAnimationFrame", "render", "elements", "", "Lorg/jetbrains/letsPlot/raster/shape/Element;", "ctx", "Lorg/jetbrains/letsPlot/core/canvas/Context2d;", "renderElement", "element", "requestRedraw", "resizeContentCanvas", "plot-raster"})
@SourceDebugExtension(value={"SMAP\nSvgCanvasFigure.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SvgCanvasFigure.kt\norg/jetbrains/letsPlot/raster/view/SvgCanvasFigure\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,186:1\n1#2:187\n1855#3,2:188\n*S KotlinDebug\n*F\n+ 1 SvgCanvasFigure.kt\norg/jetbrains/letsPlot/raster/view/SvgCanvasFigure\n*L\n144#1:188,2\n*E\n"})
public final class SvgCanvasFigure
implements CanvasFigure {
    @NotNull
    private SvgSvgElement svgSvgElement;
    private boolean needMapSvgSvgElement;
    private boolean needRedraw;
    private boolean needResizeContentCanvas;
    @Nullable
    private SvgNodeContainer nodeContainer;
    @Nullable
    private SvgCanvasPeer canvasPeer;
    @Nullable
    private Canvas contentCanvas;
    @Nullable
    private CanvasControl canvasControl;
    @Nullable
    private Canvas textMeasureCanvas;
    public SvgSvgElementMapper rootMapper;
    @NotNull
    private final ValueProperty<Rectangle> svgBounds;

    public SvgCanvasFigure(@NotNull SvgSvgElement svg) {
        Intrinsics.checkNotNullParameter((Object)svg, (String)"svg");
        this.svgSvgElement = svg;
        this.needMapSvgSvgElement = true;
        this.needRedraw = true;
        this.needResizeContentCanvas = true;
        this.svgBounds = new ValueProperty((Object)new Rectangle(0, 0, 0, 0));
    }

    public /* synthetic */ SvgCanvasFigure(SvgSvgElement svgSvgElement, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            svgSvgElement = new SvgSvgElement();
        }
        this(svgSvgElement);
    }

    @NotNull
    public final SvgSvgElement getSvgSvgElement() {
        return this.svgSvgElement;
    }

    public final void setSvgSvgElement(@NotNull SvgSvgElement value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.svgSvgElement = value;
        Double width = (Double)value.width().get();
        Double height = (Double)value.height().get();
        if (width != null && height != null) {
            this.svgBounds.set((Object)new Rectangle(0, 0, (int)width.doubleValue(), (int)height.doubleValue()));
        }
        this.needMapSvgSvgElement = true;
        this.needResizeContentCanvas = true;
    }

    @NotNull
    public final SvgSvgElementMapper getRootMapper$plot_raster() {
        SvgSvgElementMapper svgSvgElementMapper = this.rootMapper;
        if (svgSvgElementMapper != null) {
            return svgSvgElementMapper;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"rootMapper");
        return null;
    }

    public final void setRootMapper$plot_raster(@NotNull SvgSvgElementMapper svgSvgElementMapper) {
        Intrinsics.checkNotNullParameter((Object)((Object)svgSvgElementMapper), (String)"<set-?>");
        this.rootMapper = svgSvgElementMapper;
    }

    @NotNull
    public ReadableProperty<Rectangle> bounds() {
        return (ReadableProperty)this.svgBounds;
    }

    @NotNull
    public Registration mapToCanvas(@NotNull CanvasControl canvasControl) {
        Intrinsics.checkNotNullParameter((Object)canvasControl, (String)"canvasControl");
        this.canvasControl = canvasControl;
        Canvas canvas = this.textMeasureCanvas = canvasControl.createCanvas((Number)0, (Number)0);
        if (canvas == null) {
            throw new IllegalStateException("Should not happen - textMeasureCanvas is null".toString());
        }
        canvasControl.addChild(canvas);
        Canvas canvas2 = this.textMeasureCanvas;
        if (canvas2 == null) {
            throw new IllegalStateException("Should not happen - textMeasureCanvas is null".toString());
        }
        TextMeasurer textMeasurer = TextMeasurer.Companion.create(canvas2);
        this.canvasPeer = new SvgCanvasPeer(textMeasurer, (CanvasProvider)canvasControl);
        this.onAnimationFrame();
        AnimationProvider.AnimationTimer anim2 = canvasControl.createAnimationTimer(AnimationProvider.AnimationEventHandler.Companion.toHandler((Function1)new Function1<Long, Boolean>(this){
            final /* synthetic */ SvgCanvasFigure this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(long it) {
                return SvgCanvasFigure.access$onAnimationFrame(this.this$0);
            }
        }));
        anim2.start();
        return new Registration(this, canvasControl, anim2){
            final /* synthetic */ SvgCanvasFigure this$0;
            final /* synthetic */ CanvasControl $canvasControl;
            final /* synthetic */ AnimationProvider.AnimationTimer $anim;
            {
                this.this$0 = $receiver;
                this.$canvasControl = $canvasControl;
                this.$anim = $anim;
            }

            protected void doRemove() {
                Canvas p0;
                CanvasControl canvasControl;
                Canvas canvas;
                Canvas canvas2 = SvgCanvasFigure.access$getContentCanvas$p(this.this$0);
                if (canvas2 != null) {
                    canvas = canvas2;
                    canvasControl = this.$canvasControl;
                    p0 = canvas;
                    boolean bl = false;
                    canvasControl.removeChild(p0);
                }
                Canvas canvas3 = SvgCanvasFigure.access$getTextMeasureCanvas$p(this.this$0);
                if (canvas3 != null) {
                    canvas = canvas3;
                    canvasControl = this.$canvasControl;
                    p0 = canvas;
                    boolean bl = false;
                    canvasControl.removeChild(p0);
                }
                this.this$0.getRootMapper$plot_raster().detachRoot();
                this.$anim.stop();
                SvgCanvasFigure.access$setCanvasControl$p(this.this$0, null);
            }
        };
    }

    private final void mapSvgSvgElement() {
        SvgCanvasPeer svgCanvasPeer = this.canvasPeer;
        if (svgCanvasPeer == null) {
            return;
        }
        SvgCanvasPeer canvasPeer = svgCanvasPeer;
        SvgNodeContainer svgNodeContainer = this.nodeContainer = new SvgNodeContainer(this.svgSvgElement);
        Intrinsics.checkNotNull((Object)svgNodeContainer);
        svgNodeContainer.addListener(new SvgNodeContainerListener(this){
            final /* synthetic */ SvgCanvasFigure this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAttributeSet(@NotNull SvgElement element, @NotNull SvgAttributeEvent<?> event) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter(event, (String)"event");
                SvgCanvasFigure.access$requestRedraw(this.this$0);
            }

            public void onNodeAttached(@NotNull SvgNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                SvgCanvasFigure.access$requestRedraw(this.this$0);
            }

            public void onNodeDetached(@NotNull SvgNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                SvgCanvasFigure.access$requestRedraw(this.this$0);
            }
        });
        this.setRootMapper$plot_raster(new SvgSvgElementMapper(this.svgSvgElement, canvasPeer));
        this.getRootMapper$plot_raster().attachRoot(new MappingContext());
        this.needMapSvgSvgElement = false;
    }

    private final void resizeContentCanvas() {
        int n;
        int n2;
        CanvasControl canvasControl = this.canvasControl;
        if (canvasControl == null) {
            return;
        }
        CanvasControl canvasControl2 = canvasControl;
        Canvas canvas = this.contentCanvas;
        if (canvas != null) {
            Canvas it = canvas;
            boolean bl = false;
            canvasControl2.removeChild(it);
        }
        Double d = (Double)this.svgSvgElement.width().get();
        if (d != null) {
            double it = ((Number)d).doubleValue();
            boolean bl = false;
            n2 = (int)Math.ceil(it);
        } else {
            n2 = 0;
        }
        int contentWidth = n2;
        Double d2 = (Double)this.svgSvgElement.height().get();
        if (d2 != null) {
            double it = ((Number)d2).doubleValue();
            boolean bl = false;
            n = (int)Math.ceil(it);
        } else {
            n = 0;
        }
        int contentHeight = n;
        Canvas newContentCanvas = canvasControl2.createCanvas((Number)contentWidth, (Number)contentHeight);
        canvasControl2.addChild(newContentCanvas);
        this.contentCanvas = newContentCanvas;
        this.needResizeContentCanvas = false;
        this.svgBounds.set((Object)new Rectangle(0, 0, contentWidth, contentHeight));
    }

    private final boolean onAnimationFrame() {
        if (this.needMapSvgSvgElement) {
            this.mapSvgSvgElement();
            this.needRedraw = true;
        }
        if (this.needResizeContentCanvas) {
            this.resizeContentCanvas();
            this.needRedraw = true;
        }
        if (!this.needRedraw) {
            return false;
        }
        Canvas canvas = this.contentCanvas;
        if (canvas == null) {
            return false;
        }
        Canvas canvas2 = canvas;
        canvas2.getContext2d().clearRect(DoubleRectangle.Companion.XYWH((Number)0.0, (Number)0.0, (Number)canvas2.getSize().getX(), (Number)canvas2.getSize().getY()));
        this.renderElement((Element)this.getRootMapper$plot_raster().getTarget(), canvas2.getContext2d());
        this.needRedraw = false;
        return true;
    }

    private final void render(List<? extends Element> elements, Context2d ctx) {
        Iterable $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element element = (Element)element$iv;
            boolean bl = false;
            this.renderElement(element, ctx);
        }
    }

    private final void renderElement(Element element, Context2d ctx) {
        if (!element.isVisible()) {
            return;
        }
        boolean needRestore = false;
        if (!element.getTransform().isIdentity()) {
            needRestore = true;
            ctx.save();
            Context2dKt.affineTransform((Context2d)ctx, (AffineTransform)element.getTransform());
        }
        Path2d path2d = element.getClipPath();
        if (path2d != null) {
            Path2d clipPath = path2d;
            boolean bl = false;
            if (!needRestore) {
                ctx.save();
                needRestore = true;
            }
            ctx.beginPath();
            Context2dKt.applyPath((Context2d)ctx, (List)clipPath.getCommands());
            ctx.closePath();
            ctx.clip();
        }
        element.render(ctx);
        if (element instanceof Container) {
            this.render((List)((Container)element).getChildren(), ctx);
        }
        if (needRestore) {
            ctx.restore();
        }
    }

    private final void requestRedraw() {
        this.needRedraw = true;
    }

    public SvgCanvasFigure() {
        this(null, 1, null);
    }

    public static final /* synthetic */ boolean access$onAnimationFrame(SvgCanvasFigure $this) {
        return $this.onAnimationFrame();
    }

    public static final /* synthetic */ Canvas access$getContentCanvas$p(SvgCanvasFigure $this) {
        return $this.contentCanvas;
    }

    public static final /* synthetic */ Canvas access$getTextMeasureCanvas$p(SvgCanvasFigure $this) {
        return $this.textMeasureCanvas;
    }

    public static final /* synthetic */ void access$setCanvasControl$p(SvgCanvasFigure $this, CanvasControl canvasControl) {
        $this.canvasControl = canvasControl;
    }

    public static final /* synthetic */ void access$requestRedraw(SvgCanvasFigure $this) {
        $this.requestRedraw();
    }
}

