/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.GenericJdbcHelperBase;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import java.sql.Connection;
import java.sql.Driver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DatabricksJdbcHelper
extends GenericJdbcHelperBase {
    public DatabricksJdbcHelper(@Nullable String version, @Nullable Connection connection, @Nullable ClassLoader jdbcClassLoader) {
        super("DATABRICKS", version, connection, jdbcClassLoader);
    }

    public DatabricksJdbcHelper() {
        this(null, null, null);
    }

    private DatabricksJdbcHelper(@NotNull DatabricksJdbcHelper helper, @NotNull ClassLoader jdbcCLassLoader) {
        if (helper == null) {
            DatabricksJdbcHelper.$$$reportNull$$$0(0);
        }
        if (jdbcCLassLoader == null) {
            DatabricksJdbcHelper.$$$reportNull$$$0(1);
        }
        super(helper, jdbcCLassLoader);
    }

    @Override
    @NotNull
    protected GenericJdbcHelperBase create(@Nullable Connection delegate, @Nullable String product, String version, @Nullable ClassLoader jdbcClassLoader) {
        return new DatabricksJdbcHelper(version, delegate, jdbcClassLoader);
    }

    @Override
    public JdbcHelperImpl create(@Nullable String version, @Nullable Connection connection, @Nullable ClassLoader jdbcClassLoader) {
        return new DatabricksJdbcHelper(version, connection, jdbcClassLoader);
    }

    @Override
    public JdbcHelperImpl bindClassLoader(@NotNull ClassLoader jdbcClassLoader) {
        if (jdbcClassLoader == null) {
            DatabricksJdbcHelper.$$$reportNull$$$0(2);
        }
        return new DatabricksJdbcHelper(this, jdbcClassLoader);
    }

    @Override
    public boolean detect(@NotNull Driver driver, @Nullable String url) {
        if (driver == null) {
            DatabricksJdbcHelper.$$$reportNull$$$0(3);
        }
        return JdbcNativeUtil.detectString(url, ":databricks:");
    }

    @Override
    public GenericJdbcHelperBase detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer, @Nullable JdbcHelperImpl connectHelper, @Nullable ClassLoader jdbcClassLoader) throws Exception {
        String driverName;
        if (JdbcNativeUtil.detectString(product, "databricks")) {
            return super.detect(delegate, product, productVer, connectHelper, jdbcClassLoader);
        }
        if (delegate == null) {
            return null;
        }
        try {
            driverName = delegate.getMetaData().getDriverName();
        }
        catch (Throwable th) {
            driverName = null;
        }
        if (JdbcNativeUtil.detectString(driverName, "databricks")) {
            return super.detect(delegate, driverName, productVer, connectHelper, jdbcClassLoader);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdbcCLassLoader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdbcClassLoader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/DatabricksJdbcHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "bindClassLoader";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "detect";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

