/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.find;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.kotlin.jupyter.core.editor.find.FindUsagesHandlerKt;
import com.intellij.kotlin.jupyter.core.editor.find.NotebookReferenceFinder;
import com.intellij.kotlin.jupyter.core.editor.find.PsiRefHelpersKt;
import com.intellij.kotlin.jupyter.core.editor.find.ReferenceSearchStrategy;
import com.intellij.kotlin.jupyter.core.scriptingSupport.NotebookStructurePerFileTracker;
import com.intellij.kotlin.jupyter.core.scriptingSupport.NotebookStructureTrackerService;
import com.intellij.kotlin.jupyter.core.util.IsKotlinNotebookKt;
import com.intellij.kotlin.jupyter.core.util.UtilKt;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtScript;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a.\u0010\u0000\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"searchForElementDeclarationOrUsages", "", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "target", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "searchStrategy", "Lcom/intellij/kotlin/jupyter/core/editor/find/ReferenceSearchStrategy;", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\npsiAware.kt\nKotlin\n*S Kotlin\n*F\n+ 1 psiAware.kt\ncom/intellij/kotlin/jupyter/core/editor/find/PsiAwareKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,86:1\n1#2:87\n27#3:88\n*S KotlinDebug\n*F\n+ 1 psiAware.kt\ncom/intellij/kotlin/jupyter/core/editor/find/PsiAwareKt\n*L\n39#1:88\n*E\n"})
public final class PsiAwareKt {
    @Nullable
    public static final Set<PsiElement> searchForElementDeclarationOrUsages(@NotNull Project project, @NotNull PsiElement target, @NotNull VirtualFile virtualFile, @NotNull ReferenceSearchStrategy searchStrategy) {
        Set<String> targetClassName;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)((Object)searchStrategy), (String)"searchStrategy");
        if (!IsKotlinNotebookKt.isKotlinNotebook(virtualFile)) {
            return null;
        }
        InjectedLanguageManager injectedManager = InjectedLanguageManager.getInstance((Project)project);
        Set foundData = new LinkedHashSet();
        PsiFile psiFile = UtilKt.findPsiFile(virtualFile, project);
        if (psiFile == null) {
            return null;
        }
        PsiFile asPsiFile = psiFile;
        Collection collection = UtilKt.getNotebookCells(asPsiFile);
        if (collection.isEmpty()) {
            boolean bl = false;
            return null;
        }
        List notebookCells = (List)collection;
        BackedNotebookVirtualFile backedNotebookVirtualFile = UtilKt.toBackedNotebookFile(virtualFile);
        NotebookStructurePerFileTracker notebookStructureTracker = NotebookStructureTrackerService.Companion.getForFile(project, backedNotebookVirtualFile);
        Map<Integer, Set<String>> ordinalMap = notebookStructureTracker.getCellOrdinalToCompiledClassNames();
        InjectedLanguageManager injectionManager = InjectedLanguageManager.getInstance((Project)project);
        PsiLanguageInjectionHost targetHost = injectionManager.getInjectionHost((PsiElement)target.getContainingFile());
        boolean condition$iv = searchStrategy == ReferenceSearchStrategy.REFERENCES && targetHost != null;
        boolean $i$f$runIf = false;
        if (condition$iv) {
            boolean bl = false;
            PsiLanguageInjectionHost psiLanguageInjectionHost = targetHost;
            Intrinsics.checkNotNull((Object)psiLanguageInjectionHost);
            Set<String> name = ordinalMap.get(CollectionsKt.indexOf((List)notebookCells, (Object)psiLanguageInjectionHost));
            if (targetHost.getUserData(NotebookStructurePerFileTracker.Companion.getCELL_CLASS_NAME()) == null && name != null) {
                targetHost.putUserData(NotebookStructurePerFileTracker.Companion.getCELL_CLASS_NAME(), name);
            }
            v2 = name;
        } else {
            v2 = targetClassName = null;
        }
        if (target.getParent() == null) {
            return null;
        }
        PsiFile targetContainingFile = target.getContainingFile();
        Ref.BooleanRef isLocalSearch = new Ref.BooleanRef();
        if (searchStrategy == ReferenceSearchStrategy.REFERENCES) {
            PsiLanguageInjectionHost psiLanguageInjectionHost = targetHost;
            v4 = (psiLanguageInjectionHost != null ? (Set)psiLanguageInjectionHost.getUserData(NotebookStructurePerFileTracker.Companion.getCELL_CLASS_NAME()) : null) == null && !FindUsagesHandlerKt.isCompiledCellClassDeclaration(target);
        } else {
            v4 = isLocalSearch.element = false;
        }
        if (!isLocalSearch.element) {
            String string = targetContainingFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)".kotlinx.dataframe.", (boolean)false, (int)2, null)) {
                isLocalSearch.element = PsiRefHelpersKt.isItGeneratedNameInsideLambdaCall(target, target);
            }
        }
        List scopeContainers = isLocalSearch.element ? CollectionsKt.listOf((Object)injectionManager.getInjectionHost((PsiElement)targetContainingFile)) : notebookCells;
        return (Set)ActionsKt.runReadAction(() -> PsiAwareKt.searchForElementDeclarationOrUsages$lambda$2(scopeContainers, isLocalSearch, notebookCells, injectedManager, target, targetContainingFile, searchStrategy, ordinalMap, injectionManager, targetClassName, foundData));
    }

    private static final Set searchForElementDeclarationOrUsages$lambda$2(List $scopeContainers, Ref.BooleanRef $isLocalSearch, List $notebookCells, InjectedLanguageManager $injectedManager, PsiElement $target, PsiFile $targetContainingFile, ReferenceSearchStrategy $searchStrategy, Map $ordinalMap, InjectedLanguageManager $injectionManager, Set $targetClassName, Set $foundData) {
        int n = ((Collection)$scopeContainers).size();
        for (int ind = 0; ind < n; ++ind) {
            PsiElement psiFile;
            PsiLanguageInjectionHost gotHost;
            PsiLanguageInjectionHost host2;
            List list;
            if ((PsiLanguageInjectionHost)$scopeContainers.get(ind) == null || (list = $injectedManager.getInjectedPsiFiles((PsiElement)(host2 = $isLocalSearch.element ? gotHost : (PsiLanguageInjectionHost)$notebookCells.get(ind)))) == null || (list = (Pair)CollectionsKt.firstOrNull((List)list)) == null) continue;
            List firstInjectedFileInfo = list;
            if ((PsiElement)((Pair)firstInjectedFileInfo).first == null) continue;
            if ($target.getParent() == null) break;
            if (!(psiFile instanceof KtFile) || Intrinsics.areEqual((Object)psiFile, (Object)$targetContainingFile) && $searchStrategy == ReferenceSearchStrategy.DECLARATION) continue;
            Object[] objectArray = ((KtFile)psiFile).findChildrenByClass(KtScript.class);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"findChildrenByClass(...)");
            KtScript ktScript = (KtScript)ArraysKt.firstOrNull((Object[])objectArray);
            if (ktScript == null || (ktScript = ktScript.getBlockExpression()) == null) continue;
            KtScript scriptBlock = ktScript;
            List elements = new ArrayList();
            Set set = (Set)$ordinalMap.get(ind);
            if (set == null) {
                set = SetsKt.emptySet();
            }
            Set possibleClassName = set;
            Intrinsics.checkNotNull((Object)$injectionManager);
            Set set2 = $targetClassName;
            if (set2 == null) {
                set2 = possibleClassName;
            }
            NotebookReferenceFinder.INSTANCE.traverseChildrenAndSearch($injectionManager, host2, set2, (PsiElement)scriptBlock, $target, $searchStrategy, elements);
            if ($searchStrategy == ReferenceSearchStrategy.DECLARATION) {
                NavigatablePsiElement first = (NavigatablePsiElement)CollectionsKt.firstOrNull((List)elements);
                if (first == null) continue;
                $foundData.add(first);
                break;
            }
            CollectionsKt.addAll((Collection)$foundData, (Iterable)elements);
        }
        return $foundData;
    }
}

