/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.ws;

import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.java_websocket.WebSocket;
import org.java_websocket.client.WebSocketClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.protocol.JupyterCallbackBasedSocket;
import org.jetbrains.kotlinx.jupyter.protocol.api.JupyterSocketType;
import org.jetbrains.kotlinx.jupyter.protocol.api.KernelLoggerFactory;
import org.jetbrains.kotlinx.jupyter.protocol.api.KernelLoggerFactoryKt;
import org.jetbrains.kotlinx.jupyter.protocol.api.RawMessage;
import org.jetbrains.kotlinx.jupyter.protocol.exceptions.ExceptionMerger;
import org.jetbrains.kotlinx.jupyter.protocol.messaging.JupyterClientSockets;
import org.jetbrains.kotlinx.jupyter.ws.WsCallbackBasedSocketImmediate;
import org.jetbrains.kotlinx.jupyter.ws.WsMessageHandler;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0016\u0010\b\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u000bj\u0002`\f0\n0\t\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J\b\u0010#\u001a\u00020$H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR\u0014\u0010\u001f\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001cR\u0014\u0010!\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001c\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlinx/jupyter/ws/WsClientSockets;", "Lorg/jetbrains/kotlinx/jupyter/protocol/messaging/JupyterClientSockets;", "loggerFactory", "Lorg/jetbrains/kotlinx/jupyter/protocol/api/KernelLoggerFactory;", "createWsClient", "Lkotlin/Function1;", "Lorg/jetbrains/kotlinx/jupyter/ws/WsMessageHandler;", "Lorg/java_websocket/client/WebSocketClient;", "checkErrors", "Lkotlin/Function0;", "", "Ljava/lang/Exception;", "Lkotlin/Exception;", "<init>", "(Lorg/jetbrains/kotlinx/jupyter/protocol/api/KernelLoggerFactory;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "logger", "Lorg/slf4j/Logger;", "socketsMap", "Ljava/util/EnumMap;", "Lorg/jetbrains/kotlinx/jupyter/protocol/api/JupyterSocketType;", "Lorg/jetbrains/kotlinx/jupyter/ws/WsCallbackBasedSocketImmediate;", "fromSocketType", "type", "wsClient", "createCallbackBasedSocketWrapper", "Lorg/jetbrains/kotlinx/jupyter/protocol/JupyterCallbackBasedSocket;", "shell", "getShell", "()Lorg/jetbrains/kotlinx/jupyter/protocol/JupyterCallbackBasedSocket;", "control", "getControl", "ioPub", "getIoPub", "stdin", "getStdin", "close", "", "ws-server"})
@SourceDebugExtension(value={"SMAP\nJupyterWsClientSocketManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterWsClientSocketManager.kt\norg/jetbrains/kotlinx/jupyter/ws/WsClientSockets\n+ 2 Util.kt\norg/jetbrains/kotlinx/jupyter/protocol/exceptions/UtilKt\n+ 3 Util.kt\norg/jetbrains/kotlinx/jupyter/protocol/exceptions/ExceptionMerger\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,126:1\n18#2:127\n10#2,4:128\n19#2,2:144\n14#2,3:146\n21#2:150\n30#3,6:132\n30#3,6:138\n1#4:149\n*S KotlinDebug\n*F\n+ 1 JupyterWsClientSocketManager.kt\norg/jetbrains/kotlinx/jupyter/ws/WsClientSockets\n*L\n107#1:127\n107#1:128,4\n107#1:144,2\n107#1:146,3\n107#1:150\n109#1:132,6\n111#1:138,6\n107#1:149\n*E\n"})
final class WsClientSockets
implements JupyterClientSockets {
    @NotNull
    private final KernelLoggerFactory loggerFactory;
    @NotNull
    private final Logger logger;
    @NotNull
    private final EnumMap<JupyterSocketType, WsCallbackBasedSocketImmediate> socketsMap;
    @NotNull
    private final WebSocketClient wsClient;
    @NotNull
    private final JupyterCallbackBasedSocket shell;
    @NotNull
    private final JupyterCallbackBasedSocket control;
    @NotNull
    private final JupyterCallbackBasedSocket ioPub;
    @NotNull
    private final JupyterCallbackBasedSocket stdin;

    public WsClientSockets(@NotNull KernelLoggerFactory loggerFactory, @NotNull Function1<? super WsMessageHandler, ? extends WebSocketClient> createWsClient, @NotNull Function0<? extends List<? extends Exception>> checkErrors) {
        Intrinsics.checkNotNullParameter((Object)loggerFactory, (String)"loggerFactory");
        Intrinsics.checkNotNullParameter(createWsClient, (String)"createWsClient");
        Intrinsics.checkNotNullParameter(checkErrors, (String)"checkErrors");
        this.loggerFactory = loggerFactory;
        this.logger = KernelLoggerFactoryKt.getLogger((KernelLoggerFactory)this.loggerFactory, (KClass)Reflection.getOrCreateKotlinClass(this.getClass()));
        this.socketsMap = new EnumMap(JupyterSocketType.class);
        this.wsClient = (WebSocketClient)createWsClient.invoke((Object)new WsMessageHandler(this.logger, (Function2<? super JupyterSocketType, ? super RawMessage, Unit>)((Function2)(arg_0, arg_1) -> WsClientSockets.wsClient$lambda$0(this, arg_0, arg_1))));
        this.shell = this.createCallbackBasedSocketWrapper(JupyterSocketType.SHELL);
        this.control = this.createCallbackBasedSocketWrapper(JupyterSocketType.CONTROL);
        this.ioPub = this.createCallbackBasedSocketWrapper(JupyterSocketType.IOPUB);
        this.stdin = this.createCallbackBasedSocketWrapper(JupyterSocketType.STDIN);
        this.wsClient.connectBlocking();
        List errors = (List)checkErrors.invoke();
        if (!((Collection)errors).isEmpty()) {
            Exception thrownError = (Exception)CollectionsKt.first((List)errors);
            for (Exception error : CollectionsKt.drop((Iterable)errors, (int)1)) {
                ExceptionsKt.addSuppressed((Throwable)thrownError, (Throwable)error);
            }
            throw thrownError;
        }
    }

    private final WsCallbackBasedSocketImmediate fromSocketType(JupyterSocketType type2) {
        WsCallbackBasedSocketImmediate wsCallbackBasedSocketImmediate = this.socketsMap.get(type2);
        if (wsCallbackBasedSocketImmediate == null) {
            throw new RuntimeException("Unknown socket type: " + type2);
        }
        return wsCallbackBasedSocketImmediate;
    }

    private final JupyterCallbackBasedSocket createCallbackBasedSocketWrapper(JupyterSocketType type2) {
        WsCallbackBasedSocketImmediate wsCallbackBasedSocketImmediate;
        WsCallbackBasedSocketImmediate it = wsCallbackBasedSocketImmediate = new WsCallbackBasedSocketImmediate(this.loggerFactory, (Function0<? extends Iterable<? extends WebSocket>>)((Function0)() -> WsClientSockets.createCallbackBasedSocketWrapper$lambda$0(this)), type2);
        boolean bl = false;
        ((Map)this.socketsMap).put(type2, it);
        return wsCallbackBasedSocketImmediate;
    }

    @NotNull
    public JupyterCallbackBasedSocket getShell() {
        return this.shell;
    }

    @NotNull
    public JupyterCallbackBasedSocket getControl() {
        return this.control;
    }

    @NotNull
    public JupyterCallbackBasedSocket getIoPub() {
        return this.ioPub;
    }

    @NotNull
    public JupyterCallbackBasedSocket getStdin() {
        return this.stdin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        boolean $i$f$mergeExceptions = false;
        ExceptionMerger exceptionMerger$iv = new ExceptionMerger();
        Throwable throwable$iv = null;
        try {
            ExceptionMerger $this$close_u24lambda_u240 = exceptionMerger$iv;
            boolean bl = false;
            for (WsCallbackBasedSocketImmediate socket : this.socketsMap.values()) {
                ExceptionMerger this_$iv = $this$close_u24lambda_u240;
                boolean $i$f$catchIndependently = false;
                try {
                    boolean bl2 = false;
                    socket.close();
                }
                catch (Throwable e$iv) {
                    this_$iv.addError(e$iv);
                }
            }
            ExceptionMerger this_$iv = $this$close_u24lambda_u240;
            boolean $i$f$catchIndependently = false;
            try {
                boolean bl3 = false;
                this.wsClient.closeBlocking();
            }
            catch (Throwable e$iv) {
                this_$iv.addError(e$iv);
            }
        }
        catch (Throwable e$iv) {
            try {
                throwable$iv = e$iv;
                throw e$iv;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable$iv;
                if (throwable2 != null) {
                    Throwable it$iv = throwable2;
                    boolean bl = false;
                    exceptionMerger$iv.addError(it$iv);
                }
                exceptionMerger$iv.finalize();
                throw throwable;
            }
        }
        exceptionMerger$iv.finalize();
    }

    private static final Unit wsClient$lambda$0(WsClientSockets this$0, JupyterSocketType type2, RawMessage message) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this$0.fromSocketType(type2).messageReceived(message);
        return Unit.INSTANCE;
    }

    private static final Iterable createCallbackBasedSocketWrapper$lambda$0(WsClientSockets this$0) {
        return CollectionsKt.listOf((Object)this$0.wsClient);
    }
}

