/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.compressed;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.api.CompressedDumpsAware;
import com.intellij.profiler.api.ProfilerDumpFileParser;
import com.intellij.profiler.api.ProfilerDumpFileParsingResult;
import com.intellij.profiler.api.ProfilerDumpParserProvider;
import com.intellij.profiler.compressed.CompressedDumpDescriptor;
import com.intellij.profiler.compressed.CompressedDumpParsePolicy;
import java.io.File;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000f\u001a\u00020\u0010X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\u0010X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u0010X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lcom/intellij/profiler/compressed/CompressedDumpFileParserProviderWrapper;", "Lcom/intellij/profiler/api/ProfilerDumpParserProvider;", "underlyingProvider", "descriptor", "Lcom/intellij/profiler/compressed/CompressedDumpDescriptor;", "<init>", "(Lcom/intellij/profiler/api/ProfilerDumpParserProvider;Lcom/intellij/profiler/compressed/CompressedDumpDescriptor;)V", "getUnderlyingProvider", "()Lcom/intellij/profiler/api/ProfilerDumpParserProvider;", "getDescriptor", "()Lcom/intellij/profiler/compressed/CompressedDumpDescriptor;", "createParser", "Lcom/intellij/profiler/api/ProfilerDumpFileParser;", "project", "Lcom/intellij/openapi/project/Project;", "id", "", "getId", "()Ljava/lang/String;", "name", "getName", "requiredFileExtension", "getRequiredFileExtension", "intellij.profiler.common"})
public final class CompressedDumpFileParserProviderWrapper
implements ProfilerDumpParserProvider {
    @NotNull
    private final ProfilerDumpParserProvider underlyingProvider;
    @NotNull
    private final CompressedDumpDescriptor descriptor;

    public CompressedDumpFileParserProviderWrapper(@NotNull ProfilerDumpParserProvider underlyingProvider, @NotNull CompressedDumpDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)underlyingProvider, (String)"underlyingProvider");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.underlyingProvider = underlyingProvider;
        this.descriptor = descriptor;
    }

    @NotNull
    public final ProfilerDumpParserProvider getUnderlyingProvider() {
        return this.underlyingProvider;
    }

    @NotNull
    public final CompressedDumpDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    @NotNull
    public ProfilerDumpFileParser createParser(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProfilerDumpFileParser normalParser = this.underlyingProvider.createParser(project);
        return new ProfilerDumpFileParser(this, normalParser, project){
            final /* synthetic */ CompressedDumpFileParserProviderWrapper this$0;
            final /* synthetic */ ProfilerDumpFileParser $normalParser;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$normalParser = $normalParser;
                this.$project = $project;
            }

            public ProfilerDumpFileParsingResult parse(File file, ProgressIndicator indicator) {
                CompressedDumpParsePolicy policy;
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                ProfilerDumpParserProvider profilerDumpParserProvider = this.this$0.getUnderlyingProvider();
                CompressedDumpsAware compressedDumpsAware = profilerDumpParserProvider instanceof CompressedDumpsAware ? (CompressedDumpsAware)profilerDumpParserProvider : null;
                CompressedDumpParsePolicy compressedDumpParsePolicy = policy = compressedDumpsAware != null ? compressedDumpsAware.getParsePolicy() : null;
                if (policy == null) {
                    return this.$normalParser.parse(file, indicator);
                }
                InputStream inputStream = this.this$0.getDescriptor().createUnderlyingSingleFileInputStream();
                if (inputStream == null) {
                    throw new IllegalStateException("Unexpected layout of a compressed file");
                }
                InputStream inputStream2 = inputStream;
                String string = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                return policy.parse(this.$project, string, inputStream2, indicator);
            }

            public String getHelpId() {
                return this.$normalParser.getHelpId();
            }
        };
    }

    @Override
    @NotNull
    public String getId() {
        return this.underlyingProvider.getId();
    }

    @Override
    @NotNull
    public String getName() {
        return this.underlyingProvider.getName();
    }

    @Override
    @Nullable
    public String getRequiredFileExtension() {
        return this.underlyingProvider.getRequiredFileExtension();
    }
}

