/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution;

import com.intellij.httpClient.converters.RequestBuilder;
import com.intellij.httpClient.execution.HttpRequestConfig;
import com.intellij.httpClient.execution.RestClientFormBodyPart;
import com.intellij.httpClient.execution.auth.HttpClientAuthData;
import com.intellij.httpClient.execution.common.CommonClientRequest;
import com.intellij.httpClient.execution.ssl.SslConfiguration;
import com.intellij.httpClient.http.request.converter.utils.HttpRequestQueryPresentationUtilsKt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Transient;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kotlin.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RestClientRequest
implements CommonClientRequest {
    public List<Biscuit> biscuits = new ArrayList<Biscuit>();
    public String httpMethod;
    public String urlBase;
    public String urlPath;
    public List<KeyValuePair> headers = new ArrayList<KeyValuePair>();
    public List<KeyValuePair> parameters = new ArrayList<KeyValuePair>();
    public boolean parametersEnabled;
    public boolean haveTextToSend;
    public boolean haveFileToSend;
    public boolean isFileUpload;
    public String textToSend;
    public String filesToSend;
    @Transient
    public List<RestClientFormBodyPart> formBodyPart = new ArrayList<RestClientFormBodyPart>();
    @Transient
    public String multipartBoundary = null;
    @Transient
    public HttpClientAuthData authData = null;
    @Transient
    @NotNull
    public HttpRequestConfig config = new HttpRequestConfig(true, true, true);
    @Transient
    @Nullable
    public SslConfiguration sslConfiguration = null;
    @Transient
    @Nullable
    public RequestBuilder.HttpProtocol protocol = null;
    @Nullable
    public CommonClientRequest.OutputFilePath outputFilePath;
    private List<KeyValuePair> myActualHeaders = List.of();

    @Override
    @Transient
    @Nullable
    public String getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    @Transient
    @Nullable
    public String getTextToSend() {
        return this.textToSend;
    }

    @Override
    @Transient
    @Nullable
    public CommonClientRequest.OutputFilePath getOutputFilePath() {
        return this.outputFilePath;
    }

    @Override
    @Transient
    public boolean isLogResponse() {
        return this.config.isLogResponse();
    }

    public String getHeaderValue(String name, String defaultValue) {
        for (KeyValuePair header : this.headers) {
            if (!name.equalsIgnoreCase(header.getKey())) continue;
            return header.getValue();
        }
        return defaultValue;
    }

    @Nullable
    public List<String> getHeadersValue(@NotNull String name) {
        if (name == null) {
            RestClientRequest.$$$reportNull$$$0(0);
        }
        ArrayList<String> list2 = new ArrayList<String>();
        for (KeyValuePair header : this.headers) {
            if (!name.equalsIgnoreCase(header.getKey())) continue;
            list2.add(header.getValue());
        }
        return list2.isEmpty() ? null : list2;
    }

    public void deleteHeader(@NotNull String name) {
        if (name == null) {
            RestClientRequest.$$$reportNull$$$0(1);
        }
        this.headers.removeIf(header -> name.equalsIgnoreCase(header.getKey()));
    }

    public List<File> getFiles() {
        ArrayList<File> files = new ArrayList<File>();
        for (String path : StringUtil.split((String)this.filesToSend, (String)File.pathSeparator)) {
            files.add(new File(path));
        }
        return files;
    }

    @Override
    @NotNull
    public String getURL() {
        Object base = this.urlBase;
        if (!((String)base).endsWith("/") && !this.urlPath.isEmpty()) {
            base = (String)base + "/";
        }
        Object object = base = this.urlPath.startsWith("/") ? (String)base + this.urlPath.substring(1) : (String)base + this.urlPath;
        if (this.config.isEncodingEnabled()) {
            String string = ((String)base).replace(" ", "%20");
            if (string == null) {
                RestClientRequest.$$$reportNull$$$0(2);
            }
            return string;
        }
        Object object2 = base;
        if (object2 == null) {
            RestClientRequest.$$$reportNull$$$0(3);
        }
        return object2;
    }

    public String createQueryString() {
        List queryParams = ContainerUtil.map(this.parameters, keyValue -> new Pair((Object)keyValue.getKey(), (Object)keyValue.getValue()));
        String encodedQueryString = HttpRequestQueryPresentationUtilsKt.getEncodedQueryString(queryParams, this.config.isEncodingEnabled());
        return StringUtil.isEmpty((String)encodedQueryString) ? "" : encodedQueryString.substring(1);
    }

    public void addBiscuit(@NotNull Biscuit biscuit) {
        if (biscuit == null) {
            RestClientRequest.$$$reportNull$$$0(4);
        }
        this.biscuits.add(biscuit);
    }

    public boolean isEmptyCredentials() {
        return this.authData == HttpClientAuthData.EMPTY_CREDENTIALS;
    }

    public void setEmptyCredentials() {
        this.authData = HttpClientAuthData.EMPTY_CREDENTIALS;
    }

    @Transient
    @ApiStatus.Internal
    @NotNull
    public List<KeyValuePair> getActualSentHeaders() {
        List<KeyValuePair> list2 = this.myActualHeaders;
        if (list2 == null) {
            RestClientRequest.$$$reportNull$$$0(5);
        }
        return list2;
    }

    public void setActualSentHeaders(@NotNull List<KeyValuePair> actualHeaders) {
        if (actualHeaders == null) {
            RestClientRequest.$$$reportNull$$$0(6);
        }
        this.myActualHeaders = List.copyOf(actualHeaders);
    }

    public String toString() {
        String url = this.getURL();
        String queryString = this.createQueryString();
        if (!queryString.isEmpty()) {
            return url + (url.contains("?") ? "&" : "?") + queryString;
        }
        return url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestClientRequest request = (RestClientRequest)o;
        if (this.haveFileToSend != request.haveFileToSend) {
            return false;
        }
        if (this.haveTextToSend != request.haveTextToSend) {
            return false;
        }
        if (this.isFileUpload != request.isFileUpload) {
            return false;
        }
        if (this.parametersEnabled != request.parametersEnabled) {
            return false;
        }
        if (!this.config.equals(request.config)) {
            return false;
        }
        if (!Objects.equals(this.filesToSend, request.filesToSend)) {
            return false;
        }
        if (!Objects.equals(this.headers, request.headers)) {
            return false;
        }
        if (!Objects.equals(this.httpMethod, request.httpMethod)) {
            return false;
        }
        if (!Objects.equals(this.parameters, request.parameters)) {
            return false;
        }
        if (!Objects.equals(this.textToSend, request.textToSend)) {
            return false;
        }
        if (!Objects.equals(this.urlBase, request.urlBase)) {
            return false;
        }
        if (!Objects.equals(this.urlPath, request.urlPath)) {
            return false;
        }
        if (!Objects.equals(this.biscuits, request.biscuits)) {
            return false;
        }
        if (!Objects.equals(this.formBodyPart, request.formBodyPart)) {
            return false;
        }
        if (!Objects.equals(this.multipartBoundary, request.multipartBoundary)) {
            return false;
        }
        return Objects.equals(this.authData, request.authData);
    }

    public int hashCode() {
        int result2 = Objects.hashCode(this.httpMethod);
        result2 = 31 * result2 + Objects.hashCode(this.urlBase);
        result2 = 31 * result2 + Objects.hashCode(this.urlPath);
        result2 = 31 * result2 + Objects.hashCode(this.headers);
        result2 = 31 * result2 + Objects.hashCode(this.parameters);
        result2 = 31 * result2 + Objects.hashCode(this.config);
        result2 = 31 * result2 + (this.parametersEnabled ? 1 : 0);
        result2 = 31 * result2 + (this.haveTextToSend ? 1 : 0);
        result2 = 31 * result2 + (this.haveFileToSend ? 1 : 0);
        result2 = 31 * result2 + (this.isFileUpload ? 1 : 0);
        result2 = 31 * result2 + Objects.hashCode(this.textToSend);
        result2 = 31 * result2 + Objects.hashCode(this.filesToSend);
        result2 = 31 * result2 + Objects.hashCode(this.formBodyPart);
        result2 = 31 * result2 + Objects.hashCode(this.multipartBoundary);
        result2 = 31 * result2 + Objects.hashCode(this.authData);
        result2 = 31 * result2 + Objects.hashCode(this.biscuits);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/execution/RestClientRequest";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "biscuit";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualHeaders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/execution/RestClientRequest";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getURL";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualSentHeaders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getHeadersValue";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "deleteHeader";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addBiscuit";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setActualSentHeaders";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5 -> new IllegalStateException(string);
        };
    }

    public static final class KeyValuePair {
        private String myKey;
        private String myValue;

        public KeyValuePair() {
        }

        public KeyValuePair(String key, String value2) {
            this.myKey = key;
            this.myValue = value2;
        }

        public String getKey() {
            return this.myKey;
        }

        public void setKey(String key) {
            this.myKey = key;
        }

        public String getValue() {
            return this.myValue;
        }

        public void setValue(String value2) {
            this.myValue = value2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyValuePair pair = (KeyValuePair)o;
            if (!this.myKey.equals(pair.myKey)) {
                return false;
            }
            return this.myValue.equals(pair.myValue);
        }

        public int hashCode() {
            int result2 = this.myKey.hashCode();
            result2 = 31 * result2 + this.myValue.hashCode();
            return result2;
        }
    }

    public static final class Biscuit {
        private String myName;
        private String myValue;
        private String myDomain;
        private String myPath;
        private String myTimeZone;
        private long myDate;

        public Biscuit() {
        }

        public Biscuit(String name, String value2, String domain, String path, long date) {
            this.myName = name;
            this.myValue = value2;
            this.myDomain = domain;
            this.myPath = path;
            this.myDate = date;
        }

        public String getName() {
            return this.myName;
        }

        public void setName(String name) {
            this.myName = name;
        }

        public String getValue() {
            return this.myValue;
        }

        public void setValue(String value2) {
            this.myValue = value2;
        }

        public String getDomain() {
            return this.myDomain;
        }

        public void setDomain(String domain) {
            this.myDomain = domain;
        }

        public String getPath() {
            return this.myPath;
        }

        public void setPath(String path) {
            this.myPath = path;
        }

        public long getDate() {
            return this.myDate;
        }

        public void setDate(long date) {
            this.myDate = date;
        }

        public String getTimeZone() {
            return this.myTimeZone;
        }

        public void setTimeZone(String timeZone) {
            this.myTimeZone = timeZone;
        }

        public boolean isExpired(@NotNull Date currentTime) {
            if (currentTime == null) {
                Biscuit.$$$reportNull$$$0(0);
            }
            if (this.myDate == -1L) {
                return false;
            }
            Date expirationDate = new Date(this.myDate);
            return expirationDate.before(currentTime);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Biscuit biscuit = (Biscuit)o;
            if (this.myDate != biscuit.myDate) {
                return false;
            }
            if (!Objects.equals(this.myDomain, biscuit.myDomain)) {
                return false;
            }
            if (!this.myName.equals(biscuit.myName)) {
                return false;
            }
            if (!Objects.equals(this.myPath, biscuit.myPath)) {
                return false;
            }
            return this.myValue.equals(biscuit.myValue);
        }

        public int hashCode() {
            int result2 = this.myName.hashCode();
            result2 = 31 * result2 + this.myValue.hashCode();
            result2 = 31 * result2 + (this.myDomain != null ? this.myDomain.hashCode() : 0);
            result2 = 31 * result2 + (this.myPath != null ? this.myPath.hashCode() : 0);
            result2 = 31 * result2 + Long.hashCode(this.myDate);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentTime", "com/intellij/httpClient/execution/RestClientRequest$Biscuit", "isExpired"));
        }
    }
}

