/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.rml.ast;

import com.intellij.rml.dfa.impl.relations.IRelationsManager;
import com.intellij.rml.dfa.impl.rml.DomainsPool;
import com.intellij.rml.dfa.impl.rml.PrettyPrintable;
import com.intellij.rml.dfa.impl.rml.ast.Context;
import com.intellij.rml.dfa.impl.rml.ast.Stmt;
import com.intellij.rml.dfa.impl.rml.ast.StmtTransformer;
import com.intellij.rml.dfa.impl.rml.ast.StmtVisitor;
import com.intellij.rml.dfa.impl.rml.profiler.ProfilePoint;
import com.intellij.rml.dfa.impl.rml.profiler.RmlProfileManager;
import com.intellij.rml.dfa.impl.rml.profiler.RmlProfileManagerKt;
import com.intellij.rml.dfa.impl.scripts.RuntimeVariablesManager;
import com.intellij.rml.dfa.impl.symtable.SymbolTable;
import com.intellij.rml.dfa.impl.ui.UIInstancesProvider;
import com.intellij.rml.dfa.utils.Cancellation;
import java.util.List;
import java.util.stream.Collectors;

public class StmtList
extends Stmt
implements PrettyPrintable {
    private final List<Stmt> stmts;
    private final String name;

    public StmtList(List<Stmt> list, Context context) {
        this(list, context, "[]");
    }

    public StmtList(List<Stmt> list, Context context, String name) {
        super(context, list.toArray(new Stmt[0]));
        this.stmts = list;
        this.name = name;
    }

    @Override
    public void accept(StmtVisitor visitor2) {
        for (Stmt stmt : this.stmts) {
            stmt.accept(visitor2);
        }
    }

    @Override
    public Stmt transform(StmtTransformer transformer) {
        this.stmts.replaceAll(stmt -> stmt.transform(transformer));
        return transformer.transformList(this);
    }

    @Override
    public void interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, Cancellation cancellation, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, RmlProfileManager profileManager2) {
        ProfilePoint start = RmlProfileManagerKt.getProfilePoint(profileManager2, relationsManager);
        for (Stmt stmt : this.stmts) {
            cancellation.checkCancelled();
            stmt.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable, profileManager2);
        }
        if (profileManager2 != null) {
            profileManager2.addDuration(this, start, RmlProfileManagerKt.getProfilePoint(profileManager2, relationsManager));
        }
    }

    @Override
    public String toLongString() {
        String statements = this.stmts.stream().map(PrettyPrintable::toLongString).collect(Collectors.joining("\n", "\n", "\n"));
        return "StmtList{" + statements + "}";
    }

    @Override
    public String toShortString() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.toShortString();
    }
}

