/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.messages.Topic;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LanguageLevelProjectExtension {
    public static final Topic<LanguageLevelChangeListener> LANGUAGE_LEVEL_CHANGED_TOPIC = Topic.create((String)"Java language level", LanguageLevelChangeListener.class);

    public static LanguageLevelProjectExtension getInstance(Project project) {
        return (LanguageLevelProjectExtension)project.getService(LanguageLevelProjectExtension.class);
    }

    @NotNull
    public abstract LanguageLevel getLanguageLevel();

    @RequiresWriteLock
    public abstract void setLanguageLevel(@NotNull LanguageLevel var1);

    @Nullable
    public abstract Boolean getDefault();

    @RequiresWriteLock
    public abstract void setDefault(@Nullable Boolean var1);

    public boolean isDefault() {
        Boolean currentValue = this.getDefault();
        return currentValue != null && currentValue != false;
    }

    public void languageLevelsChanged() {
    }

    public static interface LanguageLevelChangeListener {
        public void onLanguageLevelsChanged();
    }
}

