/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class PsiCatchSectionImpl
extends CompositePsiElement
implements PsiCatchSection,
Constants {
    private static final Logger LOG = Logger.getInstance(PsiCatchSectionImpl.class);
    private final Object myTypesCacheLock = new Object();

    public PsiCatchSectionImpl() {
        super(CATCH_SECTION);
    }

    @Override
    public PsiParameter getParameter() {
        return (PsiParameter)this.findChildByRoleAsPsiElement(15);
    }

    @Override
    public PsiCodeBlock getCatchBlock() {
        return (PsiCodeBlock)this.findChildByRoleAsPsiElement(49);
    }

    @Override
    public PsiType getCatchType() {
        PsiParameter parameter = this.getParameter();
        if (parameter == null) {
            return null;
        }
        return parameter.getType();
    }

    @Override
    @NotNull
    public List<PsiType> getPreciseCatchTypes() {
        PsiParameter parameter = this.getParameter();
        if (parameter == null) {
            List<PsiType> list = Collections.emptyList();
            if (list == null) {
                PsiCatchSectionImpl.$$$reportNull$$$0(0);
            }
            return list;
        }
        List<PsiType> list = this.getTypesCache();
        if (list == null) {
            PsiCatchSectionImpl.$$$reportNull$$$0(1);
        }
        return list;
    }

    private List<PsiType> getTypesCache() {
        return (List)CachedValuesManager.getProjectPsiDependentCache((PsiElement)this, section -> this.computePreciseCatchTypes(section.getParameter()));
    }

    private @Unmodifiable List<PsiType> computePreciseCatchTypes(@Nullable PsiParameter parameter) {
        if (parameter == null) {
            return ContainerUtil.emptyList();
        }
        PsiType declaredType = parameter.getType();
        if (PsiUtil.isAvailable(JavaFeature.MULTI_CATCH, parameter) && PsiCatchSectionImpl.isCatchParameterEffectivelyFinal(parameter, this.getCatchBlock())) {
            PsiTryStatement statement = this.getTryStatement();
            Collection<PsiClassType> thrownTypes = PsiCatchSectionImpl.getThrownTypes(statement);
            if (thrownTypes.isEmpty()) {
                return Collections.emptyList();
            }
            Object[] parameters = statement.getCatchBlockParameters();
            int currentIdx = ArrayUtil.find((Object[])parameters, (Object)parameter);
            List uncaughtTypes = ContainerUtil.mapNotNull(thrownTypes, arg_0 -> PsiCatchSectionImpl.lambda$computePreciseCatchTypes$1(currentIdx, (PsiParameter[])parameters, arg_0));
            if (uncaughtTypes.isEmpty()) {
                return Collections.emptyList();
            }
            if (declaredType instanceof PsiDisjunctionType) {
                return Collections.unmodifiableList(((PsiDisjunctionType)declaredType).getDisjunctions().stream().flatMap(disjunction -> PsiCatchSectionImpl.computePreciseCatchTypes(disjunction, uncaughtTypes).stream()).collect(Collectors.toCollection(() -> new ArrayList())));
            }
            return PsiCatchSectionImpl.computePreciseCatchTypes(declaredType, uncaughtTypes);
        }
        return Collections.singletonList(declaredType);
    }

    private static List<PsiType> computePreciseCatchTypes(PsiType declaredType, List<PsiType> uncaughtTypes) {
        SmartList types = new SmartList();
        for (PsiType type : uncaughtTypes) {
            if (type.isAssignableFrom(declaredType)) {
                types.add(declaredType);
                continue;
            }
            if (!declaredType.isAssignableFrom(type) && (!ExceptionUtil.isGeneralExceptionType(declaredType) || !(type instanceof PsiClassType) || !ExceptionUtil.isUncheckedException((PsiClassType)type))) continue;
            types.add(type);
        }
        return types;
    }

    private static Collection<PsiClassType> getThrownTypes(@NotNull PsiTryStatement statement) {
        PsiResourceList resourceList;
        if (statement == null) {
            PsiCatchSectionImpl.$$$reportNull$$$0(2);
        }
        ArrayList<PsiClassType> types = new ArrayList<PsiClassType>();
        PsiCodeBlock tryBlock = statement.getTryBlock();
        if (tryBlock != null) {
            types.addAll(ExceptionUtil.getThrownExceptions(tryBlock));
        }
        if ((resourceList = statement.getResourceList()) != null) {
            types.addAll(ExceptionUtil.getThrownExceptions(resourceList));
        }
        return types;
    }

    private static boolean isCatchParameterEffectivelyFinal(final PsiParameter parameter, @Nullable PsiCodeBlock catchBlock) {
        final boolean[] result = new boolean[]{true};
        if (catchBlock != null) {
            catchBlock.accept(new JavaRecursiveElementWalkingVisitor(){

                @Override
                public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                    if (expression == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.visitReferenceExpression(expression);
                    if (expression.resolve() == parameter && PsiUtil.isAccessedForWriting(expression)) {
                        result[0] = false;
                        this.stopWalking();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/psi/impl/source/tree/java/PsiCatchSectionImpl$1", "visitReferenceExpression"));
                }
            });
        }
        return result[0];
    }

    @Override
    @NotNull
    public PsiTryStatement getTryStatement() {
        PsiTryStatement psiTryStatement = (PsiTryStatement)this.getParent();
        if (psiTryStatement == null) {
            PsiCatchSectionImpl.$$$reportNull$$$0(3);
        }
        return psiTryStatement;
    }

    @Override
    @Nullable
    public PsiJavaToken getLParenth() {
        return (PsiJavaToken)this.findChildByRole(50);
    }

    @Override
    @Nullable
    public PsiJavaToken getRParenth() {
        return (PsiJavaToken)this.findChildByRole(51);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiCatchSectionImpl.$$$reportNull$$$0(4);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitCatchSection(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiCatchSection";
    }

    public ASTNode findChildByRole(int role) {
        switch (role) {
            case 15: {
                return this.findChildByType(PARAMETER);
            }
            case 46: {
                return this.findChildByType(CATCH_KEYWORD);
            }
            case 50: {
                return this.findChildByType(LPARENTH);
            }
            case 51: {
                return this.findChildByType(RPARENTH);
            }
            case 49: {
                return this.findChildByType((IElementType)CODE_BLOCK);
            }
        }
        return null;
    }

    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiCatchSectionImpl.$$$reportNull$$$0(5);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == PARAMETER) {
            return 15;
        }
        if (i == CODE_BLOCK) {
            return 49;
        }
        if (i == CATCH_KEYWORD) {
            return 46;
        }
        if (i == LPARENTH) {
            return 50;
        }
        if (i == RPARENTH) {
            return 51;
        }
        return 0;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            PsiCatchSectionImpl.$$$reportNull$$$0(6);
        }
        if (state == null) {
            PsiCatchSectionImpl.$$$reportNull$$$0(7);
        }
        if (place == null) {
            PsiCatchSectionImpl.$$$reportNull$$$0(8);
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        if (lastParent == null || lastParent.getParent() != this) {
            return true;
        }
        PsiParameter catchParameter = this.getParameter();
        if (catchParameter != null) {
            return processor.execute((PsiElement)catchParameter, state);
        }
        return PsiScopesUtil.walkChildrenScopes(this, processor, state, lastParent, place);
    }

    private static /* synthetic */ PsiType lambda$computePreciseCatchTypes$1(int currentIdx, PsiParameter[] parameters, PsiClassType thrownType) {
        for (int i = 0; i < currentIdx; ++i) {
            PsiType catchType = parameters[i].getType();
            if (!catchType.isAssignableFrom(thrownType)) continue;
            return null;
        }
        return thrownType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/java/PsiCatchSectionImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreciseCatchTypes";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/java/PsiCatchSectionImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTryStatement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getThrownTypes";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getChildRole";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

