/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.activity;

import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonCommonUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.execution.ParametersListUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u0015\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000b\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"hasNextJsDependency", "", "packageJson", "Lcom/intellij/json/psi/JsonFile;", "findDevScriptBodyPsi", "Lcom/intellij/json/psi/JsonStringLiteral;", "defaultPort", "", "getNextJsDevPort", "devScriptBody", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "intellij.javascript.debugger.backend"})
@SourceDebugExtension(value={"SMAP\nNextJsPackageJsonUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextJsPackageJsonUtil.kt\ncom/intellij/javascript/debugger/activity/NextJsPackageJsonUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,37:1\n360#2,7:38\n*S KotlinDebug\n*F\n+ 1 NextJsPackageJsonUtil.kt\ncom/intellij/javascript/debugger/activity/NextJsPackageJsonUtilKt\n*L\n26#1:38,7\n*E\n"})
public final class NextJsPackageJsonUtilKt {
    private static final int defaultPort = 3000;

    @RequiresReadLock
    public static final boolean hasNextJsDependency(@NotNull JsonFile packageJson) {
        Intrinsics.checkNotNullParameter((Object)packageJson, (String)"packageJson");
        return PackageJsonCommonUtil.findProdDependencyByName((JsonFile)packageJson, (String)"next") != null;
    }

    @RequiresReadLock
    @Nullable
    public static final JsonStringLiteral findDevScriptBodyPsi(@NotNull JsonFile packageJson) {
        Intrinsics.checkNotNullParameter((Object)packageJson, (String)"packageJson");
        JsonValue jsonValue = packageJson.getTopLevelValue();
        JsonObject jsonObject = jsonValue instanceof JsonObject ? (JsonObject)jsonValue : null;
        if (jsonObject == null) {
            return null;
        }
        JsonObject topLevelObject = jsonObject;
        JsonProperty jsonProperty = topLevelObject.findProperty("scripts");
        JsonValue jsonValue2 = jsonProperty != null ? jsonProperty.getValue() : null;
        JsonObject jsonObject2 = jsonValue2 instanceof JsonObject ? (JsonObject)jsonValue2 : null;
        if (jsonObject2 == null) {
            return null;
        }
        JsonObject scripts = jsonObject2;
        JsonProperty jsonProperty2 = scripts.findProperty("dev");
        jsonValue = jsonProperty2 != null ? jsonProperty2.getValue() : null;
        return jsonValue instanceof JsonStringLiteral ? (JsonStringLiteral)jsonValue : null;
    }

    @Nullable
    public static final Integer getNextJsDevPort(@NotNull String devScriptBody) {
        int indexOfNextDev;
        List params;
        block4: {
            int n;
            Intrinsics.checkNotNullParameter((Object)devScriptBody, (String)"devScriptBody");
            List list = ParametersListUtil.parse((String)devScriptBody);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parse(...)");
            params = list;
            List $this$indexOfFirst$iv = CollectionsKt.zipWithNext((Iterable)params);
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                Pair it = (Pair)item$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it, (Object)TuplesKt.to((Object)"next", (Object)"dev"))) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = indexOfNextDev = -1;
        }
        if (indexOfNextDev == -1) {
            return null;
        }
        int n = params.size() - 1;
        for (int i = indexOfNextDev + 2; i < n; ++i) {
            if (!Intrinsics.areEqual(params.get(i), (Object)"-p") && !Intrinsics.areEqual(params.get(i), (Object)"--port")) continue;
            int port = StringUtil.parseInt((String)((String)params.get(i + 1)), (int)-1);
            return port > 0 ? Integer.valueOf(port) : Integer.valueOf(3000);
        }
        return 3000;
    }
}

