/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.editors;

import com.intellij.diagram.util.DiagramSelectionService;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.impl.ImaginaryCaretModel;
import com.intellij.openapi.editor.impl.ImaginaryEditor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.PsiElement;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uml.editors.DiagramCaretForSelectedElement;
import com.intellij.uml.editors.DiagramTextEditorAdapter;
import com.intellij.uml.editors.DiagramTextEditorAdapterEmptyCaret;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.NamedColorUtil;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DiagramTextEditorAdapterCaretModel
extends ImaginaryCaretModel {
    @NotNull
    private final DiagramTextEditorAdapter myEditor;
    @NotNull
    private final DiagramTextEditorAdapterEmptyCaret myEmptyCaret;

    DiagramTextEditorAdapterCaretModel(@NotNull DiagramTextEditorAdapter editor) {
        if (editor == null) {
            DiagramTextEditorAdapterCaretModel.$$$reportNull$$$0(0);
        }
        super((ImaginaryEditor)editor);
        this.myEmptyCaret = new DiagramTextEditorAdapterEmptyCaret(this);
        this.myEditor = editor;
    }

    @NotNull
    protected DiagramTextEditorAdapter getEditor() {
        DiagramTextEditorAdapter diagramTextEditorAdapter = this.myEditor;
        if (diagramTextEditorAdapter == null) {
            DiagramTextEditorAdapterCaretModel.$$$reportNull$$$0(1);
        }
        return diagramTextEditorAdapter;
    }

    public TextAttributes getTextAttributes() {
        return new SimpleTextAttributes(0, NamedColorUtil.getListSelectionForeground((boolean)true)).toTextAttributes();
    }

    @NotNull
    public Caret getCurrentCaret() {
        Caret caret = this.myEditor.getLastActiveValue().or(() -> Optional.ofNullable(DiagramSelectionService.getInstance().getSingleSelectedNode(this.myEditor.getBuilder())).map(it -> it.getIdentifyingElement()).map(it -> (PsiElement)ObjectUtils.tryCast((Object)it, PsiElement.class))).map(it -> new DiagramCaretForSelectedElement(this, (PsiElement)it)).orElse((Caret)this.myEmptyCaret);
        if (caret == null) {
            DiagramTextEditorAdapterCaretModel.$$$reportNull$$$0(2);
        }
        return caret;
    }

    @NotNull
    public Caret getPrimaryCaret() {
        Caret caret = this.getCurrentCaret();
        if (caret == null) {
            DiagramTextEditorAdapterCaretModel.$$$reportNull$$$0(3);
        }
        return caret;
    }

    @NotNull
    public List<Caret> getAllCarets() {
        List<Caret> list = List.of(this.getCurrentCaret());
        if (list == null) {
            DiagramTextEditorAdapterCaretModel.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    public Caret getCaretAt(@NotNull VisualPosition pos) {
        if (pos == null) {
            DiagramTextEditorAdapterCaretModel.$$$reportNull$$$0(5);
        }
        return null;
    }

    @NotNull
    public List<CaretState> getCaretsAndSelections() {
        Caret caret = this.getCurrentCaret();
        List<CaretState> list = List.of(new CaretState(caret.getLogicalPosition(), this.getEditor().offsetToLogicalPosition(caret.getSelectionStart()), this.getEditor().offsetToLogicalPosition(caret.getSelectionEnd())));
        if (list == null) {
            DiagramTextEditorAdapterCaretModel.$$$reportNull$$$0(6);
        }
        return list;
    }

    public void addCaretListener(@NotNull CaretListener listener) {
        if (listener == null) {
            DiagramTextEditorAdapterCaretModel.$$$reportNull$$$0(7);
        }
    }

    public void removeCaretListener(@NotNull CaretListener listener) {
        if (listener == null) {
            DiagramTextEditorAdapterCaretModel.$$$reportNull$$$0(8);
        }
    }

    public void runForEachCaret(@NotNull CaretAction action) {
        if (action == null) {
            DiagramTextEditorAdapterCaretModel.$$$reportNull$$$0(9);
        }
        action.perform(this.getCurrentCaret());
    }

    public void runForEachCaret(@NotNull CaretAction action, boolean reverseOrder) {
        if (action == null) {
            DiagramTextEditorAdapterCaretModel.$$$reportNull$$$0(10);
        }
        action.perform(this.getCurrentCaret());
    }

    public void runBatchCaretOperation(@NotNull Runnable runnable) {
        if (runnable == null) {
            DiagramTextEditorAdapterCaretModel.$$$reportNull$$$0(11);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/editors/DiagramTextEditorAdapterCaretModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/editors/DiagramTextEditorAdapterCaretModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentCaret";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimaryCaret";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCarets";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaretsAndSelections";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCaretAt";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addCaretListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeCaretListener";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "runForEachCaret";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runBatchCaretOperation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 6 -> new IllegalStateException(string);
        };
    }
}

