/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.intellij.codeInsight.folding.JavaCodeFoldingSettings;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.base.codeInsight.handlers.fixers.FixersUtilKt;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi.stubs.elements.KtFunctionElementType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J.\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J&\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0014\u0010\u0017\u001a\u00020\u0012*\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0019H\u0014J\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\f\u0010\u001d\u001a\u00020\u0007*\u00020\u0007H\u0002J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0007H\u0002J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\"\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u000eH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/KotlinFoldingBuilder;", "Lcom/intellij/lang/folding/CustomFoldingBuilder;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "collectionFactoryFunctionsNames", "", "", "buildLanguageFoldRegions", "", "descriptors", "", "Lcom/intellij/lang/folding/FoldingDescriptor;", "root", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "quick", "", "appendDescriptors", "node", "Lcom/intellij/lang/ASTNode;", "needFolding", "shouldFoldCall", "getRangeToFold", "Lcom/intellij/openapi/util/TextRange;", "getLanguagePlaceholderText", "range", "getTrimmedFirstLineOfString", "addSpaceIfNeeded", "getFirstLineOfComment", "getCommentContents", "line", "isRegionCollapsedByDefault", "isCustomFoldingRoot", "isFirstElementInFile", "element", "intellij.kotlin.base.codeInsight.minimal"})
@SourceDebugExtension(value={"SMAP\nKotlinFoldingBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinFoldingBuilder.kt\norg/jetbrains/kotlin/idea/KotlinFoldingBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,230:1\n1#2:231\n183#3,2:232\n183#3,2:234\n183#3,2:238\n295#4,2:236\n*S KotlinDebug\n*F\n+ 1 KotlinFoldingBuilder.kt\norg/jetbrains/kotlin/idea/KotlinFoldingBuilder\n*L\n115#1:232,2\n174#1:234,2\n221#1:238,2\n184#1:236,2\n*E\n"})
public final class KotlinFoldingBuilder
extends CustomFoldingBuilder
implements DumbAware {
    @NotNull
    private final Set<String> collectionFactoryFunctionsNames;

    public KotlinFoldingBuilder() {
        Object[] objectArray = new String[]{"arrayOf", "booleanArrayOf", "byteArrayOf", "charArrayOf", "doubleArrayOf", "floatArrayOf", "intArrayOf", "longArrayOf", "shortArrayOf", "arrayListOf", "hashMapOf", "hashSetOf", "linkedMapOf", "linkedSetOf", "linkedStringMapOf", "linkedStringSetOf", "listOf", "listOfNotNull", "mapOf", "mutableListOf", "mutableMapOf", "mutableSetOf", "setOf", "sortedMapOf", "sortedSetOf", "stringMapOf", "stringSetOf"};
        this.collectionFactoryFunctionsNames = SetsKt.setOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (!(root instanceof PsiFile) || !Intrinsics.areEqual((Object)((PsiFile)root).getFileType(), (Object)KotlinFileType.INSTANCE)) {
            return;
        }
        KtImportList ktImportList = (KtImportList)PsiTreeUtil.findChildOfType((PsiElement)root, KtImportList.class);
        if (ktImportList == null) {
            return;
        }
        KtImportList importList = ktImportList;
        List list = importList.getImports();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getImports(...)");
        KtImportDirective firstImport = (KtImportDirective)CollectionsKt.firstOrNull((List)list);
        if (firstImport != null && importList.getImports().size() > 1) {
            void $this$buildLanguageFoldRegions_u24lambda_u240;
            FoldingDescriptor foldingDescriptor;
            PsiElement importKeyword = firstImport.getFirstChild();
            Intrinsics.checkNotNull((Object)importKeyword);
            int startOffset = PsiUtilsKt.getEndOffset((PsiElement)importKeyword) + 1;
            int endOffset = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)importList));
            FoldingDescriptor foldingDescriptor2 = foldingDescriptor = new FoldingDescriptor((PsiElement)importList, new TextRange(startOffset, endOffset));
            List<FoldingDescriptor> list2 = descriptors;
            boolean bl = false;
            $this$buildLanguageFoldRegions_u24lambda_u240.setCanBeRemovedWhenCollapsed(true);
            list2.add(foldingDescriptor);
        }
        FileASTNode fileASTNode = ((PsiFile)root).getNode();
        Intrinsics.checkNotNullExpressionValue((Object)fileASTNode, (String)"getNode(...)");
        this.appendDescriptors((ASTNode)fileASTNode, document, descriptors);
    }

    private final void appendDescriptors(ASTNode node, Document document, List<FoldingDescriptor> descriptors) {
        if (this.needFolding(node, document)) {
            TextRange textRange = this.getRangeToFold(node, document);
            TextRange textRange2 = textRange.shiftRight(-node.getTextRange().getStartOffset());
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"shiftRight(...)");
            TextRange relativeRange = textRange2;
            CharSequence foldRegionText = node.getChars().subSequence(relativeRange.getStartOffset(), relativeRange.getEndOffset());
            if (StringUtil.countNewLines((CharSequence)foldRegionText) > 0) {
                descriptors.add(new FoldingDescriptor(node, textRange));
            }
        }
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            this.appendDescriptors(child, document, descriptors);
        }
    }

    private final boolean needFolding(ASTNode node, Document document) {
        IElementType parentType;
        IElementType iElementType = node.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType type = iElementType;
        ASTNode aSTNode = node.getTreeParent();
        Object object = parentType = aSTNode != null ? aSTNode.getElementType() : null;
        if (type instanceof KtFunctionElementType) {
            KtExpression bodyExpression;
            PsiElement psiElement = node.getPsi();
            KtNamedFunction ktNamedFunction = psiElement instanceof KtNamedFunction ? (KtNamedFunction)psiElement : null;
            Object object2 = bodyExpression = ktNamedFunction != null ? ktNamedFunction.getBodyExpression() : null;
            if (bodyExpression != null && !(bodyExpression instanceof KtBlockExpression)) {
                return true;
            }
        }
        return Intrinsics.areEqual((Object)type, (Object)KtNodeTypes.FUNCTION_LITERAL) || Intrinsics.areEqual((Object)type, (Object)KtNodeTypes.BLOCK) && !Intrinsics.areEqual((Object)parentType, (Object)KtNodeTypes.FUNCTION_LITERAL) && !Intrinsics.areEqual((Object)parentType, (Object)KtNodeTypes.SCRIPT) || Intrinsics.areEqual((Object)type, (Object)KtNodeTypes.CLASS_BODY) || Intrinsics.areEqual((Object)type, (Object)KtTokens.BLOCK_COMMENT) || Intrinsics.areEqual((Object)type, (Object)KDocTokens.KDOC) || Intrinsics.areEqual((Object)type, (Object)KtNodeTypes.STRING_TEMPLATE) || Intrinsics.areEqual((Object)type, (Object)KtNodeTypes.PRIMARY_CONSTRUCTOR) || Intrinsics.areEqual((Object)type, (Object)KtNodeTypes.WHEN) || Intrinsics.areEqual((Object)type, (Object)KtNodeTypes.ANNOTATION_ENTRY) || this.shouldFoldCall(node, document);
    }

    private final boolean shouldFoldCall(ASTNode $this$shouldFoldCall, Document document) {
        Object object;
        block3: {
            block2: {
                KtCallExpression ktCallExpression;
                PsiElement psiElement = $this$shouldFoldCall.getPsi();
                object = psiElement instanceof KtCallExpression ? (KtCallExpression)psiElement : null;
                if (object == null) break block2;
                KtCallExpression it = ktCallExpression = object;
                boolean bl = false;
                object = !(it.getValueArguments().size() < 2) ? ktCallExpression : null;
                if (object != null) break block3;
            }
            return false;
        }
        KtCallExpression call = object;
        return FixersUtilKt.startLine((PsiElement)call, document) != FixersUtilKt.endLine((PsiElement)call, document);
    }

    private final TextRange getRangeToFold(ASTNode node, Document document) {
        IElementType iElementType = node.getElementType();
        if (iElementType instanceof KtFunctionElementType) {
            KtExpression bodyExpression;
            KtNamedFunction function;
            PsiElement psiElement = node.getPsi();
            KtNamedFunction ktNamedFunction = function = psiElement instanceof KtNamedFunction ? (KtNamedFunction)psiElement : null;
            PsiElement funKeyword = ktNamedFunction != null ? ktNamedFunction.getFunKeyword() : null;
            KtNamedFunction ktNamedFunction2 = function;
            Object object = bodyExpression = ktNamedFunction2 != null ? ktNamedFunction2.getBodyExpression() : null;
            if (funKeyword != null && bodyExpression != null && !(bodyExpression instanceof KtBlockExpression)) {
                if (FixersUtilKt.startLine(funKeyword, document) != FixersUtilKt.startLine((PsiElement)bodyExpression, document)) {
                    Object v4;
                    block17: {
                        Sequence $this$firstOrNull$iv = PsiUtilsKt.siblings((PsiElement)((PsiElement)bodyExpression), (boolean)false, (boolean)false);
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            PsiElement it = (PsiElement)element$iv;
                            boolean bl = false;
                            String string = it.getText();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null)) continue;
                            v4 = element$iv;
                            break block17;
                        }
                        v4 = null;
                    }
                    PsiElement lineBreak = v4;
                    if (lineBreak != null) {
                        return new TextRange(PsiUtilsKt.getStartOffset((PsiElement)lineBreak), PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)bodyExpression)));
                    }
                }
                TextRange textRange = bodyExpression.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                return textRange;
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.FUNCTION_LITERAL)) {
            PsiElement rbrace;
            KtFunctionLiteral psi;
            PsiElement funKeyword = node.getPsi();
            KtFunctionLiteral ktFunctionLiteral = psi = funKeyword instanceof KtFunctionLiteral ? (KtFunctionLiteral)funKeyword : null;
            PsiElement lbrace = ktFunctionLiteral != null ? ktFunctionLiteral.getLBrace() : null;
            KtFunctionLiteral ktFunctionLiteral2 = psi;
            Object object = rbrace = ktFunctionLiteral2 != null ? ktFunctionLiteral2.getRBrace() : null;
            if (lbrace != null && rbrace != null) {
                return new TextRange(PsiUtilsKt.getStartOffset((PsiElement)lbrace), PsiUtilsKt.getEndOffset((PsiElement)rbrace));
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.CALL_EXPRESSION)) {
            PsiElement rightParenthesis;
            KtValueArgumentList valueArgumentList;
            PsiElement rbrace = node.getPsi();
            KtCallExpression ktCallExpression = rbrace instanceof KtCallExpression ? (KtCallExpression)rbrace : null;
            KtValueArgumentList ktValueArgumentList = valueArgumentList = ktCallExpression != null ? ktCallExpression.getValueArgumentList() : null;
            PsiElement leftParenthesis = ktValueArgumentList != null ? ktValueArgumentList.getLeftParenthesis() : null;
            KtValueArgumentList ktValueArgumentList2 = valueArgumentList;
            Object object = rightParenthesis = ktValueArgumentList2 != null ? ktValueArgumentList2.getRightParenthesis() : null;
            if (leftParenthesis != null && rightParenthesis != null) {
                return new TextRange(PsiUtilsKt.getStartOffset((PsiElement)leftParenthesis), PsiUtilsKt.getEndOffset((PsiElement)rightParenthesis));
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.WHEN)) {
            PsiElement closeBrace;
            KtWhenExpression whenExpression;
            PsiElement leftParenthesis = node.getPsi();
            KtWhenExpression ktWhenExpression = whenExpression = leftParenthesis instanceof KtWhenExpression ? (KtWhenExpression)leftParenthesis : null;
            PsiElement openBrace = ktWhenExpression != null ? ktWhenExpression.getOpenBrace() : null;
            KtWhenExpression ktWhenExpression2 = whenExpression;
            Object object = closeBrace = ktWhenExpression2 != null ? ktWhenExpression2.getCloseBrace() : null;
            if (openBrace != null && closeBrace != null) {
                return new TextRange(PsiUtilsKt.getStartOffset((PsiElement)openBrace), PsiUtilsKt.getEndOffset((PsiElement)closeBrace));
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.ANNOTATION_ENTRY)) {
            KtValueArgumentList valueArgumentList;
            KtAnnotationEntry annotationEntry;
            PsiElement openBrace = node.getPsi();
            KtAnnotationEntry ktAnnotationEntry = annotationEntry = openBrace instanceof KtAnnotationEntry ? (KtAnnotationEntry)openBrace : null;
            Object object = valueArgumentList = ktAnnotationEntry != null ? ktAnnotationEntry.getValueArgumentList() : null;
            if (valueArgumentList != null) {
                TextRange textRange = valueArgumentList.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                return textRange;
            }
        }
        TextRange textRange = node.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        return textRange;
    }

    @NotNull
    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return Intrinsics.areEqual((Object)node.getElementType(), (Object)KtTokens.BLOCK_COMMENT) ? "/" + this.getFirstLineOfComment(node) + ".../" : (Intrinsics.areEqual((Object)node.getElementType(), (Object)KDocTokens.KDOC) ? "/**" + this.getFirstLineOfComment(node) + "...*/" : (Intrinsics.areEqual((Object)node.getElementType(), (Object)KtNodeTypes.STRING_TEMPLATE) ? "\"\"\"" + this.addSpaceIfNeeded(this.getTrimmedFirstLineOfString(node)) + "...\"\"\"" : (Intrinsics.areEqual((Object)node.getElementType(), (Object)KtNodeTypes.PRIMARY_CONSTRUCTOR) || Intrinsics.areEqual((Object)node.getElementType(), (Object)KtNodeTypes.CALL_EXPRESSION) ? "(...)" : (node.getPsi() instanceof KtImportList ? "..." : "{...}"))));
    }

    private final String getTrimmedFirstLineOfString(ASTNode node) {
        String firstLine;
        String string;
        Object v2;
        block2: {
            String string2 = node.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            String[] stringArray = new String[]{"\n"};
            List lines = StringsKt.split$default((CharSequence)string2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            Sequence $this$firstOrNull$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)lines), KotlinFoldingBuilder::getTrimmedFirstLineOfString$lambda$0);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String p0 = (String)element$iv;
                boolean bl = false;
                boolean bl2 = ((CharSequence)p0).length() > 0;
                if (!bl2) continue;
                v2 = element$iv;
                break block2;
            }
            v2 = null;
        }
        if ((string = (firstLine = (String)v2)) == null) {
            string = "";
        }
        return string;
    }

    private final String addSpaceIfNeeded(String $this$addSpaceIfNeeded) {
        if (((CharSequence)$this$addSpaceIfNeeded).length() == 0 || StringsKt.endsWith$default((String)$this$addSpaceIfNeeded, (String)" ", (boolean)false, (int)2, null)) {
            return $this$addSpaceIfNeeded;
        }
        return $this$addSpaceIfNeeded + " ";
    }

    private final String getFirstLineOfComment(ASTNode node) {
        Object v2;
        block2: {
            String string = node.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String[] stringArray = new String[]{"\n"};
            Iterable $this$firstOrNull$iv = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                boolean bl2 = ((CharSequence)this.getCommentContents(it)).length() > 0;
                if (!bl2) continue;
                v2 = element$iv;
                break block2;
            }
            v2 = null;
        }
        String string = v2;
        if (string == null) {
            return "";
        }
        String targetCommentLine = string;
        return " " + this.getCommentContents(targetCommentLine) + " ";
    }

    private final String getCommentContents(String line) {
        return ((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)((Object)StringsKt.trim((CharSequence)line)).toString(), (CharSequence)"/**"), (CharSequence)"/*"), (CharSequence)"*/"), (CharSequence)"*"))).toString();
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        JavaCodeFoldingSettings settings = JavaCodeFoldingSettings.getInstance();
        if (node.getPsi() instanceof KtImportList) {
            return settings.isCollapseImports();
        }
        IElementType iElementType = node.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType type = iElementType;
        if (Intrinsics.areEqual((Object)type, (Object)KtTokens.BLOCK_COMMENT) || Intrinsics.areEqual((Object)type, (Object)KDocTokens.KDOC)) {
            PsiElement psiElement = node.getPsi();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsi(...)");
            if (this.isFirstElementInFile(psiElement)) {
                return settings.isCollapseFileHeader();
            }
        }
        return false;
    }

    protected boolean isCustomFoldingRoot(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return Intrinsics.areEqual((Object)node.getElementType(), (Object)KtNodeTypes.BLOCK) || Intrinsics.areEqual((Object)node.getElementType(), (Object)KtNodeTypes.CLASS_BODY);
    }

    private final boolean isFirstElementInFile(PsiElement element) {
        PsiElement parent = element.getParent();
        if (parent instanceof PsiFile) {
            Object v0;
            block2: {
                Sequence $this$firstOrNull$iv = (Sequence)PsiUtilsKt.getAllChildren((PsiElement)parent);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl = false;
                    if (!(it.getTextLength() != 0 && !(it instanceof PsiWhiteSpace))) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            PsiElement firstNonWhiteSpace = v0;
            return Intrinsics.areEqual((Object)element, (Object)firstNonWhiteSpace);
        }
        return false;
    }

    private static final String getTrimmedFirstLineOfString$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Object)StringsKt.trim((CharSequence)StringsKt.replace$default((String)it, (String)"\"\"\"", (String)"", (boolean)false, (int)4, null))).toString();
    }
}

