/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.core.impl.actions;

import com.intellij.jupyter.core.core.impl.actions.NotebookCellLinesActionUtil;
import com.intellij.jupyter.core.core.impl.actions.RequiresCellViewUpdate;
import com.intellij.jupyter.core.jupyter.actions.ActionDestination;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookVisualizationUiUtilKt;
import com.intellij.notebooks.visualization.ui.cellsDnD.CellDropEvent;
import com.intellij.notebooks.visualization.ui.cellsDnD.CellDropNotifier;
import com.intellij.notebooks.visualization.ui.cellsDnD.CellDropTarget;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0001\u0015B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J&\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/jupyter/core/core/impl/actions/NotebookCellDropHandler;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/jupyter/core/core/impl/actions/RequiresCellViewUpdate;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "handleCellDrop", "", "event", "Lcom/intellij/notebooks/visualization/ui/cellsDnD/CellDropEvent;", "handleDropAfterLastCell", "moveCells", "cellLines", "Lcom/intellij/notebooks/visualization/NotebookCellLines;", "cellsToMove", "", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "direction", "Lcom/intellij/jupyter/core/jupyter/actions/ActionDestination;", "dispose", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nNotebookCellDropHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookCellDropHandler.kt\ncom/intellij/jupyter/core/core/impl/actions/NotebookCellDropHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1617#2,9:104\n1869#2:113\n1870#2:115\n1626#2:116\n1617#2,9:117\n1869#2:126\n1870#2:128\n1626#2:129\n1617#2,9:130\n1869#2:139\n1870#2:141\n1626#2:142\n1563#2:143\n1634#2,3:144\n1563#2:147\n1634#2,3:148\n1#3:114\n1#3:127\n1#3:140\n*S KotlinDebug\n*F\n+ 1 NotebookCellDropHandler.kt\ncom/intellij/jupyter/core/core/impl/actions/NotebookCellDropHandler\n*L\n48#1:104,9\n48#1:113\n48#1:115\n48#1:116\n54#1:117,9\n54#1:126\n54#1:128\n54#1:129\n58#1:130,9\n58#1:139\n58#1:141\n58#1:142\n75#1:143\n75#1:144,3\n88#1:147\n88#1:148,3\n48#1:114\n54#1:127\n58#1:140\n*E\n"})
public final class NotebookCellDropHandler
implements Disposable,
RequiresCellViewUpdate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private static final Key<NotebookCellDropHandler> JUPYTER_CELL_DROP_HANDLER_KEY;

    public NotebookCellDropHandler(@NotNull EditorImpl editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(CellDropNotifier.Companion.getTopicForEditor((Editor)this.editor), (Object)new CellDropNotifier(){

            public void cellDropped(CellDropEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                CellDropTarget cellDropTarget = event.getTargetCell();
                if (cellDropTarget instanceof CellDropTarget.TargetCell) {
                    this.handleCellDrop(event);
                } else if (cellDropTarget instanceof CellDropTarget.BelowLastCell) {
                    this.handleDropAfterLastCell(event);
                } else {
                    if (cellDropTarget instanceof CellDropTarget.NoCell) {
                        return;
                    }
                    throw new NoWhenBranchMatchedException();
                }
            }
        });
    }

    private final void handleCellDrop(CellDropEvent event) {
        Pair pair;
        int targetOrdinal;
        NotebookCellLines cellLines = NotebookCellLines.Companion.get((Editor)this.editor);
        NotebookCellLines.Interval sourceCell = event.getSourceCell().getInterval();
        CellDropTarget cellDropTarget = event.getTargetCell();
        CellDropTarget.TargetCell targetCell = cellDropTarget instanceof CellDropTarget.TargetCell ? (CellDropTarget.TargetCell)cellDropTarget : null;
        if (targetCell == null || (targetCell = targetCell.getCell()) == null || (targetCell = targetCell.getInterval()) == null) {
            return;
        }
        CellDropTarget.TargetCell targetCell2 = targetCell;
        int sourceOrdinal = sourceCell.getOrdinal();
        if (sourceOrdinal == (targetOrdinal = targetCell2.getOrdinal())) {
            return;
        }
        if (sourceOrdinal == targetOrdinal - 1) {
            return;
        }
        if (targetOrdinal == cellLines.getIntervals().size()) {
            $this$mapNotNull$iv = (Iterable)RangesKt.until((int)(sourceOrdinal + 1), (int)cellLines.getIntervals().size());
            $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            var15_16 = $this$forEach$iv$iv$iv.iterator();
            while (var15_16.hasNext()) {
                element$iv$iv = element$iv$iv$iv = ((IntIterator)var15_16).nextInt();
                $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                it = element$iv$iv;
                boolean bl = false;
                if (NotebookVisualizationUiUtilKt.safeGetCellByOrdinal((Editor)((Editor)this.editor), (int)it) == null) continue;
                $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                destination$iv$iv.add(it$iv$iv);
            }
            ActionDestination actionDestination = ActionDestination.DOWN;
            List list = (List)destination$iv$iv;
            pair = new Pair((Object)list, (Object)actionDestination);
        } else if (sourceOrdinal + 1 == targetOrdinal) {
            pair = new Pair((Object)CollectionsKt.listOf((Object)sourceCell), (Object)ActionDestination.DOWN);
        } else if (sourceOrdinal - 1 == targetOrdinal) {
            pair = new Pair((Object)CollectionsKt.listOf((Object)sourceCell), (Object)ActionDestination.UP);
        } else if (sourceOrdinal < targetOrdinal) {
            $this$mapNotNull$iv = (Iterable)RangesKt.until((int)(sourceOrdinal + 1), (int)targetOrdinal);
            $i$f$mapNotNull = false;
            $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            var15_16 = $this$forEach$iv$iv$iv.iterator();
            while (var15_16.hasNext()) {
                element$iv$iv = element$iv$iv$iv = ((IntIterator)var15_16).nextInt();
                $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                it = element$iv$iv;
                boolean bl = false;
                if (NotebookVisualizationUiUtilKt.safeGetCellByOrdinal((Editor)((Editor)this.editor), (int)it) == null) continue;
                $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                destination$iv$iv.add(it$iv$iv);
            }
            ActionDestination actionDestination = ActionDestination.UP;
            List list = (List)destination$iv$iv;
            pair = new Pair((Object)list, (Object)actionDestination);
        } else {
            $this$mapNotNull$iv = (Iterable)RangesKt.until((int)targetOrdinal, (int)sourceOrdinal);
            $i$f$mapNotNull = false;
            $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            var15_16 = $this$forEach$iv$iv$iv.iterator();
            while (var15_16.hasNext()) {
                element$iv$iv = element$iv$iv$iv = ((IntIterator)var15_16).nextInt();
                $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                it = element$iv$iv;
                boolean bl = false;
                if (NotebookVisualizationUiUtilKt.safeGetCellByOrdinal((Editor)((Editor)this.editor), (int)it) == null) continue;
                $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                destination$iv$iv.add(it$iv$iv);
            }
            ActionDestination actionDestination = ActionDestination.DOWN;
            List list = (List)destination$iv$iv;
            pair = new Pair((Object)list, (Object)actionDestination);
        }
        Pair pair2 = pair;
        List shiftingCells = (List)pair2.component1();
        ActionDestination direction = (ActionDestination)((Object)pair2.component2());
        if (shiftingCells.isEmpty()) {
            return;
        }
        this.moveCells(cellLines, shiftingCells, direction);
    }

    /*
     * WARNING - void declaration
     */
    private final void handleDropAfterLastCell(CellDropEvent event) {
        void $this$mapTo$iv$iv;
        int targetOrdinal;
        NotebookCellLines cellLines = NotebookCellLines.Companion.get((Editor)this.editor);
        NotebookCellLines.Interval sourceCell = event.getSourceCell().getInterval();
        int sourceOrdinal = sourceCell.getOrdinal();
        if (sourceOrdinal == (targetOrdinal = cellLines.getIntervals().size()) - 1) {
            return;
        }
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)(sourceOrdinal + 1), (int)cellLines.getIntervals().size());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(NotebookVisualizationUiUtilKt.getCellByOrdinal((Editor)((Editor)this.editor), (int)it));
        }
        List shiftingCells = (List)destination$iv$iv;
        this.moveCells(cellLines, shiftingCells, ActionDestination.UP);
    }

    private final void moveCells(NotebookCellLines cellLines, List<NotebookCellLines.Interval> cellsToMove, ActionDestination direction) {
        WriteCommandAction.writeCommandAction((Project)this.editor.getProject()).withName(NotebookCellDropHandler.class.getName()).run(() -> NotebookCellDropHandler.moveCells$lambda$0(this, cellLines, cellsToMove, direction));
    }

    public void dispose() {
    }

    /*
     * WARNING - void declaration
     */
    private static final void moveCells$lambda$0(NotebookCellDropHandler this$0, NotebookCellLines $cellLines, List $cellsToMove, ActionDestination $direction) {
        Collection<Integer> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        NotebookCellLinesActionUtil.INSTANCE.shiftCells(this$0.editor, $cellLines, $cellsToMove, $direction);
        Iterable iterable = $cellsToMove;
        Editor editor = (Editor)this$0.editor;
        NotebookCellDropHandler notebookCellDropHandler = this$0;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            NotebookCellLines.Interval interval = (NotebookCellLines.Interval)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getOrdinal());
        }
        collection = (List)destination$iv$iv;
        notebookCellDropHandler.updateAffectedCells(editor, (List)collection);
    }

    static {
        Key key = Key.create((String)"JUPYTER_CELL_DROP_HANDLER_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        JUPYTER_CELL_DROP_HANDLER_KEY = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/jupyter/core/core/impl/actions/NotebookCellDropHandler$Companion;", "", "<init>", "()V", "JUPYTER_CELL_DROP_HANDLER_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/jupyter/core/core/impl/actions/NotebookCellDropHandler;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "install", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public final void install(@NotNull EditorImpl editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            NotebookCellDropHandler handler2 = new NotebookCellDropHandler(editor);
            editor.putUserData(JUPYTER_CELL_DROP_HANDLER_KEY, (Object)handler2);
            Disposer.register((Disposable)editor.getDisposable(), (Disposable)handler2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

