/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.core.impl.actions;

import com.intellij.icons.AllIcons;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellLinesEditorUtils;
import com.intellij.jupyter.core.executor.JupyterExecutionState;
import com.intellij.jupyter.core.executor.kernel.session.restore.JupyterRestoreRemoteSessionWatch;
import com.intellij.jupyter.core.fus.JupyterFeaturesCollector;
import com.intellij.jupyter.core.fus.JupyterFusCellRunStatus;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.helper.JupyterDataContextExtensionsKt;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookCellSelectionModel;
import com.intellij.notebooks.visualization.NotebookCellSelectionModelProviderKt;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.ui.ProgressStatus;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.SpinningProgressIcon;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u001f\u0010\u000f\u001a\t\u0018\u00010\u0010\u00a2\u0006\u0002\b\u00112\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001f\u0010\u0015\u001a\t\u0018\u00010\u0010\u00a2\u0006\u0002\b\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0018\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u001c"}, d2={"Lcom/intellij/jupyter/core/core/impl/actions/NotebookEditorGotoRunCellAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "checkIfEnabledAndVisible", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "createText", "", "Lcom/intellij/openapi/util/NlsSafe;", "jupyterEditor", "executionInfo", "Lcom/intellij/jupyter/core/executor/JupyterExecutionState;", "createDescription", "selectIcon", "Ljavax/swing/Icon;", "logClickEvent", "status", "Lcom/intellij/notebooks/visualization/ui/ProgressStatus;", "isBusyRemoteKernelState", "intellij.jupyter.core"})
public final class NotebookEditorGotoRunCellAction
extends DumbAwareAction {
    public NotebookEditorGotoRunCellAction() {
        this.getTemplatePresentation().putClientProperty(ActionUtil.SHOW_TEXT_IN_TOOLBAR, (Object)true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        EditorImpl jupyterEditor;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        EditorImpl editorImpl = jupyterEditor = JupyterDataContextExtensionsKt.getJupyterEditor(dataContext);
        JupyterExecutionState executionInfo = editorImpl != null ? JupyterExecutionState.Companion.getJupyterExecutionState((Editor)editorImpl) : null;
        e.getPresentation().setEnabledAndVisible(this.checkIfEnabledAndVisible(jupyterEditor));
        if (executionInfo != null) {
            e.getPresentation().setIcon(this.selectIcon(executionInfo));
            e.getPresentation().setText(this.createText(jupyterEditor, executionInfo));
            e.getPresentation().setDescription(this.createDescription(jupyterEditor, executionInfo));
        }
        super.update(e);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        EditorImpl editorImpl = JupyterDataContextExtensionsKt.getJupyterEditor(dataContext);
        if (editorImpl == null) {
            return;
        }
        EditorImpl editor = editorImpl;
        JupyterExecutionState jupyterExecutionState = JupyterExecutionState.Companion.getJupyterExecutionState((Editor)editor);
        if (jupyterExecutionState == null) {
            return;
        }
        JupyterExecutionState executionInfo = jupyterExecutionState;
        NotebookIntervalPointer notebookIntervalPointer = executionInfo.getLastExecutingCell();
        if (notebookIntervalPointer == null) {
            return;
        }
        NotebookIntervalPointer lastExecutedInterval = notebookIntervalPointer;
        ProgressStatus progressStatus = executionInfo.getLastExecutingStatus();
        if (progressStatus == null) {
            return;
        }
        ProgressStatus progressStatus2 = progressStatus;
        NotebookCellLines.Interval interval = lastExecutedInterval.get();
        if (interval == null) {
            return;
        }
        NotebookCellLines.Interval interval2 = interval;
        this.logClickEvent(progressStatus2);
        NotebookCellSelectionModel notebookCellSelectionModel = NotebookCellSelectionModelProviderKt.getCellSelectionModel((Editor)((Editor)editor));
        if (notebookCellSelectionModel != null) {
            notebookCellSelectionModel.selectSingleCell(interval2);
        }
        NotebookCellLinesEditorUtils.INSTANCE.scrollTo((Editor)editor, interval2.getLines().getFirst(), ScrollType.MAKE_VISIBLE);
    }

    private final boolean checkIfEnabledAndVisible(EditorImpl editor) {
        if (editor == null) {
            return false;
        }
        JupyterExecutionState jupyterExecutionState = JupyterExecutionState.Companion.getJupyterExecutionState((Editor)editor);
        if (jupyterExecutionState == null) {
            return false;
        }
        JupyterExecutionState executionInfo = jupyterExecutionState;
        boolean isKernelBusy = editor.getUserData(JupyterRestoreRemoteSessionWatch.Companion.getBUSY_KERNEL_KEY()) != null;
        NotebookIntervalPointer notebookIntervalPointer = executionInfo.getLastExecutingCell();
        if ((notebookIntervalPointer != null ? notebookIntervalPointer.get() : null) == null && !isKernelBusy) {
            return false;
        }
        if (!Registry.Companion.is("jupyter.editor.go.to.toolbar.action")) {
            return false;
        }
        ProgressStatus progressStatus = executionInfo.getLastExecutingStatus();
        return switch (progressStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[progressStatus.ordinal()]) {
            case 1, 2, 3 -> true;
            default -> false;
        };
    }

    private final String createText(EditorImpl jupyterEditor, JupyterExecutionState executionInfo) {
        if (this.isBusyRemoteKernelState(jupyterEditor, executionInfo)) {
            return JupyterBundle.message("jupyter.go.to.remote.busy.text", new Object[0]);
        }
        NotebookIntervalPointer notebookIntervalPointer = executionInfo.getLastExecutingCell();
        if (notebookIntervalPointer == null || (notebookIntervalPointer = notebookIntervalPointer.get()) == null) {
            return null;
        }
        int currentCellNumber = notebookIntervalPointer.getOrdinal() + 1;
        int numQueuedCells = executionInfo.getQueued().size();
        ProgressStatus progressStatus = executionInfo.getLastExecutingStatus();
        return switch (progressStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[progressStatus.ordinal()]) {
            case 1 -> {
                boolean var5_5;
                boolean v2 = var5_5 = numQueuedCells > 1;
                if (var5_5) {
                    Object[] var6_8 = new Object[]{currentCellNumber, numQueuedCells};
                    yield JupyterBundle.message("jupyter.go.to.text.running.and.left", var6_8);
                }
                if (!var5_5) {
                    Object[] var6_9 = new Object[]{currentCellNumber};
                    yield JupyterBundle.message("jupyter.go.to.text.running", var6_9);
                }
                throw new NoWhenBranchMatchedException();
            }
            case 2 -> {
                Object[] var5_6 = new Object[]{currentCellNumber};
                yield JupyterBundle.message("jupyter.go.to.text.ok", var5_6);
            }
            case 3 -> {
                Object[] var5_7 = new Object[]{currentCellNumber};
                yield JupyterBundle.message("jupyter.go.to.text.error", var5_7);
            }
            default -> null;
        };
    }

    private final String createDescription(EditorImpl editor, JupyterExecutionState executionInfo) {
        if (this.isBusyRemoteKernelState(editor, executionInfo)) {
            return JupyterBundle.message("jupyter.go.to.remote.busy.description", new Object[0]);
        }
        NotebookIntervalPointer notebookIntervalPointer = executionInfo.getLastExecutingCell();
        if (notebookIntervalPointer == null || (notebookIntervalPointer = notebookIntervalPointer.get()) == null) {
            return null;
        }
        int currentCellNumber = notebookIntervalPointer.getOrdinal() + 1;
        ProgressStatus progressStatus = executionInfo.getLastExecutingStatus();
        return switch (progressStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[progressStatus.ordinal()]) {
            case 2 -> JupyterBundle.message("jupyter.go.to.description.ok", new Object[0]);
            case 3 -> {
                Object[] var4_4 = new Object[]{currentCellNumber};
                yield JupyterBundle.message("jupyter.go.to.description.error", var4_4);
            }
            default -> null;
        };
    }

    private final Icon selectIcon(JupyterExecutionState executionInfo) {
        Icon icon;
        ProgressStatus progressStatus = executionInfo.getLastExecutingStatus();
        switch (progressStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[progressStatus.ordinal()]) {
            case 1: {
                icon = (Icon)new SpinningProgressIcon(null, 0, 3, null);
                break;
            }
            case 2: {
                Icon icon2 = AllIcons.General.GreenCheckmark;
                icon = icon2;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"GreenCheckmark");
                break;
            }
            case 3: {
                Icon icon3 = AllIcons.Vcs.Remove;
                icon = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Remove");
                break;
            }
            default: {
                Icon icon4 = AllIcons.Empty;
                icon = icon4;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"Empty");
            }
        }
        return icon;
    }

    private final void logClickEvent(ProgressStatus status) {
        ProgressStatus progressStatus = status;
        JupyterFusCellRunStatus fusStatus = switch (progressStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[progressStatus.ordinal()]) {
            case 1 -> JupyterFusCellRunStatus.RUNNING;
            case 2 -> JupyterFusCellRunStatus.STOPPED_OK;
            case 3 -> JupyterFusCellRunStatus.STOPPED_ERR;
            default -> JupyterFusCellRunStatus.UNDEFINED;
        };
        JupyterFeaturesCollector.Companion.onClickGotoButton(fusStatus);
    }

    private final boolean isBusyRemoteKernelState(EditorImpl editor, JupyterExecutionState executionInfo) {
        boolean isKernelBusy = editor.getUserData(JupyterRestoreRemoteSessionWatch.Companion.getBUSY_KERNEL_KEY()) != null;
        return isKernelBusy && executionInfo.getLastExecutingStatus() == ProgressStatus.RUNNING;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProgressStatus.values().length];
            try {
                nArray[ProgressStatus.RUNNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProgressStatus.STOPPED_OK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProgressStatus.STOPPED_ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

