/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash.ui;

import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.RepositoryChangesBrowserNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.actions.ShowDiffWithLocalAction;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.savedPatches.SavedPatchesProvider;
import com.intellij.openapi.vcs.changes.savedPatches.SavedPatchesTree;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserStringNode;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.ui.render.LabelIconCache;
import git4idea.GitCommit;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.stash.GitStashCache;
import git4idea.stash.GitStashTracker;
import git4idea.stash.GitStashTrackerKt;
import git4idea.stash.GitStashTrackerListener;
import git4idea.stash.ui.GitStashActionsKt;
import git4idea.stash.ui.GitStashBranchComponent;
import git4idea.stash.ui.GitStashProvider;
import git4idea.ui.StashInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 B2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0007<=>?@ABB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00032\f\u0010&\u001a\b\u0012\u0004\u0012\u00020$0'H\u0016J\b\u0010(\u001a\u00020)H\u0016J\u0018\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020)H\u0016J\u0016\u0010.\u001a\b\u0012\u0002\b\u0003\u0018\u00010/2\u0006\u00100\u001a\u000201H\u0002J \u00102\u001a\u00020$*\u00020,2\u0006\u00103\u001a\u0002042\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030/H\u0002J\"\u00105\u001a\u00020$2\u0006\u00106\u001a\u0002072\u0010\u00108\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030:09H\u0016J\b\u0010;\u001a\u00020$H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010 \u00a8\u0006C"}, d2={"Lgit4idea/stash/ui/GitStashProvider;", "Lcom/intellij/openapi/vcs/changes/savedPatches/SavedPatchesProvider;", "Lgit4idea/ui/StashInfo;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "parent", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "iconCache", "Lcom/intellij/vcs/log/ui/render/LabelIconCache;", "stashTracker", "Lgit4idea/stash/GitStashTracker;", "getStashTracker", "()Lgit4idea/stash/GitStashTracker;", "stashCache", "Lgit4idea/stash/GitStashCache;", "getStashCache", "()Lgit4idea/stash/GitStashCache;", "dataClass", "Ljava/lang/Class;", "getDataClass", "()Ljava/lang/Class;", "tag", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode$Tag;", "getTag", "()Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode$Tag;", "applyAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "getApplyAction", "()Lcom/intellij/openapi/actionSystem/AnAction;", "popAction", "getPopAction", "subscribeToPatchesListChanges", "", "disposable", "listener", "Lkotlin/Function0;", "isEmpty", "", "buildPatchesTree", "modelBuilder", "Lcom/intellij/openapi/vcs/changes/ui/TreeModelBuilder;", "showRootNode", "createRootNode", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "insertErrorNode", "error", "Lcom/intellij/openapi/vcs/VcsException;", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "selectedObjects", "", "Lcom/intellij/openapi/vcs/changes/savedPatches/SavedPatchesProvider$PatchObject;", "dispose", "GitBundleTag", "MyTag", "StashInfoChangesBrowserNode", "StashRepositoryChangesBrowserNode", "StashObject", "GitStashChange", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitStashProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitStashProvider.kt\ngit4idea/stash/ui/GitStashProvider\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,249:1\n30#2,2:250\n30#2,2:252\n1#3:254\n*S KotlinDebug\n*F\n+ 1 GitStashProvider.kt\ngit4idea/stash/ui/GitStashProvider\n*L\n54#1:250,2\n55#1:252,2\n*E\n"})
public final class GitStashProvider
implements SavedPatchesProvider<StashInfo>,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final LabelIconCache iconCache;
    @NotNull
    private final ChangesBrowserNode.Tag tag;
    @NotNull
    private static final String GIT_STASH_APPLY_ACTION = "Git.Stash.Apply";
    @NotNull
    private static final String GIT_STASH_POP_ACTION = "Git.Stash.Pop";

    public GitStashProvider(@NotNull Project project, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.project = project;
        this.iconCache = new LabelIconCache();
        this.tag = new GitBundleTag("stash.root.node.title");
        Disposer.register((Disposable)parent, (Disposable)this);
        this.getStashTracker().addListener(new GitStashTrackerListener(){

            @Override
            public void stashesUpdated() {
                this.getStashCache().preloadStashes$intellij_vcs_git();
            }
        }, this);
        this.getStashCache().preloadStashes$intellij_vcs_git();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final GitStashTracker getStashTracker() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<GitStashTracker> serviceClass$iv = GitStashTracker.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (GitStashTracker)object;
    }

    private final GitStashCache getStashCache() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<GitStashCache> serviceClass$iv = GitStashCache.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (GitStashCache)object;
    }

    @NotNull
    public Class<StashInfo> getDataClass() {
        return StashInfo.class;
    }

    @NotNull
    public ChangesBrowserNode.Tag getTag() {
        return this.tag;
    }

    @NotNull
    public AnAction getApplyAction() {
        AnAction anAction = ActionManager.getInstance().getAction(GIT_STASH_APPLY_ACTION);
        Intrinsics.checkNotNullExpressionValue((Object)anAction, (String)"getAction(...)");
        return anAction;
    }

    @NotNull
    public AnAction getPopAction() {
        AnAction anAction = ActionManager.getInstance().getAction(GIT_STASH_POP_ACTION);
        Intrinsics.checkNotNullExpressionValue((Object)anAction, (String)"getAction(...)");
        return anAction;
    }

    public void subscribeToPatchesListChanges(@NotNull Disposable disposable, @NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.getStashTracker().addListener(new GitStashTrackerListener(listener2){
            final /* synthetic */ Function0<Unit> $listener;
            {
                this.$listener = $listener;
            }

            public void stashesUpdated() {
                this.$listener.invoke();
            }
        }, disposable);
        listener2.invoke();
    }

    public boolean isEmpty() {
        return !GitStashTrackerKt.isNotEmpty(this.getStashTracker());
    }

    public void buildPatchesTree(@NotNull TreeModelBuilder modelBuilder, boolean showRootNode) {
        ChangesBrowserNode<?> changesBrowserNode;
        Intrinsics.checkNotNullParameter((Object)modelBuilder, (String)"modelBuilder");
        Map<VirtualFile, GitStashTracker.Stashes> stashesMap = this.getStashTracker().getStashes();
        if (showRootNode) {
            var5_4 = new SavedPatchesTree.TagWithCounterChangesBrowserNode(this.getTag(), false, null, 6, null);
            ChangesBrowserNode<?> entry = var5_4;
            boolean bl = false;
            modelBuilder.insertSubtreeRoot((ChangesBrowserNode)entry);
            changesBrowserNode = (ChangesBrowserNode)var5_4;
        } else {
            var5_4 = modelBuilder.myRoot;
            Intrinsics.checkNotNull((Object)var5_4);
            changesBrowserNode = var5_4;
        }
        ChangesBrowserNode<?> stashesRoot = changesBrowserNode;
        for (Map.Entry entry : stashesMap.entrySet()) {
            ChangesBrowserNode<?> changesBrowserNode2;
            VirtualFile root = (VirtualFile)entry.getKey();
            GitStashTracker.Stashes stashesList = (GitStashTracker.Stashes)entry.getValue();
            if (!(stashesMap.size() <= 1 || stashesList instanceof GitStashTracker.Stashes.Loaded && ((GitStashTracker.Stashes.Loaded)stashesList).getStashes().isEmpty())) {
                if (this.createRootNode(root) != null) {
                    ChangesBrowserNode<?> changesBrowserNode3;
                    ChangesBrowserNode<?> it = changesBrowserNode3;
                    boolean bl = false;
                    modelBuilder.insertSubtreeRoot(it, (ChangesBrowserNode)stashesRoot);
                    changesBrowserNode2 = changesBrowserNode3;
                } else {
                    changesBrowserNode2 = stashesRoot;
                }
            } else {
                changesBrowserNode2 = stashesRoot;
            }
            ChangesBrowserNode<?> rootNode = changesBrowserNode2;
            GitStashTracker.Stashes stashes = stashesList;
            if (stashes instanceof GitStashTracker.Stashes.Error) {
                this.insertErrorNode(modelBuilder, ((GitStashTracker.Stashes.Error)stashesList).getError(), rootNode);
                continue;
            }
            if (stashes instanceof GitStashTracker.Stashes.Loaded) {
                for (StashInfo stash : ((GitStashTracker.Stashes.Loaded)stashesList).getStashes()) {
                    modelBuilder.insertSubtreeRoot((ChangesBrowserNode)new StashInfoChangesBrowserNode(new StashObject(stash)), rootNode);
                }
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    private final ChangesBrowserNode<?> createRootNode(VirtualFile root) {
        GitRepository gitRepository = (GitRepository)GitRepositoryManager.getInstance(this.project).getRepositoryForRootQuick(root);
        if (gitRepository == null) {
            return null;
        }
        GitRepository repository2 = gitRepository;
        return (ChangesBrowserNode)new StashRepositoryChangesBrowserNode(repository2);
    }

    private final void insertErrorNode(TreeModelBuilder $this$insertErrorNode, VcsException error, ChangesBrowserNode<?> parent) {
        ChangesBrowserStringNode errorNode = new ChangesBrowserStringNode(error.getLocalizedMessage(), SimpleTextAttributes.ERROR_ATTRIBUTES);
        $this$insertErrorNode.insertSubtreeRoot((ChangesBrowserNode)errorNode, parent);
    }

    public void uiDataSnapshot(@NotNull DataSink sink, @NotNull Iterable<? extends SavedPatchesProvider.PatchObject<?>> selectedObjects) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter(selectedObjects, (String)"selectedObjects");
        sink.set(GitStashActionsKt.getSTASH_INFO(), (Object)JBIterable.from(selectedObjects).map(arg_0 -> GitStashProvider.uiDataSnapshot$lambda$0((Function1)uiDataSnapshot.1.INSTANCE, arg_0)).filter(this.getDataClass()).toList());
    }

    public void dispose() {
        this.getStashCache().clear$intellij_vcs_git();
    }

    private static final Object uiDataSnapshot$lambda$0(Function1 $tmp0, Object p0) {
        return $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0007\u001a\u00020\b*\u0006\u0012\u0002\b\u00030\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lgit4idea/stash/ui/GitStashProvider$Companion;", "", "<init>", "()V", "GIT_STASH_APPLY_ACTION", "", "GIT_STASH_POP_ACTION", "propagateCancellationTo", "", "Ljava/util/concurrent/CompletableFuture;", "future", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public final void propagateCancellationTo(@NotNull CompletableFuture<?> $this$propagateCancellationTo, @NotNull CompletableFuture<?> future) {
            Intrinsics.checkNotNullParameter($this$propagateCancellationTo, (String)"<this>");
            Intrinsics.checkNotNullParameter(future, (String)"future");
            $this$propagateCancellationTo.whenComplete((arg_0, arg_1) -> Companion.propagateCancellationTo$lambda$1((arg_0, arg_1) -> Companion.propagateCancellationTo$lambda$0(future, arg_0, arg_1), arg_0, arg_1));
        }

        private static final Unit propagateCancellationTo$lambda$0(CompletableFuture $future, Object object, Throwable t) {
            if (t instanceof CancellationException) {
                $future.cancel(false);
            }
            return Unit.INSTANCE;
        }

        private static final void propagateCancellationTo$lambda$1(Function2 $tmp0, Object p0, Object p1) {
            $tmp0.invoke(p0, p1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0006\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0007H\u0016R\u0010\u0010\u0002\u001a\u00020\u00038\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lgit4idea/stash/ui/GitStashProvider$GitBundleTag;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode$Tag;", "key", "", "<init>", "(Ljava/lang/String;)V", "toString", "Lorg/jetbrains/annotations/Nls;", "intellij.vcs.git"})
    public static final class GitBundleTag
    implements ChangesBrowserNode.Tag {
        @PropertyKey(resourceBundle="messages.GitBundle")
        @NotNull
        private final String key;

        public GitBundleTag(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.key = key;
        }

        @NotNull
        public String toString() {
            String string = GitBundle.message((String)this.key, (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u0016J\u0018\u0010\u001a\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c\u0012\u0004\u0012\u00020\u001d0\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001e"}, d2={"Lgit4idea/stash/ui/GitStashProvider$GitStashChange;", "Lcom/intellij/openapi/vcs/changes/savedPatches/SavedPatchesProvider$ChangeObject;", "change", "Lcom/intellij/openapi/vcs/changes/Change;", "changeTag", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode$Tag;", "stashName", "", "<init>", "(Lcom/intellij/openapi/vcs/changes/Change;Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode$Tag;Ljava/lang/String;)V", "createDiffRequestProducer", "Lcom/intellij/openapi/vcs/changes/ui/ChangeDiffRequestChain$Producer;", "project", "Lcom/intellij/openapi/project/Project;", "createDiffWithLocalRequestProducer", "useBeforeVersion", "", "asChange", "getFilePath", "Lcom/intellij/openapi/vcs/FilePath;", "originalFilePath", "getOriginalFilePath", "()Lcom/intellij/openapi/vcs/FilePath;", "getFileStatus", "Lcom/intellij/openapi/vcs/FileStatus;", "getTag", "prepareChangeContext", "", "Lcom/intellij/openapi/util/Key;", "", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitStashProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitStashProvider.kt\ngit4idea/stash/ui/GitStashProvider$GitStashChange\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,249:1\n1#2:250\n*E\n"})
    public static final class GitStashChange
    implements SavedPatchesProvider.ChangeObject {
        @NotNull
        private final Change change;
        @Nullable
        private final ChangesBrowserNode.Tag changeTag;
        @NotNull
        private final String stashName;

        public GitStashChange(@NotNull Change change, @Nullable ChangesBrowserNode.Tag changeTag, @NotNull String stashName) {
            Intrinsics.checkNotNullParameter((Object)change, (String)"change");
            Intrinsics.checkNotNullParameter((Object)stashName, (String)"stashName");
            this.change = change;
            this.changeTag = changeTag;
            this.stashName = stashName;
        }

        @Nullable
        public ChangeDiffRequestChain.Producer createDiffRequestProducer(@Nullable Project project) {
            return (ChangeDiffRequestChain.Producer)ChangeDiffRequestProducer.create((Project)project, (Change)this.change, this.prepareChangeContext());
        }

        @Nullable
        public ChangeDiffRequestChain.Producer createDiffWithLocalRequestProducer(@Nullable Project project, boolean useBeforeVersion) {
            Change change = ShowDiffWithLocalAction.getChangeWithLocal((Change)this.change, (boolean)useBeforeVersion, (boolean)useBeforeVersion);
            if (change == null) {
                return null;
            }
            Change changeWithLocal = change;
            return (ChangeDiffRequestChain.Producer)ChangeDiffRequestProducer.create((Project)project, (Change)changeWithLocal, this.prepareChangeContext());
        }

        @NotNull
        public Change asChange() {
            return this.change;
        }

        @NotNull
        public FilePath getFilePath() {
            FilePath filePath = ChangesUtil.getFilePath((Change)this.change);
            Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
            return filePath;
        }

        @Nullable
        public FilePath getOriginalFilePath() {
            return ChangesUtil.getBeforePath((Change)this.change);
        }

        @NotNull
        public FileStatus getFileStatus() {
            FileStatus fileStatus = this.change.getFileStatus();
            Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"getFileStatus(...)");
            return fileStatus;
        }

        @Nullable
        public ChangesBrowserNode.Tag getTag() {
            return this.changeTag;
        }

        private final Map<Key<?>, Object> prepareChangeContext() {
            Map context = new LinkedHashMap();
            ChangesBrowserNode.Tag tag = this.changeTag;
            if (tag != null) {
                ChangesBrowserNode.Tag it = tag;
                boolean bl = false;
                context.put(ChangeDiffRequestProducer.TAG_KEY, it);
            }
            context.put(DiffUserDataKeysEx.VCS_DIFF_RIGHT_CONTENT_TITLE, StringUtil.capitalize((String)this.stashName));
            return context;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0003H\u0016J\t\u0010\t\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\n\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lgit4idea/stash/ui/GitStashProvider$MyTag;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode$Tag;", "text", "", "hash", "Lcom/intellij/vcs/log/Hash;", "<init>", "(Ljava/lang/String;Lcom/intellij/vcs/log/Hash;)V", "toString", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "intellij.vcs.git"})
    private static final class MyTag
    implements ChangesBrowserNode.Tag {
        @NotNull
        private final String text;
        @NotNull
        private final Hash hash;

        public MyTag(@Nls @NotNull String text2, @NotNull Hash hash) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            this.text = text2;
            this.hash = hash;
        }

        @NotNull
        public String toString() {
            return this.text;
        }

        private final String component1() {
            return this.text;
        }

        private final Hash component2() {
            return this.hash;
        }

        @NotNull
        public final MyTag copy(@Nls @NotNull String text2, @NotNull Hash hash) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            return new MyTag(text2, hash);
        }

        public static /* synthetic */ MyTag copy$default(MyTag myTag, String string, Hash hash, int n, Object object) {
            if ((n & 1) != 0) {
                string = myTag.text;
            }
            if ((n & 2) != 0) {
                hash = myTag.hash;
            }
            return myTag.copy(string, hash);
        }

        public int hashCode() {
            int result2 = this.text.hashCode();
            result2 = result2 * 31 + this.hash.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MyTag)) {
                return false;
            }
            MyTag myTag = (MyTag)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)myTag.text)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.hash, (Object)myTag.hash);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00030\u0001B\u0013\u0012\n\u0010\u0004\u001a\u00060\u0002R\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0012\u0010\u0004\u001a\u00060\u0002R\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lgit4idea/stash/ui/GitStashProvider$StashInfoChangesBrowserNode;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "Lgit4idea/stash/ui/GitStashProvider$StashObject;", "Lgit4idea/stash/ui/GitStashProvider;", "stash", "<init>", "(Lgit4idea/stash/ui/GitStashProvider$StashObject;)V", "render", "", "renderer", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer;", "selected", "", "expanded", "hasFocus", "getTextPresentation", "", "intellij.vcs.git"})
    private static final class StashInfoChangesBrowserNode
    extends ChangesBrowserNode<StashObject> {
        @NotNull
        private final StashObject stash;

        public StashInfoChangesBrowserNode(@NotNull StashObject stash) {
            Intrinsics.checkNotNullParameter((Object)stash, (String)"stash");
            super((Object)stash);
            this.stash = stash;
        }

        public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
            Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
            renderer.append(StashInfo.Companion.getSubject(this.stash.getData()));
            Object[] objectArray = new Object[]{this.stash.getData().getStash(), DateFormatUtil.formatDate((long)this.stash.getData().getAuthorTime()), DateFormatUtil.formatTime((long)this.stash.getData().getAuthorTime())};
            renderer.setToolTipText(VcsBundle.message((String)"saved.patch.created.on.date.at.time.tooltip", (Object[])objectArray));
        }

        @NotNull
        public String getTextPresentation() {
            return StashInfo.Companion.getSubject(this.stash.getData());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u0016J\u0010\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0016J\u0012\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0016J\"\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lgit4idea/stash/ui/GitStashProvider$StashObject;", "Lcom/intellij/openapi/vcs/changes/savedPatches/SavedPatchesProvider$PatchObject;", "Lgit4idea/ui/StashInfo;", "data", "<init>", "(Lgit4idea/stash/ui/GitStashProvider;Lgit4idea/ui/StashInfo;)V", "getData", "()Lgit4idea/ui/StashInfo;", "cachedChanges", "", "Lcom/intellij/openapi/vcs/changes/savedPatches/SavedPatchesProvider$ChangeObject;", "loadChanges", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/openapi/vcs/changes/savedPatches/SavedPatchesProvider$LoadingResult;", "toChangeObjects", "", "Lgit4idea/stash/ui/GitStashProvider$GitStashChange;", "Lgit4idea/stash/GitStashCache$StashData$Changes;", "getDiffPreviewTitle", "", "changeName", "getLabelComponent", "Ljavax/swing/JComponent;", "tree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "row", "", "selected", "", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitStashProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitStashProvider.kt\ngit4idea/stash/ui/GitStashProvider$StashObject\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,249:1\n1563#2:250\n1634#2,3:251\n1374#2:254\n1460#2,2:255\n1563#2:257\n1634#2,3:258\n1462#2,3:261\n*S KotlinDebug\n*F\n+ 1 GitStashProvider.kt\ngit4idea/stash/ui/GitStashProvider$StashObject\n*L\n186#1:250\n186#1:251,3\n187#1:254\n187#1:255,2\n189#1:257\n189#1:258,3\n187#1:261,3\n*E\n"})
    public final class StashObject
    implements SavedPatchesProvider.PatchObject<StashInfo> {
        @NotNull
        private final StashInfo data;

        public StashObject(StashInfo data2) {
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            this.data = data2;
        }

        @NotNull
        public StashInfo getData() {
            return this.data;
        }

        @Nullable
        public Collection<SavedPatchesProvider.ChangeObject> cachedChanges() {
            GitStashCache.StashData.Changes changes = GitStashProvider.this.getStashCache().getCachedData(this.getData());
            return changes != null ? this.toChangeObjects(changes) : null;
        }

        @Nullable
        public CompletableFuture<SavedPatchesProvider.LoadingResult> loadChanges() {
            CompletionStage processResults;
            block0: {
                CompletableFuture<GitStashCache.StashData> loadStashData;
                CompletableFuture<GitStashCache.StashData> completableFuture = loadStashData = GitStashProvider.this.getStashCache().loadStashData(this.getData());
                CompletionStage completionStage = processResults = completableFuture != null ? completableFuture.thenApply(arg_0 -> StashObject.loadChanges$lambda$1(arg_0 -> StashObject.loadChanges$lambda$0(this, arg_0), arg_0)) : null;
                if (completionStage == null) break block0;
                Companion.propagateCancellationTo((CompletableFuture<?>)completionStage, loadStashData);
            }
            return processResults;
        }

        /*
         * WARNING - void declaration
         */
        private final List<GitStashChange> toChangeObjects(GitStashCache.StashData.Changes $this$toChangeObjects) {
            void $this$flatMapTo$iv$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = $this$toChangeObjects.getChanges();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Change change = (Change)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new GitStashChange((Change)it, null, this.getData().getStash()));
            }
            List stashChanges = (List)destination$iv$iv;
            Iterable $this$flatMap$iv = $this$toChangeObjects.getParentCommits();
            boolean $i$f$flatMap = false;
            destination$iv$iv = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv2;
                GitCommit parent = (GitCommit)((Object)element$iv$iv);
                boolean bl = false;
                String string = parent.getSubject();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSubject(...)");
                String string2 = StringUtil.capitalize((String)StringsKt.substringBefore$default((String)string, (String)":", null, (int)2, null));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"capitalize(...)");
                Hash hash = parent.getId();
                Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"getId(...)");
                ChangesBrowserNode.Tag tag = new MyTag(string2, hash);
                Collection collection = parent.getChanges();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getChanges(...)");
                Iterable $this$map$iv2 = collection;
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    Change change = (Change)item$iv$iv;
                    Collection collection2 = destination$iv$iv3;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    collection2.add(new GitStashChange((Change)it, tag, this.getData().getStash()));
                }
                Iterable list$iv$iv = (List)destination$iv$iv3;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            List otherChanges = (List)destination$iv$iv2;
            return CollectionsKt.plus((Collection)stashChanges, (Iterable)otherChanges);
        }

        @NotNull
        public String getDiffPreviewTitle(@Nullable String changeName) {
            String string;
            block3: {
                block2: {
                    string = changeName;
                    if (string == null) break block2;
                    String name = string;
                    boolean bl = false;
                    Object[] objectArray = new Object[]{StringsKt.capitalize((String)this.getData().getStash()), name};
                    String string2 = GitBundle.message((String)"stash.editor.diff.preview.id.change.title", (Object[])objectArray);
                    string = string2;
                    if (string2 != null) break block3;
                }
                String string3 = GitBundle.message((String)"stash.editor.diff.preview.empty.title", (Object[])new Object[0]);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            }
            return string;
        }

        @Nullable
        public JComponent getLabelComponent(@NotNull ChangesTree tree, int row, boolean selected) {
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            String string = StashInfo.Companion.getBranchName(this.getData());
            if (string == null) {
                return null;
            }
            String branchName = string;
            GitStashBranchComponent painter = new GitStashBranchComponent(tree, GitStashProvider.this.iconCache);
            painter.customise(branchName, this.getData().getRoot(), row, selected);
            return painter;
        }

        private static final SavedPatchesProvider.LoadingResult loadChanges$lambda$0(StashObject this$0, GitStashCache.StashData stashData) {
            SavedPatchesProvider.LoadingResult loadingResult;
            GitStashCache.StashData stashData2 = stashData;
            if (stashData2 instanceof GitStashCache.StashData.Changes) {
                loadingResult = (SavedPatchesProvider.LoadingResult)new SavedPatchesProvider.LoadingResult.Changes((Collection)this$0.toChangeObjects((GitStashCache.StashData.Changes)stashData));
            } else if (stashData2 instanceof GitStashCache.StashData.Error) {
                loadingResult = (SavedPatchesProvider.LoadingResult)new SavedPatchesProvider.LoadingResult.Error((Throwable)((GitStashCache.StashData.Error)stashData).getError());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return loadingResult;
        }

        private static final SavedPatchesProvider.LoadingResult loadChanges$lambda$1(Function1 $tmp0, Object p0) {
            return (SavedPatchesProvider.LoadingResult)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\u000eH\u0014R!\u0010\u0006\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lgit4idea/stash/ui/GitStashProvider$StashRepositoryChangesBrowserNode;", "Lcom/intellij/dvcs/ui/RepositoryChangesBrowserNode;", "repository", "Lgit4idea/repo/GitRepository;", "<init>", "(Lgit4idea/repo/GitRepository;)V", "stashCount", "Lcom/intellij/openapi/util/ClearableLazyValue;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getCountText", "", "resetCounters", "", "intellij.vcs.git"})
    private static final class StashRepositoryChangesBrowserNode
    extends RepositoryChangesBrowserNode {
        @NotNull
        private final ClearableLazyValue<Integer> stashCount;

        public StashRepositoryChangesBrowserNode(@NotNull GitRepository repository2) {
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            super((Repository)repository2, null, 2, null);
            ClearableLazyValue clearableLazyValue = ClearableLazyValue.create(() -> StashRepositoryChangesBrowserNode.stashCount$lambda$0(this));
            Intrinsics.checkNotNullExpressionValue((Object)clearableLazyValue, (String)"create(...)");
            this.stashCount = clearableLazyValue;
        }

        @NotNull
        protected String getCountText() {
            return FontUtil.spaceAndThinSpace() + this.stashCount.getValue();
        }

        protected void resetCounters() {
            super.resetCounters();
            this.stashCount.drop();
        }

        private static final Integer stashCount$lambda$0(StashRepositoryChangesBrowserNode this$0) {
            return VcsTreeModelData.allUnder((ChangesBrowserNode)((ChangesBrowserNode)this$0)).userObjects(StashObject.class).size();
        }
    }
}

