/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.highlighting;

import com.intellij.jpa.facet.JpaModuleConfiguration;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.NlsActions;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.uast.UastSmartPointer;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B7\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0001\u0012\u000e\b\u0001\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0004J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/jpa/highlighting/JpaLineMarkerActionWrapper;", "Lcom/intellij/openapi/actionSystem/AnAction;", "classPointer", "Lcom/intellij/uast/UastSmartPointer;", "Lorg/jetbrains/uast/UClass;", "originalAction", "actionText", "Ljava/util/function/Supplier;", "", "icon", "Ljavax/swing/Icon;", "<init>", "(Lcom/intellij/uast/UastSmartPointer;Lcom/intellij/openapi/actionSystem/AnAction;Ljava/util/function/Supplier;Ljavax/swing/Icon;)V", "getClassPointer", "()Lcom/intellij/uast/UastSmartPointer;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "substituteEvent", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.javaee.jpa.impl"})
public abstract class JpaLineMarkerActionWrapper
extends AnAction {
    @NotNull
    private final UastSmartPointer<UClass> classPointer;
    @Nullable
    private final AnAction originalAction;

    public JpaLineMarkerActionWrapper(@NotNull UastSmartPointer<UClass> classPointer, @Nullable AnAction originalAction, @NlsActions.ActionText @NotNull Supplier<String> actionText, @NotNull Icon icon) {
        Intrinsics.checkNotNullParameter(classPointer, (String)"classPointer");
        Intrinsics.checkNotNullParameter(actionText, (String)"actionText");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        super(actionText, icon);
        this.classPointer = classPointer;
        this.originalAction = originalAction;
    }

    @NotNull
    protected final UastSmartPointer<UClass> getClassPointer() {
        return this.classPointer;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            AnAction anAction = this.originalAction;
            if (anAction == null) break block0;
            anAction.actionPerformed(this.substituteEvent(e));
        }
    }

    @NotNull
    protected final AnActionEvent substituteEvent(@NotNull AnActionEvent e) {
        AnActionEvent anActionEvent;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        UClass uClass = (UClass)this.classPointer.getElement();
        if (uClass == null || (uClass = uClass.getJavaPsi()) == null) {
            return e;
        }
        UClass psiClass = uClass;
        JpaModuleConfiguration facet = JpaUtil.getJpaFacet(ModuleUtilCore.findModuleForFile((PsiFile)psiClass.getContainingFile()));
        PersistenceClassRole[] persistenceClassRoleArray = PersistenceCommonUtil.getPersistenceRoles((PsiClass)psiClass);
        Intrinsics.checkNotNullExpressionValue((Object)persistenceClassRoleArray, (String)"getPersistenceRoles(...)");
        PersistenceClassRole role = (PersistenceClassRole)ArraysKt.firstOrNull((Object[])persistenceClassRoleArray);
        if (role == null) {
            anActionEvent = e;
        } else {
            AnActionEvent anActionEvent2 = JpaUtil.createEventWithContext(e, facet, role.getPersistenceUnit());
            anActionEvent = anActionEvent2;
            Intrinsics.checkNotNullExpressionValue((Object)anActionEvent2, (String)"createEventWithContext(...)");
        }
        return anActionEvent;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        AnAction anAction = this.originalAction;
        if (anAction == null || (anAction = anAction.getActionUpdateThread()) == null) {
            anAction = ActionUpdateThread.BGT;
        }
        return anAction;
    }
}

