/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.inspections;

import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jpa.highlighting.JpaHighlightingMessages;
import com.intellij.jpa.highlighting.JpaInspectionUtil;
import com.intellij.jpa.inspections.AbstractUastJpaInspection;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmModifiersOwner;
import com.intellij.lang.jvm.actions.ChangeModifierRequest;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.lang.jvm.actions.MemberRequestsKt;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationKt;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.UastVisibility;

public final class JpaObjectClassSignatureInspection
extends AbstractUastJpaInspection {
    @Override
    protected void checkClass(UClass aClass, PersistenceClassRole role, ProblemsHolder holder, boolean isOnTheFly) {
        if (role.getPersistentObject() != null) {
            JpaObjectClassSignatureInspection.checkObjectClassSignature(aClass, role, holder);
        }
    }

    @Override
    protected void checkClassAllRoles(UClass aClass, PersistenceClassRole[] roles, ProblemsHolder holder, boolean isOnTheFly) {
        boolean isError;
        PsiElement sourcePsi = UDeclarationKt.getAnchorPsi((UDeclaration)aClass);
        if (sourcePsi == null) {
            return;
        }
        boolean bl = isError = ContainerUtil.find((Object[])roles, role -> role.getEntityListener() != null) != null && ContainerUtil.find((Object[])roles, role -> role.getPersistentObject() != null) != null;
        if (isError) {
            holder.registerProblem(sourcePsi, JpaHighlightingMessages.message("class.both.persistent.and.entity.listener", aClass.getName()), new LocalQuickFix[0]);
        }
    }

    private static void checkObjectClassSignature(UClass aClass, PersistenceClassRole role, ProblemsHolder holder) {
        PsiElement sourcePsi = UDeclarationKt.getAnchorPsi((UDeclaration)aClass);
        if (sourcePsi == null) {
            return;
        }
        if (!JpaUtil.isHibernateProvider(role)) {
            if (UastUtils.getContainingUClass((UElement)aClass) != null) {
                holder.registerProblem(sourcePsi, JpaHighlightingMessages.message("persistent.object.class.should.be.top.level", aClass.getName()), new LocalQuickFix[0]);
            }
            if (aClass.isFinal()) {
                PsiModifierList modifierList = aClass.getJavaPsi().getModifierList();
                PsiElement finalModifier = modifierList == null ? null : PsiUtil.findModifierInList((PsiModifierList)modifierList, (String)"final");
                PsiElement anchor = finalModifier == null ? sourcePsi : finalModifier;
                holder.registerProblem(anchor, JpaHighlightingMessages.message("persistent.object.class.0.should.not.be.final", aClass.getName()), IntentionWrapper.wrapToQuickFixes((List)JvmElementActionFactories.createModifierActions((JvmModifiersOwner)aClass.getJavaPsi(), (ChangeModifierRequest)MemberRequestsKt.modifierRequest((JvmModifier)JvmModifier.FINAL, (boolean)false)), (PsiFile)sourcePsi.getContainingFile()).toArray(LocalQuickFix.EMPTY_ARRAY));
            }
        }
        if (role.getType() != PersistenceClassRoleEnum.MAPPED_SUPERCLASS) {
            JpaInspectionUtil.checkNoArgConstructorExists(aClass, holder, UastVisibility.PUBLIC, UastVisibility.PROTECTED);
        }
    }
}

