/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.geometry.GeometryUtils;
import org.jetbrains.letsPlot.commons.intern.math.MathKt;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.GeomKind;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.aes.AesScaling;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.TextLegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.HintColorUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.TextUtil;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Label;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Text;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTargetCollector;
import org.jetbrains.letsPlot.core.plot.base.tooltip.TipLayoutHint;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 C2\u00020\u0001:\u0001CB\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0014J:\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00182\u0006\u00102\u001a\u00020\f2\u0006\u00103\u001a\u0002042\u0006\u0010+\u001a\u00020,2\b\u00105\u001a\u0004\u0018\u00010\u0018H\u0016J>\u00106\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00182\u0006\u00102\u001a\u00020\f2\u0006\u00103\u001a\u0002042\u0006\u0010+\u001a\u00020,2\b\u00105\u001a\u0004\u0018\u00010\u0018J:\u00107\u001a\u00020\u00042\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00182\u0006\u00102\u001a\u00020\f2\u0006\u00103\u001a\u0002042\u0006\u0010+\u001a\u00020,2\b\u00105\u001a\u0004\u0018\u00010\u0018H\u0002J0\u00108\u001a\u0002092\u0006\u00101\u001a\u00020\u00182\u0006\u0010:\u001a\u00020\u00182\u0006\u0010;\u001a\u0002042\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0016J\u0018\u0010@\u001a\u00020\f2\b\u0010A\u001a\u0004\u0018\u00010\u000b2\u0006\u0010B\u001a\u00020,R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR(\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001d\u00a8\u0006D"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/TextGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "()V", "checkOverlap", "", "getCheckOverlap", "()Z", "setCheckOverlap", "(Z)V", "formatter", "Lkotlin/Function1;", "", "", "getFormatter", "()Lkotlin/jvm/functions/Function1;", "setFormatter", "(Lkotlin/jvm/functions/Function1;)V", "legendKeyElementFactory", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "myRestrictions", "", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "naValue", "getNaValue", "()Ljava/lang/String;", "setNaValue", "(Ljava/lang/String;)V", "sizeUnit", "getSizeUnit", "setSizeUnit", "buildIntern", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "buildTextComponent", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgGElement;", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "location", "text", "sizeUnitRatio", "", "boundsCenter", "getRect", "hasOverlaps", "objectRectangle", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "textSize", "fontSize", "hAnchor", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$HorizontalAnchor;", "vAnchor", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$VerticalAnchor;", "toString", "label", "geomContext", "Companion", "plot-base"})
@SourceDebugExtension(value={"SMAP\nTextGeom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/TextGeom\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,172:1\n1747#2,3:173\n*S KotlinDebug\n*F\n+ 1 TextGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/TextGeom\n*L\n88#1:173,3\n*E\n"})
public class TextGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Function1<Object, String> formatter;
    @NotNull
    private String naValue = "n/a";
    @Nullable
    private String sizeUnit;
    private boolean checkOverlap;
    @NotNull
    private final List<List<DoubleVector>> myRestrictions = new ArrayList();
    @NotNull
    public static final String DEF_NA_VALUE = "n/a";
    public static final boolean HANDLES_GROUPS = false;
    public static final double BASELINE_TEXT_WIDTH = 6.0;

    @Nullable
    public final Function1<Object, String> getFormatter() {
        return this.formatter;
    }

    public final void setFormatter(@Nullable Function1<Object, String> function1) {
        this.formatter = function1;
    }

    @NotNull
    public final String getNaValue() {
        return this.naValue;
    }

    public final void setNaValue(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.naValue = string;
    }

    @Nullable
    public final String getSizeUnit() {
        return this.sizeUnit;
    }

    public final void setSizeUnit(@Nullable String string) {
        this.sizeUnit = string;
    }

    public final boolean getCheckOverlap() {
        return this.checkOverlap;
    }

    public final void setCheckOverlap(boolean bl) {
        this.checkOverlap = bl;
    }

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return new TextLegendKeyElementFactory();
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        GeomHelper helper2 = new GeomHelper(pos, coord, ctx2);
        GeomTargetCollector targetCollector = this.getGeomTargetCollector(ctx2);
        Function1<DataPointAesthetics, List<Color>> colorsByDataPoint = HintColorUtil.INSTANCE.createColorMarkerMapper(GeomKind.TEXT, ctx2);
        DoubleRectangle doubleRectangle = coord.toClient(ctx2.getAesBounds());
        DoubleVector aesBoundsCenter = doubleRectangle != null ? doubleRectangle.getCenter() : null;
        for (DataPointAesthetics dp : aesthetics2.dataPoints()) {
            DoubleVector loc;
            DoubleVector point2;
            String text2 = this.toString(dp.label(), ctx2);
            if (((CharSequence)text2).length() == 0 || dp.finiteVectorOrNull(Aes.Companion.getX(), Aes.Companion.getY()) == null || helper2.toClient(point2, dp) == null) continue;
            double sizeUnitRatio = AesScaling.INSTANCE.sizeUnitRatio(point2, coord, this.sizeUnit, 6.0);
            if (this.checkOverlap && this.hasOverlaps(dp, loc, text2, sizeUnitRatio, ctx2, aesBoundsCenter)) continue;
            SvgGElement tc = this.buildTextComponent(dp, loc, text2, sizeUnitRatio, ctx2, aesBoundsCenter);
            root.add(tc);
            targetCollector.addPoint(dp.index(), loc, sizeUnitRatio * AesScaling.INSTANCE.textSize(dp) / (double)2, new GeomTargetCollector.TooltipParams(null, null, null, (List)colorsByDataPoint.invoke((Object)dp), 7, null), TipLayoutHint.Kind.CURSOR_TOOLTIP);
        }
    }

    private final boolean hasOverlaps(DataPointAesthetics p, DoubleVector location2, String text2, double sizeUnitRatio, GeomContext ctx2, DoubleVector boundsCenter) {
        boolean bl;
        List<DoubleVector> rectangle;
        block4: {
            rectangle = this.getRect(p, location2, text2, sizeUnitRatio, ctx2, boundsCenter);
            Iterable $this$any$iv = this.myRestrictions;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    List it = (List)element$iv;
                    boolean bl2 = false;
                    if (!GeometryUtils.INSTANCE.arePolygonsIntersected(rectangle, it)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            return true;
        }
        this.myRestrictions.add(rectangle);
        return false;
    }

    @NotNull
    public SvgGElement buildTextComponent(@NotNull DataPointAesthetics p, @NotNull DoubleVector location2, @NotNull String text2, double sizeUnitRatio, @NotNull GeomContext ctx2, @Nullable DoubleVector boundsCenter) {
        double d;
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        Label label2 = new Label(text2, 0, false, 6, null);
        TextUtil.INSTANCE.decorate(label2, p, sizeUnitRatio, true);
        Text.HorizontalAnchor hAnchor = TextUtil.INSTANCE.hAnchor(p, location2, boundsCenter);
        label2.setHorizontalAnchor(hAnchor);
        double fontSize = TextUtil.INSTANCE.fontSize(p, sizeUnitRatio);
        double textHeight = TextUtil.INSTANCE.measure(text2, p, ctx2, sizeUnitRatio).getY();
        switch (WhenMappings.$EnumSwitchMapping$0[TextUtil.INSTANCE.vAnchor(p, location2, boundsCenter).ordinal()]) {
            case 1: {
                d = location2.getY() + fontSize * 0.7;
                break;
            }
            case 2: {
                d = location2.getY() - textHeight + fontSize;
                break;
            }
            case 3: {
                d = location2.getY() - textHeight / (double)2 + fontSize * 0.8;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        double yPosition = d;
        DoubleVector textLocation = new DoubleVector(location2.getX(), yPosition);
        label2.moveTo(textLocation);
        SvgGElement g = new SvgGElement();
        g.children().add(label2.getRootGroup());
        SvgUtils.INSTANCE.transformRotate(g, TextUtil.INSTANCE.angle(p), location2.getX(), location2.getY());
        return g;
    }

    @NotNull
    public DoubleRectangle objectRectangle(@NotNull DoubleVector location2, @NotNull DoubleVector textSize, double fontSize, @NotNull Text.HorizontalAnchor hAnchor, @NotNull Text.VerticalAnchor vAnchor) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Intrinsics.checkNotNullParameter((Object)textSize, (String)"textSize");
        Intrinsics.checkNotNullParameter((Object)((Object)hAnchor), (String)"hAnchor");
        Intrinsics.checkNotNullParameter((Object)((Object)vAnchor), (String)"vAnchor");
        return TextUtil.INSTANCE.rectangleForText(location2, textSize, 0.0, hAnchor, vAnchor);
    }

    @NotNull
    public final List<DoubleVector> getRect(@NotNull DataPointAesthetics p, @NotNull DoubleVector location2, @NotNull String text2, double sizeUnitRatio, @NotNull GeomContext ctx2, @Nullable DoubleVector boundsCenter) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        DoubleVector textSize = TextUtil.INSTANCE.measure(text2, p, ctx2, sizeUnitRatio);
        Text.HorizontalAnchor hAnchor = TextUtil.INSTANCE.hAnchor(p, location2, boundsCenter);
        Text.VerticalAnchor vAnchor = TextUtil.INSTANCE.vAnchor(p, location2, boundsCenter);
        double fontSize = TextUtil.INSTANCE.fontSize(p, sizeUnitRatio);
        double angle = MathKt.toRadians(TextUtil.INSTANCE.angle(p));
        return this.objectRectangle(location2, textSize, fontSize, hAnchor, vAnchor).rotate(angle, location2);
    }

    @NotNull
    public final String toString(@Nullable Object label2, @NotNull GeomContext geomContext) {
        Intrinsics.checkNotNullParameter((Object)geomContext, (String)"geomContext");
        if (label2 == null) {
            return this.naValue;
        }
        Function1<Object, String> function1 = this.formatter;
        if (function1 == null) {
            function1 = geomContext.getDefaultFormatter(Aes.Companion.getLABEL());
        }
        Function1<Object, String> formatter2 = function1;
        return (String)formatter2.invoke(label2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/TextGeom$Companion;", "", "()V", "BASELINE_TEXT_WIDTH", "", "DEF_NA_VALUE", "", "HANDLES_GROUPS", "", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Text.VerticalAnchor.values().length];
            try {
                nArray[Text.VerticalAnchor.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Text.VerticalAnchor.BOTTOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Text.VerticalAnchor.CENTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

